/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.bar;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.bar.MSBar2DBean;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractBarTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;

public class MSBar2DBeanTransferImpl
extends AbstractBarTransfer<MSBar2DBean> {
    public MSBar2DBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("multiSeriesBarChart2D", "\u591a\u7cfb\u52172D\u6761\u5f62\u56fe"));
    }

    @Override
    public String initScript(MSBar2DBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        double[][] data = (double[][])dataNode.getData();
        EChartUtils.checkChartDataIsNull((Object[])data, dataNode.getGroupKeys(), (String[])dataNode.getSeriesKeys());
        return s;
    }

    @Override
    public Option transfer2Opiton(MSBar2DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        String[] labels = dataNode.getGroupKeys();
        double[][] data = (double[][])dataNode.getData();
        Object[] series = (String[])dataNode.getSeriesKeys();
        if (null != p.getLegend()) {
            p.legend().data(series);
        }
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.name(bean.getChart().yScaleUnit);
        valueAxis.position((Object)Position.right);
        p.xAxis().add(valueAxis);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String label : labels) {
            caxis.data().add(label);
        }
        for (int i = 0; i < data.length; ++i) {
            Bar bar = new Bar();
            bar.name((String)series[i]);
            for (int j = 0; j < data[i].length; ++j) {
                bar.data().add(data[i][j]);
            }
            p.series().add(bar);
        }
        p.yAxis().add(caxis);
        return p;
    }

    @Override
    public Option mockOption(MSBar2DBean bean) {
        Option p = super.mockOption(bean);
        EChartUtils.configPlotGradientColor(bean, p);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        p.legend().setData(Arrays.asList(CtrlEXTMessages.getMLS("year2011", "2011\u5e74"), CtrlEXTMessages.getMLS("year2012", "2012\u5e74")));
        p.grid().containLabel(Boolean.TRUE);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setData(Arrays.asList(CtrlEXTMessages.getMLS("brazil", "\u5df4\u897f"), CtrlEXTMessages.getMLS("indonesia", "\u5370\u5c3c"), CtrlEXTMessages.getMLS("unitedStates", "\u7f8e\u56fd"), CtrlEXTMessages.getMLS("india", "\u5370\u5ea6"), CtrlEXTMessages.getMLS("china", "\u4e2d\u56fd"), CtrlEXTMessages.getMLS("worldPopulation", "\u4e16\u754c\u4eba\u53e3(\u767e\u4e07)")));
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.yAxis().add(caxis);
        ValueAxis valueAxis = new ValueAxis();
        EChartUtils.configAxisLucency(bean, (Axis)valueAxis, true);
        p.xAxis().add(valueAxis);
        Bar bar1 = new Bar(CtrlEXTMessages.getMLS("year2011", "2011\u5e74"));
        bar1.setData(Arrays.asList(182, 234, 290, 1049, 1317, 6302));
        EChartUtils.configShowValue(bean, (Series)bar1);
        EChartUtils.configTrendline(bean, (Series)bar1);
        EChartUtils.configAngleRound(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)bar1);
        p.series().add(bar1);
        Bar bar2 = new Bar(CtrlEXTMessages.getMLS("year2012", "2012\u5e74"));
        bar2.setData(Arrays.asList(193, 234, 310, 1215, 1341, 6818));
        EChartUtils.configShowValue(bean, (Series)bar2);
        EChartUtils.configAngleRound(bean, (Series)bar2);
        EChartUtils.configPlotBorder(bean, (Series)bar2);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar2);
        p.series().add(bar2);
        EChartUtils.configMaxMinValue(bean, p, 6818.0, 0.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String initMockScript(MSBar2DBean bean) {
        if (ChartFillColorComboBoxEditor.getGradient().equals(bean.getChart_plotGradientColor())) {
            return super.initMockScript(bean) + EChartUtils.getPlotGradientColor(this.isyValueAxis(), this.isxValueAxis(), this.getColorList());
        }
        return super.initMockScript(bean);
    }
}

