/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.bar;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.PictorialBar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.bar.MSBar3DBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractBarTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;

public class MSBar3DBeanTransferImpl
extends AbstractBarTransfer<MSBar3DBean> {
    public MSBar3DBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("threeDBarChartUsing2DToSimulate", "3d\u591a\u5e8f\u5217\u6761\u5f62\u56fe\uff0c\u4f7f\u75282d\u591a\u5e8f\u5217\u6761\u5f62\u56fe\u6a21\u62df\u62103D\u6548\u679c"));
    }

    @Override
    public String initScript(MSBar3DBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        double[][] data = (double[][])dataNode.getData();
        EChartUtils.checkChartDataIsNull((Object[])data, dataNode.getGroupKeys(), (String[])dataNode.getSeriesKeys());
        return s + this.buildColorStopsLeft(data.length, bean.initColors().size());
    }

    @Override
    public Option transfer2Opiton(MSBar3DBean b, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(b, dataNode);
        String[] groups = dataNode.getGroupKeys();
        double[][] data = (double[][])dataNode.getData();
        Chart chart = b.getChart();
        Object[] series = (String[])dataNode.getSeriesKeys();
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.name(chart.yScaleUnit);
        valueAxis.position((Object)Position.right);
        p.xAxis().add(valueAxis);
        if (null != p.getLegend()) {
            p.legend().data(series);
        }
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String group : groups) {
            caxis.data().add(group);
        }
        for (int i = 0; i < data.length; ++i) {
            Bar bar = new Bar();
            bar.z(Integer.valueOf(1));
            bar.name((String)series[i]);
            bar.itemStyle().normal().color((Object)("function(){return colorStop" + i + " ;}"));
            PictorialBar p2 = new PictorialBar();
            p2.z(Integer.valueOf(2));
            p2.name((String)series[i]);
            p2.tooltip().trigger(Trigger.none);
            p2.symbol((Object)"diamond");
            p2.symbolOffset((Object)"50%", (Object)(TransferUtils.calOffset(series.length, i) + "%"));
            p2.itemStyle().normal().color((Object)"function(index){return colors[((index.seriesIndex + 1) / 2 -1)  % colors.length];}");
            p2.symbolSize((Object)new String[]{"15%", TransferUtils.calSize(series.length, 20.0) + "%"});
            p2.setSymbolPosition((Object)"end");
            for (int j = 0; j < data[i].length; ++j) {
                bar.data().add(data[i][j]);
                if (StringUtil.isEmptyString((String)b.getChart().xAxisMaxValue)) {
                    p2.data().add(data[i][j]);
                    continue;
                }
                Object[] values = (Object[])dataNode.getFormula(FusionChartDataNode.XY_MAX_MIN);
                String mix = String.valueOf(values[2]);
                if (values == null || values.length == 0 || !StringUtil.isEmptyString((String)mix)) {
                    double mixValue = Math.max(Double.parseDouble(mix), Double.parseDouble(b.getChart().xAxisMaxValue));
                    p2.data().add(Math.min(mixValue, data[i][j]));
                    continue;
                }
                p2.data().add(data[i][j]);
            }
            p.series().add(bar);
            p.series().add(p2);
        }
        p.yAxis().add(caxis);
        return p;
    }

    @Override
    public Option mockOption(MSBar3DBean bean) {
        Option p = super.mockOption(bean);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setData(Arrays.asList("2018", "2019", "2020", "2021"));
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.yAxis().add(caxis);
        ValueAxis valueAxis = new ValueAxis();
        EChartUtils.configAxisLucency(bean, (Axis)valueAxis, true);
        p.xAxis().add(valueAxis);
        p.legend().data(Arrays.asList(CtrlEXTMessages.getMLS("shanghai", "\u4e0a\u6d77"), CtrlEXTMessages.getMLS("guangdong", "\u5e7f\u4e1c"), CtrlEXTMessages.getMLS("zhejiang", "\u6d59\u6c5f"), CtrlEXTMessages.getMLS("jiangxi", "\u6c5f\u897f"), CtrlEXTMessages.getMLS("shanxi", "\u5c71\u897f")));
        Bar bar1 = new Bar();
        bar1.name(CtrlEXTMessages.getMLS("shanghai", "\u4e0a\u6d77"));
        bar1.itemStyle().normal().color((Object)new Var("function(){return colorStop0;}"));
        bar1.setData(Arrays.asList(542.0, 642.0, 801.0, 874.0));
        PictorialBar pbar1 = new PictorialBar();
        pbar1.itemStyle().normal().color((Object)new Var("colors[0  % colors.length]"));
        pbar1.tooltip().trigger(Trigger.none);
        pbar1.symbol(Symbol.diamond);
        pbar1.symbolSize(Arrays.asList("15", "17.24137931034483%"));
        pbar1.symbolOffset((Object)"50%", (Object)"-240.0%");
        pbar1.setSymbolPosition((Object)"end");
        pbar1.data(new Object[]{542.0, 642.0, 801.0, 874.0});
        EChartUtils.configShowValue(bean, (Series)bar1);
        EChartUtils.configTrendline(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)pbar1);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar1);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar1);
        p.series().add(bar1);
        p.series().add(pbar1);
        Bar bar2 = new Bar();
        bar2.name(CtrlEXTMessages.getMLS("guangdong", "\u5e7f\u4e1c"));
        bar2.itemStyle().normal().color((Object)new Var("function(){return colorStop1;}"));
        bar2.setData(Arrays.asList(549.0, 564.0, 625.0, 673.0));
        PictorialBar pbar2 = new PictorialBar();
        pbar2.itemStyle().normal().color((Object)new Var("colors[1  % colors.length]"));
        pbar2.tooltip().trigger(Trigger.none);
        pbar2.symbol(Symbol.diamond);
        pbar2.symbolSize(Arrays.asList("15", "17.24137931034483%"));
        pbar2.symbolOffset((Object)"50%", (Object)"-120.0%");
        pbar2.setSymbolPosition((Object)"end");
        pbar2.data(new Object[]{549.0, 564.0, 625.0, 673.0});
        EChartUtils.configShowValue(bean, (Series)bar2);
        EChartUtils.configPlotBorder(bean, (Series)bar2);
        EChartUtils.configPlotBorder(bean, (Series)pbar2);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar2);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar2);
        p.series().add(bar2);
        p.series().add(pbar2);
        Bar bar3 = new Bar();
        bar3.name(CtrlEXTMessages.getMLS("zhejiang", "\u6d59\u6c5f"));
        bar3.itemStyle().normal().color((Object)new Var("function(){return colorStop2;}"));
        bar3.setData(Arrays.asList(526.0, 541.0, 563.0, 605.0));
        PictorialBar pbar3 = new PictorialBar();
        pbar3.itemStyle().normal().color((Object)new Var("colors[2  % colors.length]"));
        pbar3.tooltip().trigger(Trigger.none);
        pbar3.symbol(Symbol.diamond);
        pbar3.symbolSize(Arrays.asList("15", "17.24137931034483%"));
        pbar3.symbolOffset((Object)"50%", (Object)"0.0%");
        pbar3.setSymbolPosition((Object)"end");
        pbar3.data(new Object[]{526.0, 541.0, 563.0, 605.0});
        EChartUtils.configShowValue(bean, (Series)bar3);
        EChartUtils.configPlotBorder(bean, (Series)bar3);
        EChartUtils.configPlotBorder(bean, (Series)pbar3);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar3);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar3);
        p.series().add(bar3);
        p.series().add(pbar3);
        Bar bar4 = new Bar();
        bar4.name(CtrlEXTMessages.getMLS("jiangxi", "\u6c5f\u897f"));
        bar4.itemStyle().normal().color((Object)new Var("function(){return colorStop3;}"));
        bar4.setData(Arrays.asList(436.0, 455.0, 463.0, 488.0));
        PictorialBar pbar4 = new PictorialBar();
        pbar4.itemStyle().normal().color((Object)new Var("colors[3  % colors.length]"));
        pbar4.tooltip().trigger(Trigger.none);
        pbar4.symbol(Symbol.diamond);
        pbar4.symbolSize(Arrays.asList("15", "17.24137931034483%"));
        pbar4.symbolOffset((Object)"50%", (Object)"120.0%");
        pbar4.setSymbolPosition((Object)"end");
        pbar4.data(new Object[]{436.0, 455.0, 463.0, 488.0});
        EChartUtils.configShowValue(bean, (Series)bar4);
        EChartUtils.configPlotBorder(bean, (Series)bar4);
        EChartUtils.configPlotBorder(bean, (Series)pbar4);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar4);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar4);
        p.series().add(bar4);
        p.series().add(pbar4);
        Bar bar5 = new Bar();
        bar5.name(CtrlEXTMessages.getMLS("shanxi", "\u5c71\u897f"));
        bar5.itemStyle().normal().color((Object)new Var("function(){return colorStop4;}"));
        bar5.setData(Arrays.asList(401.0, 412.0, 425.0, 436.0));
        PictorialBar pbar5 = new PictorialBar();
        pbar5.itemStyle().normal().color((Object)new Var("colors[4  % colors.length]"));
        pbar5.tooltip().trigger(Trigger.none);
        pbar5.symbol(Symbol.diamond);
        pbar5.symbolSize(Arrays.asList("15", "17.24137931034483%"));
        pbar5.symbolOffset((Object)"50%", (Object)"240.0%");
        pbar5.setSymbolPosition((Object)"end");
        pbar5.data(new Object[]{401.0, 412.0, 425.0, 436.0});
        EChartUtils.configShowValue(bean, (Series)bar5);
        EChartUtils.configPlotBorder(bean, (Series)bar5);
        EChartUtils.configPlotBorder(bean, (Series)pbar5);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar5);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar5);
        p.series().add(bar5);
        p.series().add(pbar5);
        EChartUtils.configMaxMinValue(bean, p, 874.0, 0.0);
        EChartUtils.hideDrawRB(bean, p, 874.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String initMockScript(MSBar3DBean bean) {
        return super.initMockScript(bean) + this.buildColorStopsUp(5, bean.initColors().size());
    }

    @Override
    public String afterMockScript(MSBar3DBean bean) {
        return super.afterMockScript(bean) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }

    @Override
    public String afterScript(MSBar3DBean b, FusionChartDataNode data, Option p) {
        return super.afterScript(b, data, p) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }
}

