/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.data.SeriesData;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Series;
import com.github.abel533.echarts.style.ItemStyle;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColor1ComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.column.Column2DBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractColumnTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.awt.Color;
import java.util.List;

public class Column2DBeanTransferImpl
extends AbstractColumnTransfer<Column2DBean> {
    public Column2DBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("columnChart2D", "2D\u67f1\u5f62\u56fe"));
    }

    @Override
    public String initScript(Column2DBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        EChartUtils.checkChartDataIsNull((Object[])((double[][])dataNode.getData()), bean.getLables());
        return s;
    }

    @Override
    public Option transfer2Opiton(Column2DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        String[] labels = bean.getLables();
        Chart chart = bean.getChart();
        double[][] data = (double[][])dataNode.getData();
        Bar bar = new Bar();
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.nameTextStyle().width(Integer.valueOf(35));
        valueAxis.name(chart.yScaleUnit);
        p.yAxis().add(valueAxis);
        CategoryAxis caxis = new CategoryAxis();
        for (String label : labels) {
            caxis.data().add(label);
        }
        int size = this.getColorList().size();
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                if (ChartFillColor1ComboBoxEditor.getHetero().equals(chart.plotGradientColor)) {
                    SeriesData seriesData = new SeriesData((Object)data[i][j]);
                    seriesData.itemStyle().color((Object)new Var("colors[" + j % size + "]"));
                    bar.data().add(seriesData);
                    continue;
                }
                bar.data().add(data[i][j]);
            }
        }
        p.xAxis().add(caxis);
        p.series().add(bar);
        return p;
    }

    @Override
    public Option mockOption(Column2DBean bean) {
        Option p = super.mockOption(bean);
        EChartUtils.configPlotGradientColor(bean, p);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, false, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        CategoryAxis caxis = new CategoryAxis();
        caxis.type(AxisType.category);
        caxis.data(new Object[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"});
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        Bar bar = new Bar();
        bar.type(SeriesType.bar);
        List<Color> colorList = this.getColorList();
        int size = colorList.size();
        if (ChartFillColor1ComboBoxEditor.getHetero().equals(bean.getChart_plotGradientColor())) {
            bar.data(new Object[]{new SeriesData((Object)120, new ItemStyle().color((Object)new Var("colors[" + 0 % size + "]"))), new SeriesData((Object)200, new ItemStyle().color((Object)new Var("colors[" + 1 % size + "]"))), new SeriesData((Object)150, new ItemStyle().color((Object)new Var("colors[" + 2 % size + "]"))), new SeriesData((Object)80, new ItemStyle().color((Object)new Var("colors[" + 3 % size + "]"))), new SeriesData((Object)70, new ItemStyle().color((Object)new Var("colors[" + 4 % size + "]"))), new SeriesData((Object)110, new ItemStyle().color((Object)new Var("colors[" + 5 % size + "]"))), new SeriesData((Object)130, new ItemStyle().color((Object)new Var("colors[" + 6 % size + "]")))});
        } else {
            bar.data(new Object[]{120, 200, 150, 80, 70, 110, 130});
        }
        EChartUtils.configShowValue(bean, (Series)bar);
        EChartUtils.configTrendline(bean, (Series)bar);
        EChartUtils.configAngleRound(bean, (Series)bar);
        EChartUtils.configPlotBorder(bean, (Series)bar);
        p.series().add(bar);
        EChartUtils.configMaxMinValue(bean, p, 200.0, 0.0);
        EChartUtils.configSort(bean, p);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String initMockScript(Column2DBean bean) {
        if (ChartFillColorComboBoxEditor.getGradient().equals(bean.getChart_plotGradientColor())) {
            return super.initMockScript(bean) + EChartUtils.getPlotGradientColor(this.isyValueAxis(), this.isxValueAxis(), this.getColorList());
        }
        return super.initMockScript(bean);
    }
}

