/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.Tooltip;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.PictorialBar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.column.Column3DBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractColumnTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;

public class Column3DBeanTransferImpl
extends AbstractColumnTransfer<Column3DBean> {
    public Column3DBeanTransferImpl() {
        super(EChartsType.BAR3D, CtrlEXTMessages.getMLS("columnChart3D", "3D\u67f1\u5f62\u56fe"));
    }

    @Override
    public String initScript(Column3DBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        double[][] data = (double[][])dataNode.getData();
        EChartUtils.checkChartDataIsNull((Object[])data, bean.getLables());
        return s + this.buildColorStopsLeft(data.length, bean.initColors().size());
    }

    @Override
    public Option transfer2Opiton(Column3DBean b, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(b, dataNode);
        String[] labels = b.getLables();
        Chart chart = b.getChart();
        double[][] data = (double[][])dataNode.getData();
        Bar bar = new Bar();
        bar.z(Integer.valueOf(1));
        bar.itemStyle().normal().color((Object)"function(){return colorStop0;}");
        PictorialBar p2 = new PictorialBar();
        p2.z(Integer.valueOf(2));
        p2.tooltip().trigger(Trigger.none);
        p2.symbol((Object)"diamond");
        p2.symbolOffset((Object)0, (Object)"-50%");
        p2.symbolSize((Object)new String[]{"100%", "15%"});
        p2.itemStyle().normal().color((Object)"function(index){return colors[((index.seriesIndex + 1) / 2 -1)  % colors.length];}");
        p2.setSymbolPosition((Object)"end");
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.setSplitNumber(Integer.valueOf(4));
        valueAxis.nameTextStyle().width(Integer.valueOf(35));
        valueAxis.name(chart.yScaleUnit);
        p.yAxis().add(valueAxis);
        CategoryAxis caxis = new CategoryAxis();
        for (String label : labels) {
            caxis.data().add(label);
        }
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                bar.data().add(data[i][j]);
                if (StringUtil.isEmptyString((String)chart.yAxisMaxValue)) {
                    p2.data().add(data[i][j]);
                    continue;
                }
                Object[] values = (Object[])dataNode.getFormula(FusionChartDataNode.XY_MAX_MIN);
                if (values == null || values.length == 0 || !StringUtil.isEmptyString((String)String.valueOf(values[2]))) {
                    p2.data().add(Math.min(Double.parseDouble(chart.yAxisMaxValue), data[i][j]));
                    continue;
                }
                p2.data().add(data[i][j]);
            }
        }
        p.xAxis().add(caxis);
        p.series().add(bar);
        p.series().add(p2);
        return p;
    }

    @Override
    public String initMockScript(Column3DBean bean) {
        return super.initMockScript(bean) + this.buildColorStopsLeft(3, bean.initColors().size());
    }

    @Override
    public Option mockOption(Column3DBean bean) {
        Option p = super.mockOption(bean);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, false, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        CategoryAxis caxis = new CategoryAxis();
        caxis.type(AxisType.category);
        caxis.data(new Object[]{CtrlEXTMessages.getMLS("apple", "\u82f9\u679c"), CtrlEXTMessages.getMLS("banana", "\u9999\u8549"), CtrlEXTMessages.getMLS("pear", "\u68a8")});
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        Bar bar = new Bar();
        bar.itemStyle().normal().color((Object)new Var("function(){return colorStop0;}"));
        bar.type(SeriesType.bar);
        bar.data(new Object[]{152.0, 214.0, 645.0});
        EChartUtils.configShowValue(bean, (Series)bar);
        EChartUtils.configTrendline(bean, (Series)bar);
        EChartUtils.configPlotBorder(bean, (Series)bar);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar);
        p.series().add(bar);
        bar = new Bar();
        bar.itemStyle().normal().color((Object)new Var("colors[0]"));
        bar.type(SeriesType.pictorialBar);
        bar.tooltip(new Tooltip().trigger(Trigger.none));
        bar.symbol(Symbol.diamond);
        bar.symbolSize((Object)new String[]{"100%", "15%"});
        bar.symbolOffset((Object)"0", (Object)"-50%");
        bar.setSymbolPosition((Object)"end");
        bar.data(new Object[]{152.0, 214.0, 645.0});
        EChartUtils.configPlotBorder(bean, (Series)bar);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)bar);
        p.series().add(bar);
        EChartUtils.configMaxMinValue(bean, p, 645.0, 0.0);
        EChartUtils.hideDrawRB(bean, p, 645.0);
        EChartUtils.configSort(bean, p);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String afterScript(Column3DBean b, FusionChartDataNode data, Option p) {
        String script = super.afterScript(b, data, p);
        TransferUtils.rewriteYAxis(p);
        return script;
    }
}

