/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.PictorialBar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.column.MSColumn3DBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractColumnTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;

public class MSColumn3DBeanTransferImpl
extends AbstractColumnTransfer<MSColumn3DBean> {
    public MSColumn3DBeanTransferImpl() {
        super(EChartsType.BAR3D, CtrlEXTMessages.getMLS("multiSequence3DColumnChart", "\u591a\u5e8f\u52173d\u67f1\u5f62\u56fe"));
    }

    @Override
    public String initScript(MSColumn3DBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        double[][] data = (double[][])dataNode.getData();
        EChartUtils.checkChartDataIsNull((Object[])data, dataNode.getGroupKeys(), (String[])dataNode.getSeriesKeys());
        return s + this.buildColorStopsLeft(data.length, bean.initColors().size());
    }

    @Override
    public Option transfer2Opiton(MSColumn3DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        Chart chart = bean.getChart();
        String[] labels = dataNode.getGroupKeys();
        double[][] data = (double[][])dataNode.getData();
        Object[] series = (String[])dataNode.getSeriesKeys();
        if (null != p.getLegend()) {
            p.legend().data(series);
        }
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.nameTextStyle().width(Integer.valueOf(35));
        valueAxis.name(bean.getChart().yScaleUnit);
        p.yAxis().add(valueAxis);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String label : labels) {
            caxis.data().add(label);
        }
        for (int i = 0; i < data.length; ++i) {
            Bar bar = new Bar();
            bar.z(Integer.valueOf(1));
            bar.name((String)series[i]);
            bar.itemStyle().normal().color((Object)("function(){return colorStop" + i + " ;}"));
            bar.barGap("20%");
            PictorialBar p2 = new PictorialBar();
            p2.name((String)series[i]);
            p2.z(Integer.valueOf(2));
            p2.tooltip().trigger(Trigger.none);
            p2.symbol((Object)"diamond");
            p2.symbolOffset((Object)(TransferUtils.calOffset(series.length, i) + "%"), (Object)"-50%");
            p2.symbolSize((Object)new String[]{TransferUtils.calSize(series.length, 20.0) + "%", "15%"});
            p2.itemStyle().normal().color((Object)"function(index){return colors[((index.seriesIndex + 1) / 2 -1)  % colors.length];}");
            p2.setSymbolPosition((Object)"end");
            for (int j = 0; j < data[i].length; ++j) {
                bar.data().add(data[i][j]);
                if (StringUtil.isEmptyString((String)bean.getChart().yAxisMaxValue)) {
                    p2.data().add(data[i][j]);
                    continue;
                }
                Object[] values = (Object[])dataNode.getFormula(FusionChartDataNode.XY_MAX_MIN);
                if (values == null || values.length == 0 || !StringUtil.isEmptyString((String)String.valueOf(values[2]))) {
                    p2.data().add(Math.min(Double.parseDouble(bean.getChart().yAxisMaxValue), data[i][j]));
                    continue;
                }
                p2.data().add(data[i][j]);
            }
            p.series().add(bar);
            p.series().add(p2);
        }
        p.xAxis().add(caxis);
        return p;
    }

    @Override
    public Option mockOption(MSColumn3DBean bean) {
        Option p = super.mockOption(bean);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setData(Arrays.asList(CtrlEXTMessages.getMLS("apple", "\u82f9\u679c"), CtrlEXTMessages.getMLS("banana", "\u9999\u8549"), CtrlEXTMessages.getMLS("pear", "\u68a8")));
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        p.legend().data(Arrays.asList(CtrlEXTMessages.getMLS("guangdong", "\u5e7f\u4e1c"), CtrlEXTMessages.getMLS("shenzhen", "\u6df1\u5733"), "\u5357\u660c", "\u4e0a\u6d77", "\u5317\u4eac"));
        Bar bar1 = new Bar();
        bar1.name(CtrlEXTMessages.getMLS("guangdong", "\u5e7f\u4e1c"));
        bar1.barGap("20%");
        bar1.itemStyle().normal().color((Object)new Var("function(){return colorStop0;}"));
        bar1.setData(Arrays.asList(152.0, 214.0, 645.0));
        PictorialBar pbar1 = new PictorialBar();
        pbar1.name(CtrlEXTMessages.getMLS("guangdong", "\u5e7f\u4e1c"));
        pbar1.itemStyle().normal().color((Object)"function(index){return colors[((index.seriesIndex + 1) / 2 -1)  % colors.length];}");
        pbar1.tooltip().trigger(Trigger.none);
        pbar1.symbol(Symbol.diamond);
        pbar1.symbolSize(Arrays.asList("17.24137931034483%", "15"));
        pbar1.symbolOffset(new Object[]{"-240.0%", "-50%"});
        pbar1.setSymbolPosition((Object)"end");
        pbar1.data(new Object[]{152.0, 214.0, 645.0});
        EChartUtils.configShowValue(bean, (Series)bar1);
        EChartUtils.configTrendline(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)bar1);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)pbar1);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar1);
        p.series().add(bar1);
        p.series().add(pbar1);
        Bar bar2 = new Bar();
        bar2.name(CtrlEXTMessages.getMLS("shenzhen", "\u6df1\u5733"));
        bar2.barGap("20%");
        bar2.itemStyle().normal().color((Object)new Var("function(){return colorStop1;}"));
        bar2.setData(Arrays.asList(121.0, 220.0, 415.0));
        PictorialBar pbar2 = new PictorialBar();
        pbar2.name(CtrlEXTMessages.getMLS("shenzhen", "\u6df1\u5733"));
        pbar2.itemStyle().normal().color((Object)"function(index){return colors[((index.seriesIndex + 1) / 2 -1)  % colors.length];}");
        pbar2.tooltip().trigger(Trigger.none);
        pbar2.symbol(Symbol.diamond);
        pbar2.symbolSize(Arrays.asList("17.24137931034483%", "15"));
        pbar2.symbolOffset(new Object[]{"-120.0%", "-50%"});
        pbar2.setSymbolPosition((Object)"end");
        pbar2.data(new Object[]{121.0, 220.0, 415.0});
        EChartUtils.configShowValue(bean, (Series)bar2);
        EChartUtils.configPlotBorder(bean, (Series)bar2);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar2);
        EChartUtils.configPlotBorder(bean, (Series)pbar2);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar2);
        p.series().add(bar2);
        p.series().add(pbar2);
        Bar bar3 = new Bar();
        PictorialBar pbar3 = new PictorialBar();
        bar3.name(CtrlEXTMessages.getMLS("nanchang", "\u5357\u660c"));
        bar3.barGap("20%");
        bar3.itemStyle().normal().color((Object)new Var("function(){return colorStop2;}"));
        bar3.setData(Arrays.asList(102.0, 124.0, 253.0));
        pbar3 = new PictorialBar();
        pbar3.name(CtrlEXTMessages.getMLS("nanchang", "\u5357\u660c"));
        pbar3.itemStyle().normal().color((Object)new Var("colors[2]"));
        pbar3.tooltip().trigger(Trigger.none);
        pbar3.symbol(Symbol.diamond);
        pbar3.symbolSize(Arrays.asList("17.24137931034483%", "15"));
        pbar3.symbolOffset(new Object[]{"-0.0%", "-50%"});
        pbar3.setSymbolPosition((Object)"end");
        pbar3.data(new Object[]{102.0, 124.0, 253.0});
        EChartUtils.configShowValue(bean, (Series)bar3);
        EChartUtils.configPlotBorder(bean, (Series)bar3);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar3);
        EChartUtils.configPlotBorder(bean, (Series)pbar3);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar3);
        p.series().add(bar3);
        p.series().add(pbar3);
        Bar bar4 = new Bar();
        PictorialBar pbar4 = new PictorialBar();
        bar4.name(CtrlEXTMessages.getMLS("shanghai", "\u4e0a\u6d77"));
        bar4.barGap("20%");
        bar4.itemStyle().normal().color((Object)new Var("function(){return colorStop3;}"));
        bar4.setData(Arrays.asList(154.0, 125.0, 326.0));
        pbar4 = new PictorialBar();
        pbar4.name(CtrlEXTMessages.getMLS("shanghai", "\u4e0a\u6d77"));
        pbar4.itemStyle().normal().color((Object)new Var("colors[3]"));
        pbar4.tooltip().trigger(Trigger.none);
        pbar4.symbol(Symbol.diamond);
        pbar4.symbolSize(Arrays.asList("17.24137931034483%", "15"));
        pbar4.symbolOffset(new Object[]{"120.0%", "-50%"});
        pbar4.setSymbolPosition((Object)"end");
        pbar4.data(new Object[]{154.0, 125.0, 326.0});
        EChartUtils.configShowValue(bean, (Series)bar4);
        EChartUtils.configPlotBorder(bean, (Series)bar4);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar4);
        EChartUtils.configPlotBorder(bean, (Series)pbar4);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar4);
        p.series().add(bar4);
        p.series().add(pbar4);
        Bar bar5 = new Bar();
        PictorialBar pbar5 = new PictorialBar();
        bar5.name(CtrlEXTMessages.getMLS("beijing", "\u5317\u4eac"));
        bar5.barGap("20%");
        bar5.itemStyle().normal().color((Object)new Var("function(){return colorStop4;}"));
        bar5.setData(Arrays.asList(125.0, 145.0, 541.0));
        pbar5 = new PictorialBar();
        pbar5.name(CtrlEXTMessages.getMLS("beijing", "\u5317\u4eac"));
        pbar5.itemStyle().normal().color((Object)new Var("colors[4]"));
        pbar5.tooltip().trigger(Trigger.none);
        pbar5.symbol(Symbol.diamond);
        pbar5.symbolSize(Arrays.asList("17.24137931034483%", "15"));
        pbar5.symbolOffset(new Object[]{"240.0%", "-50%"});
        pbar5.setSymbolPosition((Object)"end");
        pbar5.data(new Object[]{125.0, 145.0, 541.0});
        EChartUtils.configShowValue(bean, (Series)bar5);
        EChartUtils.configPlotBorder(bean, (Series)bar5);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar5);
        EChartUtils.configPlotBorder(bean, (Series)pbar5);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar5);
        p.series().add(bar5);
        p.series().add(pbar5);
        EChartUtils.configMaxMinValue(bean, p, 645.0, 0.0);
        EChartUtils.hideDrawRB(bean, p, 645.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String initMockScript(MSColumn3DBean bean) {
        return super.initMockScript(bean) + this.buildColorStopsLeft(5, bean.initColors().size());
    }

    @Override
    public String afterMockScript(MSColumn3DBean bean) {
        return super.afterMockScript(bean) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }

    @Override
    public String afterScript(MSColumn3DBean b, FusionChartDataNode data, Option p) {
        String script = super.afterScript(b, data, p);
        TransferUtils.rewriteYAxis(p);
        return script + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }
}

