/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.column.StackedMSColumn2DBean;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractStackedTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;

public class MSStackedColumn2DBeanTransferImpl
extends AbstractStackedTransfer<StackedMSColumn2DBean> {
    public MSStackedColumn2DBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("multiSeriesStackedColumnChart2D", "\u591a\u7cfb\u5217\u5806\u79ef2D\u67f1\u5f62\u56fe"));
    }

    @Override
    public Option transfer2Opiton(StackedMSColumn2DBean bean, FusionChartDataNode dataNode) {
        if (null == this.seriesNames || null == this.dataValues) {
            return null;
        }
        Option p = super.transfer2Opiton(bean, dataNode);
        String[][] series = new String[this.seriesNames.length][];
        for (int i = 0; i < this.seriesNames.length; ++i) {
            series[i] = (String[])this.seriesNames[i];
        }
        if (null != p.getLegend()) {
            p.legend().data(ChartDataTransferUtil.parseValue2StringArray(series));
        }
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.nameTextStyle().width(Integer.valueOf(35));
        valueAxis.name(bean.getChart().yScaleUnit);
        p.yAxis().add(valueAxis);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String group : this.groups) {
            caxis.data().add(group);
        }
        if (this.dataValues instanceof double[][]) {
            int index = 0;
            for (int i = 0; i < series.length; ++i) {
                int length = series[i].length;
                if (length <= 0) continue;
                for (int j = 0; j < length; ++j) {
                    Bar bar = new Bar();
                    bar.name(series[i][j]);
                    bar.stack(this.groups[i]);
                    for (int n = 0; n < ((double[][])this.dataValues)[index].length; ++n) {
                        bar.data().add(((double[][])this.dataValues)[index][n]);
                    }
                    ++index;
                    p.series().add(bar);
                }
            }
        }
        for (int i = 0; i < this.dataValues.length && this.groups.length > i; ++i) {
            int j;
            if (this.dataValues[i] instanceof double[][]) {
                double[][] data = (double[][])this.dataValues[i];
                for (j = 0; j < data.length; ++j) {
                    Bar bar = new Bar();
                    bar.name(series[i][j]);
                    bar.stack(this.groups[i]);
                    for (int n = 0; n < data[j].length; ++n) {
                        bar.data().add(data[j][n]);
                    }
                    p.series().add(bar);
                }
                continue;
            }
            if (!(this.dataValues[i] instanceof Variant[][])) continue;
            Variant[][] data = (Variant[][])this.dataValues[i];
            if (dataNode.isSerialByCol()) {
                Variant[][] tempData = new Variant[data[0].length][data.length];
                for (int j2 = 0; j2 < data.length; ++j2) {
                    for (int k = 0; k < data[0].length; ++k) {
                        tempData[k][j2] = data[j2][k];
                    }
                }
                data = tempData;
            }
            for (j = 0; j < data.length; ++j) {
                Bar bar = new Bar();
                bar.name(series[i][j]);
                bar.stack(this.groups[i]);
                for (int n = 0; n < data[j].length; ++n) {
                    bar.data().add(data[j][n].getValue());
                }
                p.series().add(bar);
            }
        }
        p.xAxis().add(caxis);
        return p;
    }

    @Override
    public String initMockScript(StackedMSColumn2DBean bean) {
        if (ChartFillColorComboBoxEditor.getGradient().equals(bean.getChart_plotGradientColor())) {
            return super.initMockScript(bean) + EChartUtils.getPlotGradientColor(this.isyValueAxis(), this.isxValueAxis(), this.getColorList());
        }
        return super.initMockScript(bean);
    }

    @Override
    public Option mockOption(StackedMSColumn2DBean bean) {
        Option p = super.mockOption(bean);
        EChartUtils.configPlotGradientColor(bean, p);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        CategoryAxis caxis = new CategoryAxis();
        caxis.data(new Object[]{CtrlEXTMessages.getMLS("monday", "\u5468\u4e00"), CtrlEXTMessages.getMLS("tuesday", "\u5468\u4e8c"), CtrlEXTMessages.getMLS("wednesday", "\u5468\u4e09"), CtrlEXTMessages.getMLS("thursday", "\u5468\u56db"), CtrlEXTMessages.getMLS("friday", "\u5468\u4e94"), CtrlEXTMessages.getMLS("saturday", "\u5468\u516d"), CtrlEXTMessages.getMLS("sunday", "\u5468\u65e5")});
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        p.legend().data(Arrays.asList(CtrlEXTMessages.getMLS("directVisit", "\u76f4\u63a5\u8bbf\u95ee"), CtrlEXTMessages.getMLS("emailMarketing", "\u90ae\u4ef6\u8425\u9500"), CtrlEXTMessages.getMLS("affiliateAdvertising", "\u8054\u76df\u5e7f\u544a"), CtrlEXTMessages.getMLS("videoAdvertising", "\u89c6\u9891\u5e7f\u544a"), CtrlEXTMessages.getMLS("searchEngine", "\u641c\u7d22\u5f15\u64ce"), CtrlEXTMessages.getMLS("baidu", "\u767e\u5ea6"), CtrlEXTMessages.getMLS("google", "\u8c37\u6b4c"), CtrlEXTMessages.getMLS("bing", "\u5fc5\u5e94"), CtrlEXTMessages.getMLS("other", "\u5176\u4ed6")));
        p.grid().containLabel(Boolean.valueOf(true));
        Bar bar1 = new Bar();
        bar1.name(CtrlEXTMessages.getMLS("emailMarketing", "\u90ae\u4ef6\u8425\u9500"));
        bar1.stack(CtrlEXTMessages.getMLS("advertising", "\u5e7f\u544a"));
        bar1.setData(Arrays.asList(120, 132, 101, 134, 90, 230, 210));
        EChartUtils.configShowValue(bean, (Series)bar1);
        EChartUtils.configTrendline(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)bar1);
        p.series().add(bar1);
        bar1 = new Bar();
        bar1.name(CtrlEXTMessages.getMLS("affiliateAdvertising", "\u8054\u76df\u5e7f\u544a"));
        bar1.stack(CtrlEXTMessages.getMLS("advertising", "\u5e7f\u544a"));
        bar1.setData(Arrays.asList(220, 182, 191, 234, 290, 330, 310));
        EChartUtils.configShowValue(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)bar1);
        EChartUtils.configAngleRound(bean, (Series)bar1);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar1);
        p.series().add(bar1);
        bar1 = new Bar();
        bar1.name(CtrlEXTMessages.getMLS("google", "\u8c37\u6b4c"));
        bar1.stack(CtrlEXTMessages.getMLS("searchEngine", "\u641c\u7d22\u5f15\u64ce"));
        bar1.setData(Arrays.asList(120, 132, 101, 134, 290, 230, 220));
        EChartUtils.configShowValue(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)bar1);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar1);
        p.series().add(bar1);
        bar1 = new Bar();
        bar1.name(CtrlEXTMessages.getMLS("bing", "\u5fc5\u5e94"));
        bar1.stack(CtrlEXTMessages.getMLS("searchEngine", "\u641c\u7d22\u5f15\u64ce"));
        bar1.setData(Arrays.asList(60, 72, 71, 74, 190, 130, 110));
        EChartUtils.configShowValue(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)bar1);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar1);
        p.series().add(bar1);
        bar1 = new Bar();
        bar1.name(CtrlEXTMessages.getMLS("other", "\u5176\u4ed6"));
        bar1.stack(CtrlEXTMessages.getMLS("searchEngine", "\u641c\u7d22\u5f15\u64ce"));
        bar1.setData(Arrays.asList(62, 82, 91, 84, 109, 110, 120));
        EChartUtils.configShowValue(bean, (Series)bar1);
        EChartUtils.configAngleRound(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)bar1);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar1);
        p.series().add(bar1);
        EChartUtils.configMaxMinValue(bean, p, 1649.0, 0.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String afterMockScript(StackedMSColumn2DBean bean) {
        String str = "";
        if (bean.getChart_useRoundEdges().getBooleanValue().booleanValue()) {
            str = str + JSUtils.STACKED_DROUNDCORNERSRESIZE;
        }
        return str + super.afterMockScript(bean);
    }

    @Override
    public String afterScript(StackedMSColumn2DBean b, FusionChartDataNode data, Option p) {
        String s = super.afterScript(b, data, p);
        if ("1".equals(b.getChart().useRoundEdges)) {
            s = s + JSUtils.STACKED_DROUNDCORNERSRESIZE;
        }
        return s;
    }
}

