/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.PictorialBar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.combination.MSColumn3DLineBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.util.FusionChartXmlBuilder;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractColumnTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CombinationColumn3DLineBeanTransferImpl
extends AbstractColumnTransfer<MSColumn3DLineBean> {
    private List<Series<Bar>> otherSeries = new ArrayList<Series<Bar>>();
    private List<Series> barSeries = new ArrayList<Series>();

    public CombinationColumn3DLineBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("threeDColumnChartWithLineChart", "\u4f7f\u75283d\u67f1\u5f62\u56fe\u6a21\u62df3d\u6548\u679c\u5e76\u52a0\u4e0a\u6298\u7ebf\u56fe"));
    }

    @Override
    public String initScript(MSColumn3DLineBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        double[][] data = new double[this.seriesNames.length][this.seriesNames.length];
        return s + this.buildColorStopsLeft(data.length, bean.initColors().size());
    }

    @Override
    public Option transfer2Opiton(MSColumn3DLineBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        Chart chart = bean.getChart();
        List asList = com.kingdee.bos.util.backport.Arrays.asList((Object[])this.seriesNames);
        if (null != p.getLegend()) {
            p.legend().data(asList);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String group : this.groups) {
            caxis.data().add(group);
        }
        int tLen = this.types.length;
        for (int i = 0; i < tLen; ++i) {
            Bar serie = new Bar();
            serie.z(Integer.valueOf(1));
            boolean createBar = true;
            if (TransferUtils.isLineType(this.types[i])) {
                serie = new Line();
                this.otherSeries.add((Series<Bar>)serie);
                createBar = false;
            } else if (TransferUtils.isAreaType(this.types[i])) {
                serie = new Line();
                this.otherSeries.add((Series<Bar>)serie);
                ((Line)serie).areaStyle();
                createBar = false;
            }
            String name = asList.get(i).toString();
            serie.name(name);
            String chartYAxis = FusionChartXmlBuilder.getChartYAxis(this.yAxis[i]);
            serie.yAxisIndex(Integer.valueOf(0));
            if (createBar) {
                this.barSeries.add((Series)serie);
            }
            TransferUtils.fillData(this.dataValues, i, (Series)serie);
        }
        int barSerieSize = this.barSeries.size();
        ArrayList<Object> serieList = new ArrayList<Object>(barSerieSize);
        for (int i = 0; i < barSerieSize; ++i) {
            Series bar = this.barSeries.get(i);
            serieList.add(bar);
            bar.itemStyle().normal().color((Object)("function(){return colorStop" + i + " ;}"));
            PictorialBar p2 = new PictorialBar();
            p2.z(Integer.valueOf(2));
            p2.symbol((Object)"diamond");
            p2.symbolOffset((Object)(TransferUtils.calOffset(this.barSeries.size(), i) + "%"), (Object)"-50%");
            p2.symbolSize((Object)new String[]{TransferUtils.calSize(this.barSeries.size(), 20.0) + "%%", "15"});
            int colorIndex = i % this.getColorList().size();
            p2.itemStyle().normal().color((Object)("function(index){return colors[" + colorIndex + "];}"));
            p2.setSymbolPosition((Object)"end");
            p2.setData(bar.getData());
            p2.setYAxisIndex(Integer.valueOf(0));
            serieList.add(p2);
        }
        ArrayList<ValueAxis> yList = new ArrayList<ValueAxis>(this.yAxis.length);
        for (int n = 0; n < 1; ++n) {
            ValueAxis valueAxis = new ValueAxis();
            valueAxis.name(bean.getChart().yScaleUnit);
            valueAxis.type(AxisType.value);
            valueAxis.axisLabel().show(Boolean.valueOf(n == 0));
            valueAxis.axisLabel().interval((Object)"auto");
            yList.add(valueAxis);
        }
        serieList.addAll(this.otherSeries);
        p.yAxis(yList);
        p.xAxis().add(caxis);
        p.series().addAll(serieList);
        return p;
    }

    @Override
    public String initMockScript(MSColumn3DLineBean bean) {
        return super.initMockScript(bean) + this.buildColorStopsLeft(1, bean.initColors().size());
    }

    @Override
    public Option mockOption(MSColumn3DLineBean bean) {
        Option p = super.mockOption(bean);
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        p.legend().data(Arrays.asList("A", "B"));
        CategoryAxis caxis = new CategoryAxis();
        caxis.type(AxisType.category);
        caxis.data(new Object[]{CtrlEXTMessages.getMLS("apple", "\u82f9\u679c"), CtrlEXTMessages.getMLS("banana", "\u9999\u8549"), CtrlEXTMessages.getMLS("pineapple", "\u83e0\u841d"), CtrlEXTMessages.getMLS("lychee", "\u8354\u679d"), CtrlEXTMessages.getMLS("watermelon", "\u897f\u74dc"), CtrlEXTMessages.getMLS("mango", "\u8292\u679c")});
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        yAxis.axisLabel().show(Boolean.valueOf(true));
        yAxis.axisLabel().interval((Object)"auto");
        yAxis.splitLine().lineStyle().opacity(Double.valueOf(0.5));
        yAxis.splitArea().areaStyle().opacity(Double.valueOf(0.5));
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        Bar bar = new Bar();
        bar.name("A");
        bar.yAxisIndex(Integer.valueOf(0));
        bar.itemStyle().normal().color((Object)new Var("function(){return colorStop0;}"));
        bar.data(new Object[]{154.0, 125.0, 125.0, 365.0, 114.0, 89.0});
        EChartUtils.configShowValue(bean, (Series)bar);
        EChartUtils.configTrendline(bean, (Series)bar);
        EChartUtils.configPlotBorder(bean, (Series)bar);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar);
        p.series().add(bar);
        PictorialBar pbar = new PictorialBar();
        pbar.yAxisIndex(Integer.valueOf(0));
        pbar.itemStyle().normal().color((Object)"function(index){return colors[((index.seriesIndex + 1) / 2 -1)  % colors.length];}");
        pbar.tooltip().trigger(Trigger.none);
        pbar.symbol(Symbol.diamond);
        pbar.symbolSize(Arrays.asList("100.0%%", "15"));
        pbar.symbolOffset((Object)"0.0%", (Object)"-50%");
        pbar.setSymbolPosition((Object)"end");
        pbar.data(new Object[]{154.0, 125.0, 125.0, 365.0, 114.0, 89.0});
        EChartUtils.configPlotBorder(bean, (Series)pbar);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar);
        p.series().add(pbar);
        Line line = new Line();
        line.name("B");
        line.showSymbol(Boolean.valueOf(true));
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)line);
        line.data(new Object[]{69.0, 38.0, 25.0, 96.0, 154.0, 125.0});
        EChartUtils.configShowValue(bean, (Series)line);
        EChartUtils.configPlotBorder(bean, (Series)line);
        EChartUtils.configTrendLineOnTop(bean, (Series)line);
        p.series().add(line);
        EChartUtils.configMaxMinValue(bean, p, 365.0, 0.0);
        EChartUtils.hideDrawRB(bean, p, 365.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String afterMockScript(MSColumn3DLineBean bean) {
        return super.afterMockScript(bean) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }

    @Override
    public String afterScript(MSColumn3DLineBean b, FusionChartDataNode data, Option p) {
        return super.afterScript(b, data, p) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }
}

