/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.combination.MSCombiDY2DBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.util.FusionChartXmlBuilder;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractColumnTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class CombinationDY2DBeanTransferImpl
extends AbstractColumnTransfer<MSCombiDY2DBean> {
    public CombinationDY2DBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("dualYAxisComboChart2D", "\u53ccY\u8f742D\u7ec4\u5408\u56fe"));
    }

    @Override
    public Option transfer2Opiton(MSCombiDY2DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        List asList = com.kingdee.bos.util.backport.Arrays.asList((Object[])this.seriesNames);
        if (null != p.getLegend()) {
            p.legend().data(asList);
        }
        Chart chart = bean.getChart();
        CategoryAxis caxis = new CategoryAxis();
        for (String group : this.groups) {
            caxis.data().add(group);
        }
        HashMap<String, Integer> yAxisMap = new HashMap<String, Integer>();
        ArrayList<ValueAxis> yList = new ArrayList<ValueAxis>();
        int count = 0;
        for (int n = 0; n < this.yAxis.length; ++n) {
            String chartYAxis = FusionChartXmlBuilder.getChartYAxis(this.yAxis[n]);
            if (null != yAxisMap.get(chartYAxis)) continue;
            ValueAxis valueAxis = new ValueAxis();
            valueAxis.type(AxisType.value);
            valueAxis.axisLabel().show(Boolean.TRUE);
            if (null != chartYAxis) {
                valueAxis.setPosition((Object)Position.right);
            }
            yList.add(valueAxis);
            yAxisMap.put(chartYAxis, count);
            ++count;
        }
        int tLen = this.types.length;
        ArrayList<Bar> serieList = new ArrayList<Bar>(tLen);
        for (int i = 0; i < tLen; ++i) {
            Bar serie = new Bar();
            serie.z(Integer.valueOf(1));
            if (TransferUtils.isLineType(this.types[i])) {
                serie = new Line();
            } else if (TransferUtils.isAreaType(this.types[i])) {
                serie = new Line();
                ((Line)serie).areaStyle();
            }
            String name = asList.get(i).toString();
            serie.name(name);
            serieList.add(serie);
            String chartYAxis = FusionChartXmlBuilder.getChartYAxis(this.yAxis[i]);
            Integer index = (Integer)yAxisMap.get(chartYAxis);
            if (null != index) {
                serie.yAxisIndex(index);
            }
            TransferUtils.fillData(this.dataValues, i, (Series)serie);
        }
        p.yAxis(yList);
        p.xAxis().add(caxis);
        p.series().addAll(serieList);
        return p;
    }

    @Override
    public String initMockScript(MSCombiDY2DBean bean) {
        if (ChartFillColorComboBoxEditor.getGradient().equals(bean.getChart_plotGradientColor())) {
            return super.initMockScript(bean) + EChartUtils.getPlotGradientColor(this.isyValueAxis(), this.isxValueAxis(), this.getColorList());
        }
        return super.initMockScript(bean);
    }

    @Override
    public Option mockOption(MSCombiDY2DBean bean) {
        Option p = super.mockOption(bean);
        EChartUtils.configPlotGradientColor(bean, p);
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        p.legend().data(Arrays.asList(CtrlEXTMessages.getMLS("shipmentQuantity", "\u51fa\u8d27\u6570"), CtrlEXTMessages.getMLS("yieldRate", "\u826f\u54c1\u7387")));
        CategoryAxis caxis = new CategoryAxis();
        caxis.type(AxisType.category);
        caxis.data(new Object[]{"2022.1", "2022.2", "2022.3", "2022.4", "2022.5"});
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        CategoryAxis yYAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        yYAxis.type(AxisType.value);
        yAxis.axisLabel().interval((Object)"auto");
        yYAxis.axisLabel().interval((Object)"auto");
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        EChartUtils.configAxisLucency(bean, (Axis)yYAxis, false);
        p.yAxis().add(yAxis);
        Var axisNumberFormatFunctionVar = JSUtils.getValueAxisNumberFormatFunctionVar(false, null);
        yYAxis.axisLabel().formatter((Object)axisNumberFormatFunctionVar);
        EChartUtils.configRightAxisMaxMinValue(bean, (Axis)yYAxis);
        p.yAxis().add(yYAxis);
        Bar bar = new Bar();
        bar.name(CtrlEXTMessages.getMLS("shipmentQuantity", "\u51fa\u8d27\u6570"));
        bar.yAxisIndex(Integer.valueOf(0));
        bar.data(new Object[]{502, 324, 452, 625, 754});
        EChartUtils.configShowValue(bean, (Series)bar);
        EChartUtils.configTrendline(bean, (Series)bar);
        EChartUtils.configAngleRound(bean, (Series)bar);
        EChartUtils.configPlotBorder(bean, (Series)bar);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar);
        p.series().add(bar);
        Line line = new Line();
        line.name(CtrlEXTMessages.getMLS("yieldRate", "\u826f\u54c1\u7387"));
        line.yAxisIndex(Integer.valueOf(1));
        line.data(new Object[]{98.1, 99.3, 95.6, 97.5, 96.2});
        EChartUtils.configShowValue(bean, (Series)line);
        EChartUtils.configPlotBorder(bean, (Series)line);
        EChartUtils.configTrendLineOnTop(bean, (Series)line);
        p.series().add(line);
        EChartUtils.configMaxMinValue(bean, p, 754.0, 0.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }
}

