/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.PictorialBar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.combination.MSColumn3DLineDYBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.util.FusionChartXmlBuilder;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractColumnTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class CombinationDYColumn3DLineBeanTransferImpl
extends AbstractColumnTransfer<MSColumn3DLineDYBean> {
    private List<Series<Bar>> otherSeries = new ArrayList<Series<Bar>>();
    private List<Series> barSeries = new ArrayList<Series>();

    public CombinationDYColumn3DLineBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("threeDColumnChartWithDualYLineChart", "\u4f7f\u75283d\u67f1\u5f62\u56fe\u6a21\u62df3d\u52a0\u6298\u7ebf\u53ccy\u56fe"));
    }

    @Override
    public String initScript(MSColumn3DLineDYBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        double[][] data = new double[this.seriesNames.length][this.seriesNames.length];
        return s + this.buildColorStopsLeft(data.length, bean.initColors().size());
    }

    @Override
    public Option transfer2Opiton(MSColumn3DLineDYBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        Chart chart = bean.getChart();
        List<Object> asList = Arrays.asList(this.seriesNames);
        if (null != p.getLegend()) {
            p.legend().data(asList);
        }
        if (null == this.dataValues || null == this.groups) {
            return null;
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String group : this.groups) {
            caxis.data().add(group);
        }
        HashMap<String, Integer> yAxisMap = new HashMap<String, Integer>();
        ArrayList<ValueAxis> yList = new ArrayList<ValueAxis>();
        int count = 0;
        for (int n = 0; n < this.yAxis.length; ++n) {
            String chartYAxis = FusionChartXmlBuilder.getChartYAxis(this.yAxis[n]);
            if (null != yAxisMap.get(chartYAxis)) continue;
            ValueAxis valueAxis = new ValueAxis();
            valueAxis.type(AxisType.value);
            valueAxis.axisLabel().show(Boolean.TRUE);
            if (null != chartYAxis) {
                valueAxis.setPosition((Object)Position.right);
            }
            yList.add(valueAxis);
            yAxisMap.put(chartYAxis, count);
            ++count;
        }
        int tLen = this.types.length;
        for (int i = 0; i < tLen; ++i) {
            Bar serie = new Bar();
            serie.z(Integer.valueOf(1));
            boolean createBar = true;
            if (TransferUtils.isLineType(this.types[i])) {
                serie = new Line();
                this.otherSeries.add((Series<Bar>)serie);
                createBar = false;
            } else if (TransferUtils.isAreaType(this.types[i])) {
                serie = new Line();
                this.otherSeries.add((Series<Bar>)serie);
                ((Line)serie).areaStyle();
                createBar = false;
            }
            String name = asList.get(i).toString();
            serie.name(name);
            String chartYAxis = FusionChartXmlBuilder.getChartYAxis(this.yAxis[i]);
            Integer index = (Integer)yAxisMap.get(chartYAxis);
            if (null != index) {
                serie.yAxisIndex(index);
            }
            if (createBar) {
                this.barSeries.add((Series)serie);
            }
            TransferUtils.fillData(this.dataValues, i, (Series)serie);
        }
        int barSerieSize = this.barSeries.size();
        ArrayList<Object> serieList = new ArrayList<Object>(barSerieSize);
        for (int i = 0; i < barSerieSize; ++i) {
            Series bar = this.barSeries.get(i);
            serieList.add(bar);
            bar.itemStyle().normal().color((Object)("function(){return colorStop" + i + " ;}"));
            PictorialBar p2 = new PictorialBar();
            p2.name(bar.getName());
            p2.yAxisIndex(bar.getYAxisIndex());
            p2.z(Integer.valueOf(2));
            p2.symbol((Object)"diamond");
            p2.symbolOffset((Object)(TransferUtils.calOffset(this.barSeries.size(), i) + "%"), (Object)"-50%");
            p2.symbolSize((Object)new String[]{TransferUtils.calSize(this.barSeries.size(), 20.0) + "%%", 100.0 / (double)this.barSeries.size() * 0.25 + ""});
            int colorIndex = i % this.getColorList().size();
            p2.itemStyle().normal().color((Object)("function(index){return colors[" + colorIndex + "];}"));
            p2.setSymbolPosition((Object)"end");
            p2.setData(bar.getData());
            p2.setYAxisIndex(bar.getYAxisIndex());
            serieList.add(p2);
        }
        serieList.addAll(this.otherSeries);
        p.yAxis(yList);
        p.xAxis().add(caxis);
        p.series().addAll(serieList);
        return p;
    }

    @Override
    public String initMockScript(MSColumn3DLineDYBean bean) {
        return super.initMockScript(bean) + this.buildColorStopsLeft(1, bean.initColors().size());
    }

    @Override
    public Option mockOption(MSColumn3DLineDYBean bean) {
        Option p = super.mockOption(bean);
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        p.legend().data(Arrays.asList("A", "B"));
        CategoryAxis caxis = new CategoryAxis();
        caxis.type(AxisType.category);
        caxis.data(new Object[]{CtrlEXTMessages.getMLS("apple", "\u82f9\u679c"), CtrlEXTMessages.getMLS("banana", "\u9999\u8549"), CtrlEXTMessages.getMLS("pear", "\u68a8")});
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        CategoryAxis yYAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        yYAxis.type(AxisType.value);
        yAxis.axisLabel().interval((Object)"auto");
        yYAxis.axisLabel().interval((Object)"auto");
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        EChartUtils.configAxisLucency(bean, (Axis)yYAxis, false);
        p.yAxis().add(yAxis);
        Var axisNumberFormatFunctionVar = JSUtils.getValueAxisNumberFormatFunctionVar(false, null);
        yYAxis.axisLabel().formatter((Object)axisNumberFormatFunctionVar);
        EChartUtils.configRightAxisMaxMinValue(bean, (Axis)yYAxis);
        p.yAxis().add(yYAxis);
        Bar bar = new Bar();
        bar.name("A");
        bar.yAxisIndex(Integer.valueOf(0));
        bar.itemStyle().normal().color((Object)new Var("function(){return colorStop0;}"));
        bar.data(new Object[]{152.0, 214.0, 645.0});
        EChartUtils.configShowValue(bean, (Series)bar);
        EChartUtils.configTrendline(bean, (Series)bar);
        EChartUtils.configPlotBorder(bean, (Series)bar);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar);
        p.series().add(bar);
        PictorialBar pbar = new PictorialBar();
        pbar.yAxisIndex(Integer.valueOf(0));
        pbar.itemStyle().normal().color((Object)"function(index){return colors[((index.seriesIndex + 1) / 2 -1)  % colors.length];}");
        pbar.tooltip().trigger(Trigger.none);
        pbar.symbol(Symbol.diamond);
        pbar.symbolSize(Arrays.asList("100.0%%", "25.0"));
        pbar.symbolOffset((Object)"0.0%", (Object)"-50%");
        pbar.setSymbolPosition((Object)"end");
        pbar.data(new Object[]{152.0, 214.0, 645.0});
        EChartUtils.configPlotBorder(bean, (Series)pbar);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar);
        p.series().add(pbar);
        Line line = new Line();
        line.name("B");
        line.yAxisIndex(Integer.valueOf(1));
        line.data(new Object[]{125.0, 145.0, 541.0});
        EChartUtils.configShowValue(bean, (Series)line);
        EChartUtils.configPlotBorder(bean, (Series)line);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)line);
        p.series().add(line);
        EChartUtils.configMaxMinValue(bean, p, 645.0, 0.0);
        EChartUtils.hideDrawRB(bean, p, 645.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String afterMockScript(MSColumn3DLineDYBean bean) {
        return super.afterMockScript(bean) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }

    @Override
    public String afterScript(MSColumn3DLineDYBean b, FusionChartDataNode data, Option p) {
        return super.afterScript(b, data, p) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }
}

