/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.funnel;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.code.Orient;
import com.github.abel533.echarts.code.Sort;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.data.PieData;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Funnel;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.funnel.FunnelBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractSmoothTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;

public class FunnelBeanTransferImpl
extends AbstractSmoothTransfer<FunnelBean> {
    public FunnelBeanTransferImpl() {
        super(EChartsType.FUNNEL, CtrlEXTMessages.getMLS("funnelChart", "\u6f0f\u6597\u56fe"));
    }

    @Override
    public String initScript(FunnelBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        EChartUtils.checkChartDataIsNull((Object[])((double[][])dataNode.getData()), bean.getLables());
        return s;
    }

    @Override
    public Option transfer2Opiton(FunnelBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().setTrigger(Trigger.item);
            p.tooltip().setFormatter((Object)"{b}  {d}%");
        }
        Object[] labels = bean.getLables();
        double[][] data = (double[][])dataNode.getData();
        Chart chart = bean.getChart();
        Funnel funnel = new Funnel();
        funnel.minSize("0%");
        funnel.maxSize("65%");
        funnel.gap(Integer.valueOf(2));
        funnel.left((Object)chart.chartLeftMargin);
        funnel.top((Object)EChartUtils.getChartTopMargin(bean));
        if ("right".equals(chart.legendPosition)) {
            funnel.right((Object)(Double.parseDouble(bean.getChart_chartRightMargin()) + 60.0));
        } else {
            funnel.right((Object)chart.chartRightMargin);
        }
        if ("bottom".equals(chart.legendPosition)) {
            funnel.bottom((Object)(Double.parseDouble(bean.getChart_chartBottomMargin()) + 20.0));
        } else {
            funnel.bottom((Object)chart.chartBottomMargin);
        }
        funnel.sort(Sort.descending);
        if ("1".equals(chart.showValues)) {
            String formatter = "{b}";
            formatter = formatter + " {c}";
            Var format = JSUtils.getTooltipFormatterVar(true, false, false, formatter);
            funnel.label().normal().formatter((Object)format);
        }
        if (null != p.getLegend() && null != p.legend().right()) {
            funnel.label().normal().color((Object)"#000");
        }
        if (null != p.getLegend()) {
            p.legend().data(labels);
        }
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                double d = data[i][j];
                PieData pieData = new PieData((String)labels[j], (Object)Math.abs(d));
                if (d < 0.0) {
                    pieData.setNegative(Boolean.TRUE);
                }
                funnel.data().add(pieData);
            }
        }
        p.series().add(funnel);
        return p;
    }

    @Override
    public Option mockOption(FunnelBean bean) {
        Option p = super.mockOption(bean);
        p.tooltip().trigger(Trigger.item);
        p.tooltip().formatter((Object)"{b}  {c}%");
        p.legend().setData(Arrays.asList(CtrlEXTMessages.getMLS("display", "\u5c55\u793a"), CtrlEXTMessages.getMLS("click", "\u70b9\u51fb"), CtrlEXTMessages.getMLS("visit", "\u8bbf\u95ee"), CtrlEXTMessages.getMLS("consult", "\u54a8\u8be2"), CtrlEXTMessages.getMLS("order", "\u8ba2\u5355")));
        p.legend().orient(Orient.horizontal);
        Funnel funnel = new Funnel();
        funnel.bottom(Integer.valueOf(40));
        funnel.min(Integer.valueOf(0));
        funnel.max(Integer.valueOf(100));
        funnel.minSize("0%");
        funnel.maxSize("100%");
        funnel.sort(Sort.descending);
        funnel.gap(Integer.valueOf(2));
        funnel.setData(Arrays.asList(new PieData(CtrlEXTMessages.getMLS("visit", "\u8bbf\u95ee"), (Object)100), new PieData(CtrlEXTMessages.getMLS("consult", "\u54a8\u8be2"), (Object)80), new PieData(CtrlEXTMessages.getMLS("order", "\u8ba2\u5355"), (Object)60), new PieData(CtrlEXTMessages.getMLS("click", "\u70b9\u51fb"), (Object)40), new PieData(CtrlEXTMessages.getMLS("display", "\u5c55\u793a"), (Object)20)));
        funnel.label().normal().color((Object)"#000");
        if (bean.getChart_showValues().getBooleanValue().booleanValue()) {
            Var format = JSUtils.getTooltipFormatterVar(true, false, false, "{b}  {c}");
            funnel.label().normal().formatter((Object)format);
        }
        EChartUtils.configPlotBorder(bean, (Series)funnel);
        p.series().add(funnel);
        return p;
    }

    @Override
    public String afterMockScript(FunnelBean bean) {
        String s = JSUtils.getPositionJS(String.valueOf(EChartUtils.getChartTopMargin(bean)), bean.getChart_chartLeftMargin(), bean.getChart_chartBottomMargin(), bean.getChart_chartRightMargin());
        return s + JSUtils.RESIZE_ADJUSTPOSITION_FUNCTION + JSUtils.ADJUSTPOSITION_FUNCTION + "myChart.setOption(option, true);";
    }
}

