/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.line;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.line.Line2DBean;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractLineTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;

public class Line2DBeanTransferImpl
extends AbstractLineTransfer<Line2DBean> {
    public Line2DBeanTransferImpl() {
        super(EChartsType.LINE, CtrlEXTMessages.getMLS("lineChart2D", "2D\u6298\u7ebf\u56fe"));
    }

    @Override
    public String initScript(Line2DBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        double[][] data = (double[][])dataNode.getData();
        EChartUtils.checkChartDataIsNull((Object[])data, bean.getLables());
        return s;
    }

    @Override
    public Option transfer2Opiton(Line2DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        String[] labels = bean.getLables();
        double[][] data = (double[][])dataNode.getData();
        Line bar = new Line();
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.name(bean.getChart().yScaleUnit);
        p.yAxis().add(valueAxis);
        CategoryAxis caxis = new CategoryAxis();
        for (String label : labels) {
            caxis.data().add(label);
        }
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                bar.data().add(data[i][j]);
            }
        }
        p.xAxis().add(caxis);
        p.series().add(bar);
        return p;
    }

    @Override
    public Option mockOption(Line2DBean bean) {
        Option p = super.mockOption(bean);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, false, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setData(Arrays.asList("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"));
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        Line line = new Line();
        line.setData(Arrays.asList(150, 230, 224, 218, 135, 147, 260));
        EChartUtils.configShowValue(bean, (Series)line);
        EChartUtils.configTrendline(bean, (Series)line);
        p.series().add(line);
        EChartUtils.configMaxMinValue(bean, p, 260.0, 0.0);
        EChartUtils.configSort(bean, p);
        EChartUtils.configBorder(bean, p);
        return p;
    }
}

