/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.scatter;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.LineType;
import com.github.abel533.echarts.code.NameLocation;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.MarkLine;
import com.github.abel533.echarts.series.Scatter;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.xy.BubbleBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractXYTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class BubbleBeanTransferImpl
extends AbstractXYTransfer<BubbleBean> {
    private static final Logger logger = LogUtil.getPackageLogger(BubbleBeanTransferImpl.class);

    public BubbleBeanTransferImpl() {
        super(EChartsType.SCATTER, CtrlEXTMessages.getMLS("bubbleChart", "\u6c14\u6ce1\u56fe"));
        this.setxValueAxis(true);
    }

    @Override
    public Option transfer2Opiton(BubbleBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        Chart chart = bean.getChart();
        if (null != p.getTooltip()) {
            p.tooltip().setFormatter((Object)"{a} <br/>{c}");
        }
        if (null != p.getLegend()) {
            p.legend().data(this.seriesNames);
        }
        int step = bean.getSetp();
        boolean isSeriesByCol = dataNode.isSerialByCol();
        for (int j = 0; j < this.seriesNames.length; ++j) {
            reference var33_36;
            reference var31_35;
            Double[] pdata;
            Object z;
            Object values;
            int n;
            Scatter sc = new Scatter();
            sc.setName((String)this.seriesNames[j]);
            Object maxDx = -1.7976931348623157E308;
            Object maxDy = -1.7976931348623157E308;
            Object cx = 0.0;
            Object cy = 0.0;
            Object xz = 1.0;
            Object yz = 1.0;
            if (!StringUtil.isEmptyString((String)chart.labelSetting)) {
                sc.label().normal().show(Boolean.TRUE);
                sc.label().normal().position(Position.top);
                sc.label().normal().color((Object)"#000");
                sc.label().normal().formatter((Object)"{a}");
            }
            if (isSeriesByCol) {
                for (n = 0; n < this.dataValues.length; ++n) {
                    Object y;
                    Object x;
                    int i;
                    if (this.dataValues[n] instanceof Variant[][]) {
                        values = (Variant[][])this.dataValues[n];
                        for (i = 0; i < ((Variant[][])values).length; ++i) {
                            if (values[i].length < 3) {
                                throw new RuntimeException(CtrlEXTMessages.getMLS("dataError", "\u6570\u636e\u9519\u8bef"));
                            }
                            try {
                                x = values[i][j * step].doubleValue();
                                y = values[i][j * step + 1].doubleValue();
                                z = values[i][j * step + 2].doubleValue();
                                this.dmaxX = Math.max(this.dmaxX, (double)x);
                                this.dmaxY = Math.max(this.dmaxY, (double)y);
                                this.dminX = Math.min(this.dminX, (double)x);
                                this.dminY = Math.min(this.dminY, (double)y);
                                pdata = new Double[]{(double)x, (double)y, (double)z};
                                var31_35 = z - Math.abs((double)x);
                                var33_36 = z - Math.abs((double)y);
                                if (var31_35 > maxDx) {
                                    maxDx = var31_35;
                                    cx = x;
                                    xz = z;
                                }
                                if (var33_36 > maxDy) {
                                    maxDy = var33_36;
                                    cy = y;
                                    yz = z;
                                }
                                TransferUtils.configreVerticalLine(chart, sc, pdata[0].intValue());
                                sc.data().add(pdata);
                                continue;
                            }
                            catch (SyntaxErrorException e) {
                                logger.error((Object)"err", (Throwable)e);
                            }
                        }
                        continue;
                    }
                    values = (double[][])this.dataValues[n];
                    for (i = 0; i < ((Variant[][])values).length; ++i) {
                        if (values[i].length < 3) {
                            throw new RuntimeException(CtrlEXTMessages.getMLS("dataError", "\u6570\u636e\u9519\u8bef"));
                        }
                        x = values[i][0];
                        y = values[i][1];
                        z = values[i][2];
                        this.dmaxX = Math.max(this.dmaxX, (double)x);
                        this.dmaxY = Math.max(this.dmaxY, (double)y);
                        this.dminX = Math.min(this.dminX, (double)x);
                        this.dminY = Math.min(this.dminY, (double)y);
                        pdata = new Double[]{(double)x, (double)y, (double)z};
                        var31_35 = z - Math.abs((double)x);
                        var33_36 = z - Math.abs((double)y);
                        if (var31_35 > maxDx) {
                            maxDx = var31_35;
                            cx = x;
                            xz = z;
                        }
                        if (var33_36 > maxDy) {
                            maxDy = var33_36;
                            cy = y;
                            yz = z;
                        }
                        TransferUtils.configreVerticalLine(chart, sc, pdata[0].intValue());
                        sc.data().add(pdata);
                    }
                }
            } else {
                for (n = 0; n < this.dataValues.length; ++n) {
                    Object y;
                    int i;
                    if (this.dataValues[n] instanceof Variant[][]) {
                        values = (Variant[][])this.dataValues[n];
                        if (((Variant[][])values).length < 3) {
                            throw new RuntimeException(CtrlEXTMessages.getMLS("dataError", "\u6570\u636e\u9519\u8bef"));
                        }
                        for (i = 0; i < values[j * step].length; ++i) {
                            try {
                                double x = values[j * step][i].doubleValue();
                                y = values[j * step + 1][i].doubleValue();
                                z = values[j * step + 2][i].doubleValue();
                                this.dmaxX = Math.max(this.dmaxX, x);
                                this.dmaxY = Math.max(this.dmaxY, y);
                                this.dminX = Math.min(this.dminX, x);
                                this.dminY = Math.min(this.dminY, y);
                                pdata = new Double[]{x, y, (double)z};
                                var31_35 = z - Math.abs(x);
                                var33_36 = z - Math.abs(y);
                                if (var31_35 > maxDx) {
                                    maxDx = var31_35;
                                    cx = x;
                                    xz = z;
                                }
                                if (var33_36 > maxDy) {
                                    maxDy = var33_36;
                                    cy = y;
                                    yz = z;
                                }
                                TransferUtils.configreVerticalLine(chart, sc, pdata[0].intValue());
                                sc.data().add(pdata);
                                continue;
                            }
                            catch (SyntaxErrorException e) {
                                logger.error((Object)"err", (Throwable)e);
                            }
                        }
                        continue;
                    }
                    if (!(this.dataValues[n] instanceof double[][])) continue;
                    values = (double[][])this.dataValues[n];
                    if (((Variant[][])values).length < 3) {
                        throw new RuntimeException(CtrlEXTMessages.getMLS("dataError", "\u6570\u636e\u9519\u8bef"));
                    }
                    for (i = 0; i < values[j * step].length; ++i) {
                        Variant x = values[j * step][i];
                        y = values[j * step + 1][i];
                        z = values[j * step + 2][i];
                        this.dmaxX = Math.max(this.dmaxX, (double)x);
                        this.dmaxY = Math.max(this.dmaxY, y);
                        this.dminX = Math.min(this.dminX, (double)x);
                        this.dminY = Math.min(this.dminY, y);
                        pdata = new Double[]{(double)x, y, (double)z};
                        var31_35 = z - Math.abs((double)x);
                        var33_36 = z - Math.abs(y);
                        if (var31_35 > maxDx) {
                            maxDx = var31_35;
                            cx = x;
                            xz = z;
                        }
                        if (var33_36 > maxDy) {
                            maxDy = var33_36;
                            cy = y;
                            yz = z;
                        }
                        TransferUtils.configreVerticalLine(chart, sc, pdata[0].intValue());
                        sc.data().add(pdata);
                    }
                }
            }
            cx = Math.abs(cx);
            cy = Math.abs(cy);
            double hx = xz / cx * 0.6;
            double hy = yz / cy * 0.6;
            String factor = Math.min(hx, hy) + "";
            String scaling = "1.0";
            if (StringUtil.isNumber((String)chart.zAxisScaling)) {
                scaling = String.valueOf(Double.parseDouble(chart.zAxisScaling));
            }
            sc.symbolSize((Object)String.format("function(data){ var s = data[2] * %s * %s ; if(s < 1){ return 1;} else{ return s;}}", factor, scaling));
            p.series().add(sc);
        }
        ValueAxis xAxis = new ValueAxis();
        xAxis.name(bean.getChart().chart_xUnitText);
        xAxis.position((Object)Position.right);
        p.xAxis().add(xAxis);
        p.yAxis().add(new ValueAxis().name(bean.getChart().yScaleUnit));
        if ("1".equals(chart.showCategrotiesVerticalLine)) {
            for (Axis axis : p.getxAxis()) {
                axis.show(Boolean.FALSE);
            }
        }
        return p;
    }

    @Override
    public String afterScript(BubbleBean b, FusionChartDataNode data, Option p) {
        return super.afterScript(b, data, p);
    }

    @Override
    public Option mockOption(BubbleBean bean) {
        Option p = super.mockOption(bean);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, "{a} <br/>{c}");
        p.tooltip().formatter((Object)tooltipFormatter);
        ValueAxis xAxis = new ValueAxis();
        xAxis.type(AxisType.value);
        xAxis.nameGap(Integer.valueOf(16));
        if (bean.getChartXStartValue() != null) {
            xAxis.max((Object)bean.getChartXStartValue());
        }
        if (bean.getChartXEndValue() != null) {
            xAxis.min((Object)bean.getChartXEndValue());
        }
        EChartUtils.configAxisLucency(bean, (Axis)xAxis, false);
        p.xAxis(new Axis[]{xAxis});
        ValueAxis yAxis = new ValueAxis();
        yAxis.type(AxisType.value);
        yAxis.nameLocation(NameLocation.end);
        yAxis.nameGap(Integer.valueOf(20));
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis(new Axis[]{yAxis});
        Scatter scatter = new Scatter();
        scatter.name(CtrlEXTMessages.getMLS("aqiIndex", "AQI\u6307\u6570"));
        scatter.symbolSize((Object)new Var("function(data){ return data[2];}"));
        scatter.setData(Arrays.asList({1.0, 26.0, 13.0}, {2.0, 85.0, 8.0}, {3.0, 78.0, 7.0}, {4.0, 21.0, 9.0}, {5.0, 41.0, 13.0}, {6.0, 56.0, 16.0}, {7.0, 64.0, 2.0}, {8.0, 55.0, 26.0}, {9.0, 76.0, 27.0}, {10.0, 91.0, 40.0}, {11.0, 84.0, 11.0}, {12.0, 64.0, 23.0}, {13.0, 70.0, 36.0}, {14.0, 77.0, 16.0}, {15.0, 109.0, 29.0}, {16.0, 73.0, 34.0}, {17.0, 54.0, 12.0}, {18.0, 51.0, 19.0}, {19.0, 91.0, 18.0}, {20.0, 73.0, 19.0}, {21.0, 73.0, 20.0}, {22.0, 84.0, 18.0}, {23.0, 93.0, 7.0}, {24.0, 99.0, 15.0}, {25.0, 146.0, 17.0}, {26.0, 113.0, 15.0}, {27.0, 81.0, 3.0}, {28.0, 56.0, 9.0}, {29.0, 82.0, 13.0}, {30.0, 106.0, 88.0}, {31.0, 118.0, 50.0}));
        if (bean.getShowCategrotiesVerticalLine().getBooleanValue().booleanValue()) {
            xAxis.show(Boolean.FALSE);
            MarkLine markLine = scatter.markLine();
            markLine.symbol((Object)"none");
            markLine.lineStyle().type(LineType.solid);
            markLine.lineStyle().opacity(Double.valueOf(0.5));
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 1}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 2}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 3}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 4}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 5}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 6}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 7}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 8}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 9}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 10}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 11}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 12}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 13}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 14}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 15}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 16}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 17}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 18}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 19}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 20}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 21}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 22}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 23}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 24}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 25}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 26}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 27}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 28}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 29}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 30}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 31}")});
        }
        EChartUtils.configTrendline(bean, (Series)scatter);
        Float value = bean.getZAxisScaling().getFloatValue();
        scatter.symbolSize((Object)String.format("function(data){ var s = data[2] * %s ; if(s < 1){ return 1;} else{ return s;}}", value));
        if (!StringUtil.isEmptyString((String)bean.getLabelSetting())) {
            scatter.label().normal().show(Boolean.TRUE);
            scatter.label().normal().position(Position.top);
            scatter.label().normal().color((Object)"#000");
            scatter.label().normal().formatter((Object)"{a}");
        }
        p.series().add(scatter);
        EChartUtils.configMaxMinValue(bean, p, 146.0, 0.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }
}

