/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart;

import chrriis.dj.nativeswing.swtimpl.NativeComponent;
import chrriis.dj.nativeswing.swtimpl.components.FlashPluginOptions;
import chrriis.dj.nativeswing.swtimpl.components.JFlashPlayer;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowWillOpenEvent;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.cosmic.ctrl.common.CtrlUtil;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.BrowserUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.ReflectUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.AbstractChartPanel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.FlashHelper;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.color.ColorTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.cosmic.ctrl.kds.io.kds.BookToKds;
import com.kingdee.cosmic.ctrl.kds.io.kds.KDSBinaryBook;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.INativeEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.util.ChartUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.ChartImageUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataInputStream;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataOutputStream;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FlashChart
extends ChartRectEmbedment
implements INativeEmbedment {
    private static final Logger logger = LogUtil.getPackageLogger(FlashChart.class);
    private KDPanel _container;
    private String _xml;
    private JFlashPlayer player;
    private boolean isTransitionChart;
    private static final String JAVASCRIPT_FLASHWIDTH_START = "document.getElementById('myEmbeddedObject').style.width = '";
    private static final String JAVASCRIPT_FLASHHEIGHT_START = "document.getElementById('myEmbeddedObject').style.height = '";
    private static final String JAVASCRIPT_FLASHBOUNDS_END = "px'";
    private static final String JAVASCTIPT_VERTIVAL_SCROLLBAR_ONLY = "document.getElementsByTagName('html')[0].style.overflow='-moz-scrollbars-vertical'";
    private static final String JAVASCTIPT_HORIZONTAL_SCROLLBAR_ONLY = "document.getElementsByTagName('html')[0].style.overflow='-moz-scrollbars-horizontal'";
    private static final String JAVASCRIPT_SCROLLBAR_BOTH = "document.getElementsByTagName('html')[0].style.overflow='scroll'";
    public static final String IE = "IE";
    public static final String XULRUNNER = "XULRUNNER";
    private FlashChart main_flash;
    private boolean save4Snap = false;
    public static Rectangle transitionBounds = new Rectangle();
    public static FlashChart CURRENT_FLASH;
    private String flashPath;
    private Rectangle lastBounds = this.getBounds();
    static final byte ID_End = 0;
    static final byte ID_ChartType = 1;
    static final byte ID_Data = 2;
    static final byte ID_GroupKeys = 3;
    static final byte ID_SerialKeys = 4;
    static final byte ID_ChartTitle = 5;
    static final byte ID_CategoryAxisTitle = 6;
    static final byte ID_ValueAxisTitle = 7;
    static final byte ID_Angle = 8;
    static final byte ID_SerialOrientation = 9;
    static final byte ID_SeriesFormula = 16;
    static final byte ID_DateFormat = 11;
    static final byte ID_FusionChart = 10;
    static final byte ID_String = 12;
    static final byte ID_StringArray = 13;
    static final byte ID_NULL = 14;
    static final byte ID_ExprFlag = 15;
    static final byte ID_XML = 17;
    static final byte ID_SAVE4SNAP = 18;
    static final byte ID_COLORXML = 19;
    static final byte ID_NUMBERFORMATXML = 20;
    static final byte ID_VALUERESITRICTION = 21;
    static final byte ID_LastSelectedIndex = 22;
    static final byte ID_Transformable_Chart = 23;
    static final byte ID_DataFrom = 24;
    static final byte ID_TransitionTarget = 25;
    static final byte ID_InnerTransitionTarget = 26;
    private Object[] splitArray;
    private FlashChart _src;

    public FlashChart(Sheet sheet, FlashChartModel m) {
        this(sheet);
        this.model = m;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.model != null && this.model.getBean() != null) {
            this.model.getBean().setChartName(name);
        }
    }

    public FlashChart(Sheet sheet) {
        super(sheet);
    }

    @Override
    public boolean setBounds(int x, int y, int w, int h, boolean updateAnchor) {
        FlashChart.transitionBounds.x = x;
        FlashChart.transitionBounds.y = y;
        FlashChart.transitionBounds.width = w;
        FlashChart.transitionBounds.height = h;
        if (this.splitArray != null) {
            int len = this.splitArray.length / 2;
            for (int i = 0; i < len; ++i) {
                if (this.splitArray[i * 2] == null || this.splitArray[2 * i + 1] == null) continue;
                ((FlashChart)this.splitArray[2 * i + 1]).setBounds(x, y, w, h, updateAnchor);
                ((FlashChart)this.splitArray[2 * i + 1]).getPhysicalUI().setBounds(x, y, w, h);
                ((SpreadView)this.splitArray[i * 2]).revalidate();
                ((SpreadView)this.splitArray[i * 2]).doLayout();
            }
        }
        return super.setBounds(x, y, w, h, updateAnchor);
    }

    private void addPlayer() {
        if (this.player == null) {
            this.player = new JFlashPlayer(BrowserUtil.createNSOptions());
            this.player.setFocusable(false);
            this.player.getWebBrowser().addWebBrowserListener((WebBrowserListener)new WebBrowserAdapter(){

                public void windowWillOpen(WebBrowserWindowWillOpenEvent e) {
                    FlashChart.this.dealGraphRelationQuery(e);
                }
            });
            this.player.getNativeComponent().setFocusable(false);
            this._container.add((Component)this.player);
        }
    }

    public static void switchSWTVersion(KDPanel panel, boolean isSwitching64) {
        final KDWorkButton btn = new KDWorkButton(CtrlEXTMessages.getMLS("toggle", "\u5207\u6362"));
        BorderLayout layout = new BorderLayout();
        panel.setLayout((LayoutManager)layout);
        panel.setCustomInsets(new Insets(5, 5, 5, 5));
        KDTextArea area = new KDTextArea(CtrlEXTMessages.getMLS("currentEnvironment", "\u5f53\u524d\u73af\u5883") + (CtrlUtil.is64BitJVM() ? CtrlEXTMessages.getMLS("bit32SWT", "(32\u4f4dSWT)") : CtrlEXTMessages.getMLS("bit64SWT", "(64\u4f4dSWT)")) + CtrlEXTMessages.getMLS("unableToUseFunctionSwitch", "\u65e0\u6cd5\u4f7f\u7528\u8be5\u529f\u80fd, \u662f\u5426\u8fdb\u884c\u5207\u6362\uff1f") + CtrlEXTMessages.getMLS("clickSwitchAutomaticSwitch", "\u70b9\u51fb\u3010\u5207\u6362\u3011\u5c06\u4f1a\u81ea\u52a8\u5207\u6362, \u4e0b\u6b21\u542f\u52a8\u5ba2\u6237\u7aef\u751f\u6548") + "\n" + CtrlEXTMessages.getMLS("portalReportMobileReportChartViewable", "\u95e8\u6237\u62a5\u8868\u3001\u79fb\u52a8\u62a5\u8868\u7684\u56fe\u8868\u53ef\u4ee5\u6b63\u5e38\u67e5\u770b"));
        area.setEnabled(false);
        area.setBorder(null);
        KDScrollPane sPanel = new KDScrollPane((Component)area);
        panel.add((Component)sPanel, (Object)"Center");
        panel.add((Component)btn, (Object)"South");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                btn.setEnabled(false);
            }
        });
    }

    private void dealGraphRelationQuery(WebBrowserWindowWillOpenEvent event) {
        event.consume();
        if (this.main_flash == null) {
            CURRENT_FLASH = this;
        } else {
            CURRENT_FLASH = this.main_flash;
            this.getSheet().getEmbedments(false).selectEmbed(this.main_flash, 2);
        }
    }

    @Override
    public void paintData(Graphics g) {
        Color old = g.getColor();
        g.setColor(Color.LIGHT_GRAY);
        g.setColor(old);
        if (this._container != null) {
            this._container.setOpaque(false);
        }
        Rectangle bounds = this.getBounds();
        AbstractFusionBean bean = this.model.getBean();
        FusionChartDataNode dataNode = this.model.getDataNode();
        bean.setContainerWidth(bounds.width, dataNode);
        bean.setContainerHeight(bounds.height, dataNode);
        boolean sizeChanged = this.lastBounds.width != bounds.width || this.lastBounds.height != bounds.height;
        this.contact(sizeChanged);
        String xml = this.getXml();
        xml = this.editXml(xml);
        if (!this.save4Snap && (!StringUtil.isEmptyString((String)xml) && !xml.equals(this._xml) || sizeChanged)) {
            this._xml = xml;
            this.lastBounds = bounds;
            this.execute(this._xml);
        } else if (this.save4Snap && sizeChanged) {
            this.lastBounds = bounds;
            this.execute(this._xml);
        }
    }

    private String editXml(String xml) {
        return xml.substring(0, 7) + " exportCaptureCallback=\"exportImpl\" " + xml.substring(7);
    }

    private void contact(boolean refresh) {
        try {
            NativeComponent nativeComp = this.player.getNativeComponent();
            Field componentID = nativeComp.getClass().getSuperclass().getDeclaredField("componentID");
            ReflectUtil.makeAccessible((Field)componentID);
            Integer id = (Integer)componentID.get(nativeComp);
            this.model.getBean().setPlayerID(id);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void paintFocus(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle bounds = this.getBounds();
        int x = (int)((RectangularShape)bounds).getX();
        int y = (int)((RectangularShape)bounds).getY();
        int w = (int)((RectangularShape)bounds).getWidth();
        int h = (int)((RectangularShape)bounds).getHeight();
        int outArc = 12;
        int innerArc = 18;
        int distance = 6;
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double();
        ((RoundRectangle2D)rr).setRoundRect(x - distance, y - distance, w + 2 * distance, h + 2 * distance, w > outArc * 2 ? (double)outArc : (double)(w / 2), h > outArc * 2 ? (double)outArc : (double)(h / 2));
        RoundRectangle2D.Double innerRR = new RoundRectangle2D.Double();
        ((RoundRectangle2D)innerRR).setRoundRect(x, y, w, h, w > innerArc * 2 ? (double)innerArc : (double)(w / 2), h > innerArc * 2 ? (double)innerArc : (double)(h / 2));
        Graphics2D g2dd = (Graphics2D)g2d.create();
        this.focusArea = new Area(rr);
        this.focusArea.subtract(new Area(innerRR));
        g2dd.setColor(Color.gray);
        g2dd.draw(rr);
        Composite cps = g2d.getComposite();
        g2dd.setComposite(AlphaComposite.getInstance(3, 0.2f));
        g2dd.setColor(Color.cyan);
        g2dd.fill(this.focusArea);
        g2dd.setComposite(cps);
        this.paintTransformButton(g2dd, rr);
        this.paintHotSpot(g2dd, distance, x, y, w, h);
    }

    private void paintTransformButton(Graphics2D g2dd, RoundRectangle2D rr) {
        EmbedhLayer layer = this.model.getDataNode().getSheet().getEmbedments(false);
        if (layer != null && layer.selectionSize() > 1) {
            return;
        }
        if (MiscUtil.isExecutedBook(this.model.getDataNode().getSheet().getBook()) && StringUtil.isEmptyString((String)this.model.getBean().getTransformable_chart())) {
            return;
        }
        int x = (int)rr.getX();
        int y = (int)rr.getY();
        this.transfRect = new Rectangle(x, y - 20, 80, 20);
        g2dd.setComposite(AlphaComposite.getInstance(3, 0.6f));
        g2dd.fillRect(this.transfRect.x, this.transfRect.y, this.transfRect.width, this.transfRect.height);
        g2dd.setColor(Color.black);
        g2dd.setFont(new Font(null, 0, 12));
        g2dd.drawString(CtrlEXTMessages.getMLS("switchChart", "\u5207\u6362\u56fe\u8868"), x + 10, y - 6);
        int centerX = x + 70;
        int startY = y - 13;
        Polygon triangle = new Polygon();
        triangle.addPoint(centerX - 5, startY);
        triangle.addPoint(centerX + 5, startY);
        triangle.addPoint(centerX, startY + 5);
        g2dd.fill(triangle);
    }

    private void paintHotSpot(Graphics2D g2dd, int distance, int x, int y, int w, int h) {
        g2dd.setColor(Color.black);
        int ptDistance = distance / 2;
        int ptx = x - ptDistance;
        int pty = y - ptDistance;
        int ptx2 = x + w - 1 + ptDistance;
        int pty2 = y + h - 1 + ptDistance;
        g2dd.drawOval(ptx, pty, 1, 1);
        g2dd.drawOval(ptx + ++ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx, pty + ptDistance, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 - ptDistance, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + ptDistance, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + 2 * ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx2, pty, 1, 1);
        g2dd.drawOval(ptx2 - ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx2, pty + ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 + ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 + 2 * ptDistance, 1, 1);
        g2dd.drawOval(ptx2, pty2, 1, 1);
        g2dd.drawOval(ptx2 - ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx2, pty2 - ptDistance, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 - ptDistance, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + ptDistance, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + 2 * ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx, pty2, 1, 1);
        g2dd.drawOval(ptx + ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx, pty2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 + ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 + 2 * ptDistance, 1, 1);
    }

    @Override
    protected void loadCustom(byte[] str, boolean create) {
        try {
            byte id;
            KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
            this.model = new FlashChartModel();
            FusionChartDataNode data = new FusionChartDataNode(this._sheet);
            this.model.setDataNode(data);
            is.readString();
            FusionChartDataNode dn = this.model.getDataNode();
            block32: while ((id = is.readByte()) != 0) {
                switch (id) {
                    case 1: {
                        FlashChartType type = FlashChartType.getChartType(is.readString());
                        this.model.setChartType(type);
                        this.model.setBean(AbstractFusionBean.createBean(type));
                        this.model.getBean().setChartType(type);
                        dn.setChartType(this.model.getChartType());
                        continue block32;
                    }
                    case 2: {
                        dn.setDataFormula(is.readString());
                        continue block32;
                    }
                    case 3: {
                        dn.setGroupFormula(is.readString());
                        continue block32;
                    }
                    case 16: {
                        FusionChartDataNode data2 = this.model.getDataNode();
                        data2.setSeriesKeysFormula(is.readString());
                        continue block32;
                    }
                    case 5: {
                        dn.setChartTitleFormula(is.readString());
                        continue block32;
                    }
                    case 6: {
                        dn.setCategoryAxisTitleFormula(is.readString());
                        continue block32;
                    }
                    case 7: {
                        dn.setValueAxisTitleFormula(is.readString());
                        continue block32;
                    }
                    case 8: {
                        dn.setAngle(is.readInt());
                        continue block32;
                    }
                    case 9: {
                        dn.setSerialByCol(is.readBoolean());
                        continue block32;
                    }
                    case 11: {
                        dn.setDateFormat(is.readBoolean());
                        continue block32;
                    }
                    case 10: {
                        byte next = is.readByte();
                        dn.setExprTag(is.readLong());
                        next = is.readByte();
                        int i = 0;
                        while (next != 10) {
                            switch (next) {
                                case 12: {
                                    dn.setFormula(is.readString(), i++);
                                    break;
                                }
                                case 13: {
                                    String[] datas = this.readArray(is, is.readInt());
                                    AbstractChartPanel.repairUnSafeChar(datas);
                                    dn.setFormula(datas, i++);
                                    break;
                                }
                                case 14: {
                                    dn.setFormula((String)null, i++);
                                    break;
                                }
                            }
                            next = is.readByte();
                        }
                        continue block32;
                    }
                    case 17: {
                        this._xml = is.readString();
                        if (StringUtil.isEmptyString((String)this._xml)) continue block32;
                        this.save4Snap = true;
                        continue block32;
                    }
                    case 18: {
                        this.save4Snap = is.readBoolean();
                        continue block32;
                    }
                    case 19: {
                        String xml = is.readString();
                        if (ColorTemplateEditor.getBussinessSteadyTemplate().equalsIgnoreCase(xml) || ColorTemplateEditor.getElegantFacialTemplate().equalsIgnoreCase(xml) || ColorTemplateEditor.getNobleElegantTemplate().equalsIgnoreCase(xml) || ColorTemplateEditor.getPureSimpleTemplate().equalsIgnoreCase(xml) || ColorTemplateEditor.getSystemFusionchartsTemplate().equalsIgnoreCase(xml) || ColorTemplateEditor.getSystemQingchartsTemplate().equalsIgnoreCase(xml) || ColorTemplateEditor.getSystemTemplate().equalsIgnoreCase(xml)) {
                            dn.setColorXML(ColorTemplateEditor.getSystemSchemeDefault());
                        } else {
                            dn.setColorXML(xml);
                        }
                        this.model.getBean().getChartColorTemplate().setXmlValue(dn.getColorXML());
                        continue block32;
                    }
                    case 20: {
                        dn.setNumberFormatXML(is.readString());
                        this.model.getBean().getChartNumberFormat().setXmlValue(dn.getNumberFormatXML());
                        continue block32;
                    }
                    case 21: {
                        dn.setXyRestrictionXML(is.readString());
                        continue block32;
                    }
                    case 22: {
                        this.model.getBean().setLastSelectedIndex(is.readInt());
                        continue block32;
                    }
                    case 23: {
                        this.model.getBean().setTransformable_chart(is.readString());
                        continue block32;
                    }
                    case 24: {
                        String dataFrom = is.readString();
                        this.model.setDataFrom(dataFrom);
                        dn.setDataFrom(dataFrom);
                        if (!"dataset".equals(dataFrom)) continue block32;
                        try {
                            IXmlElement element = XmlUtil.loadXmlBytes((byte[])is.readLengthBytes());
                            dn.setFromDataset(ChartUtil.parseXml(element, this.model.getChartType()));
                        }
                        catch (XmlParsingException e) {
                            if (!MiscUtil.shouldLog()) continue block32;
                            MiscUtil.log(e);
                        }
                        continue block32;
                    }
                    case 25: {
                        ETTargets targets = KDSBinaryBook.readTransitionTarget(is, this._sheet, dn, -1);
                        this.model.setExtTargets(targets);
                        continue block32;
                    }
                    case 26: {
                        InnerLinkTargets innerTargets = KDSBinaryBook.readInnerTransitionTarget(is, this._sheet, dn);
                        this.model.setInnerTargets(innerTargets);
                        continue block32;
                    }
                }
            }
            is.close();
            this.model.getBean().setChartName(this.getName());
            this.model.setFrameWorkType(ChartFrameWorkType.FUSIONCART);
        }
        catch (IOException ioe) {
            logger.error((Object)"err", (Throwable)ioe);
        }
    }

    @Override
    protected byte[] saveCustom() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        try {
            FusionChartDataNode dn;
            out.writeString("1.1");
            String str = this.model.getChartType().getName();
            if (!StringUtil.isEmptyString((String)str)) {
                out.writeByte(1);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = (dn = this.model.getDataNode()).getDataFormula()))) {
                out.writeByte(2);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getGroupFormula()))) {
                out.writeByte(3);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = this.model.getDataNode().getSeriesKeysFormula()))) {
                out.writeByte(16);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getChartTitleFormula()))) {
                out.writeByte(5);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getCategoryAxisTitleFormula()))) {
                out.writeByte(6);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getValueAxisTitleFormula()))) {
                out.writeByte(7);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = this.model.getBean().getTransformable_chart()))) {
                out.writeByte(23);
                out.writeString(str);
            }
            out.writeByte(11);
            out.writeBoolean(dn.getDateFormat());
            out.writeByte(19);
            out.writeString(dn.getColorXML());
            out.writeByte(20);
            out.writeString(dn.getNumberFormatXML());
            out.writeByte(21);
            out.writeString(dn.getXyRestrictionXML());
            out.writeByte(22);
            out.writeInt(this.model.getBean().getLastSelectedIndex());
            out.writeByte(10);
            out.writeByte(15);
            out.writeLong(dn.getExprTag());
            int size = dn.getFormulaSize();
            for (int i = 0; i < size; ++i) {
                Object formulas = dn.getFormula(i);
                if (formulas instanceof String) {
                    out.writeByte(12);
                    out.writeString((String)formulas);
                    continue;
                }
                if (formulas instanceof String[]) {
                    out.writeByte(13);
                    this.writeArray(out, (String[])formulas);
                    continue;
                }
                if (formulas != null) continue;
                out.writeByte(14);
            }
            out.writeByte(10);
            out.writeByte(17);
            if (this.save4Snap) {
                this._xml = FlashChartModel.removeLinkProp(this._xml);
            }
            out.writeString(this._xml);
            out.writeByte(18);
            out.writeBoolean(this.save4Snap);
            out.writeByte(8);
            out.writeInt(dn.getAngle());
            out.writeByte(9);
            out.writeBoolean(dn.isSerialByCol());
            DataFromDataset fromDataset = dn.getFromDataset();
            if (fromDataset != null) {
                out.writeByte(24);
                out.writeString(this.model.getDataFrom());
                if ("dataset".equals(this.model.getDataFrom())) {
                    IXmlElement element = ChartUtil.toXml(fromDataset, this.model.getChartType());
                    byte[] xmlByte = XmlUtil.saveXmlBytes((IXmlElement)element);
                    out.writeLengthBytes(xmlByte);
                }
            }
            ExprContext ctx = this._sheet.getDeps().getExprContext();
            ETTargets targets = this.model.getExtTargets();
            BookToKds.writeTransitionTarget((byte)25, targets, out, ctx, dn);
            InnerLinkTargets innerTargets = this.model.getInnerTargets();
            BookToKds.writeInnerTransitionTarget((byte)26, innerTargets, out, ctx, dn);
            out.writeByte(0);
            out.close();
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return bs.toByteArray();
    }

    private String[] readArray(KDSDataInputStream in, int len) throws IOException {
        String[] arr = new String[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readString();
        }
        return arr;
    }

    private void writeArray(KDSDataOutputStream out, String[] arr) throws IOException {
        if (arr == null) {
            out.writeInt(0);
            return;
        }
        int len = arr.length;
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeString(arr[i]);
        }
    }

    @Override
    public synchronized Component getPhysicalUI() {
        if (this._container == null) {
            this._container = new KDPanel((LayoutManager)new BorderLayout());
            if (!SwingUtilities.isEventDispatchThread()) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        FlashChart.this.addPlayer();
                    }
                };
                SwingUtilities.invokeLater(t);
            } else {
                this.addPlayer();
            }
        }
        return this._container;
    }

    @Override
    public void setUIPhysical(boolean physical) {
    }

    @Override
    public Component getNativeComponent() {
        if (this.player == null) {
            return null;
        }
        return this.player.getNativeComponent();
    }

    @Override
    public void executeRefresh() {
        this.model.getDataNode().setDirty(true);
        this._xml = this.model.getXml();
        this._xml = this.editXml(this._xml);
        this.execute();
    }

    public void execute() {
        this.execute(this._xml);
    }

    public void split(final SpreadView[] splitViews) {
        if (splitViews == null || this.splitArray != null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int len = splitViews.length;
                if (FlashChart.this.splitArray == null || FlashChart.this.splitArray.length == 0) {
                    FlashChart.access$202(FlashChart.this, new Object[2 * len]);
                }
                Rectangle bounds = FlashChart.this.getBounds();
                for (int i = 0; i < len; ++i) {
                    FlashChart newChart = new FlashChart(FlashChart.this.getSheet(), FlashChart.this.getModel());
                    newChart.main_flash = FlashChart.this;
                    String xml = newChart.getModel().getXml();
                    newChart.setBounds(bounds);
                    Component physicUI = newChart.getPhysicalUI();
                    physicUI.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
                    if (splitViews[i] == null) continue;
                    splitViews[i].add(physicUI);
                    splitViews[i].revalidate();
                    newChart.execute(xml);
                    newChart.lastBounds = bounds;
                    ((FlashChart)FlashChart.this).splitArray[i * 2] = splitViews[i];
                    ((FlashChart)FlashChart.this).splitArray[i * 2 + 1] = newChart;
                }
            }
        });
    }

    @Override
    public void merge() {
        if (this.splitArray == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int len = FlashChart.this.splitArray.length / 2;
                for (int i = 0; i < len; ++i) {
                    if (FlashChart.this.splitArray[i * 2] == null || FlashChart.this.splitArray[i * 2 + 1] == null) continue;
                    ((SpreadView)FlashChart.this.splitArray[i * 2]).remove(((FlashChart)FlashChart.this.splitArray[i * 2 + 1]).getPhysicalUI());
                    ((SpreadView)FlashChart.this.splitArray[i * 2]).revalidate();
                }
                FlashChart.access$202(FlashChart.this, null);
            }
        });
    }

    public String getXml() {
        if (this.save4Snap && !StringUtil.isEmptyString((String)this._xml)) {
            return this._xml;
        }
        return this.getModel().getXml();
    }

    public void setXml(String xml) {
        this._xml = xml;
    }

    @Override
    public void execute(String xml) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        this.imageData = null;
        this._xml = xml;
        final FlashPluginOptions op = new FlashPluginOptions();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("debugMode", "0");
        map.put("dataXML", this._xml);
        map.put("allowFullScreen", "true");
        map.put("menu", "false");
        map.put("allowScriptAccess ", "sameDomain");
        map.put("registerWithJS", "1");
        op.setVariables(map);
        map = new HashMap();
        map.put("play", "0");
        map.put("scale ", "exactFit");
        map.put("menu ", "false");
        map.put("allowScriptAccess ", "sameDomain");
        map.put("registerWithJS", "1");
        map.put("wmode ", "transparent");
        op.setParameters(map);
        this.flashPath = FlashHelper.unpackSWF(this.getPhysicalUI(), this.model.getChartType());
        Thread flashExecutor = new Thread(){

            @Override
            public void run() {
                FlashChart.this.player.load(FlashChart.this.flashPath, op);
                Rectangle bounds = FlashChart.this._container.getBounds();
                bounds.x = 0;
                bounds.y = 0;
                FlashChart.this.player.setBounds(bounds);
                FlashChart.this.player.doLayout();
                FlashChart.this.player.validate();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FlashChart.this.play();
                    }
                });
            }
        };
        SwingUtilities.invokeLater(flashExecutor);
    }

    private void play() {
        this.calcBrowserSize(this.model.getBean());
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.player.stop();
        this.player.play();
        this._container.revalidate();
    }

    public String calcCellID(Cell cell, int bindingPolicy) {
        String ret = null;
        AbstractFusionBean bean = this.model.getBean();
        ret = bean.calcPlayerID(cell.getName(false, false), bindingPolicy);
        return ret;
    }

    private void calcBrowserSize(AbstractFusionBean bean) {
        Rectangle bounds = this.getBounds();
        int w = bean.getChartWidth();
        int h = bean.getChartHeight();
        boolean width = w > bounds.width;
        boolean height = h > bounds.height;
        JWebBrowser browser = this.player.getWebBrowser();
        browser.setJavascriptEnabled(true);
        if (width && height) {
            browser.executeJavascript(JAVASCRIPT_SCROLLBAR_BOTH);
            browser.executeJavascript(JAVASCRIPT_FLASHWIDTH_START + w + JAVASCRIPT_FLASHBOUNDS_END);
            browser.executeJavascript(JAVASCRIPT_FLASHHEIGHT_START + h + JAVASCRIPT_FLASHBOUNDS_END);
        } else if (width) {
            browser.executeJavascript(JAVASCTIPT_HORIZONTAL_SCROLLBAR_ONLY);
            browser.executeJavascript(JAVASCRIPT_FLASHWIDTH_START + w + JAVASCRIPT_FLASHBOUNDS_END);
        } else if (height) {
            browser.executeJavascript(JAVASCTIPT_VERTIVAL_SCROLLBAR_ONLY);
            browser.executeJavascript(JAVASCRIPT_FLASHHEIGHT_START + h + JAVASCRIPT_FLASHBOUNDS_END);
        }
    }

    @Override
    public BufferedImage exportToBufferedImage() {
        if (this.imageData != null) {
            return this.imageData;
        }
        try {
            Rectangle rect = this.getNativeComponent().getBounds();
            this.imageData = new BufferedImage(rect.width, rect.height, 2);
            ((NativeComponent)this.getNativeComponent()).paintComponent(this.imageData);
            if (this._src != null) {
                this._src.setCachedImg(this.imageData);
            }
            return this.imageData;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public BufferedImage getErrorImage() {
        BufferedImage ret = ChartImageUtil.getErrorImage();
        if (ret != null) {
            Rectangle rect = this.getBounds();
            this.setBounds(rect.x, rect.y, ret.getWidth(), ret.getHeight());
        }
        return ret;
    }

    public void setSrc(FlashChart src) {
        this._src = src;
    }

    public void setTransitionChart(boolean isTransitionChart) {
        this.isTransitionChart = isTransitionChart;
    }

    public boolean isTransitionChart() {
        return this.isTransitionChart;
    }

    public void enableExport4Snap() {
        if (this.save4Snap) {
            return;
        }
        this.save4Snap = true;
        this.model.getDataNode().setDirty(true);
        this._xml = this.model.getXml();
    }

    public String toString() {
        return this.getName();
    }

    static /* synthetic */ Object[] access$202(FlashChart x0, Object[] x1) {
        x0.splitArray = x1;
        return x1;
    }
}

