/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts;

import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.json.VarSerializer;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.FileUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StreamUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.AbstractChartPanel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.ResovlerHelper;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.io.kds.BookToKds;
import com.kingdee.cosmic.ctrl.kds.io.kds.KDSBinaryBook;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.INativeEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.IExecutePanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.util.ChartUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.IChartReadyFunction;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.ChartImageUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartDisplayPanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.function.QingChartHyperLinkHandler;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataInputStream;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataOutputStream;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import com.kingdee.cosmic.ctrl.swing.KDMenuItem;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDPopupMenu;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class QingChart
extends ChartRectEmbedment
implements INativeEmbedment {
    private static final Logger logger = LogUtil.getPackageLogger(QingChart.class);
    private QingChartDisplayPanel displayPanel;
    private KDPanel container;
    private QingChartFunctionInitializer readyFunctionInitor = new QingChartFunctionInitializer();
    private boolean save4Snap = false;
    private QingChart main_chart;
    private String lastExecutedScript;
    private Rectangle lastBounds = this.getBounds();
    public static Rectangle transitionBounds = new Rectangle();
    private QingChart src;

    public QingChart(Sheet sheet, FlashChartModel model) {
        super(sheet, model);
        this.main_chart = this;
    }

    public QingChart(Sheet sheet) {
        super(sheet);
        this.main_chart = this;
    }

    @Override
    public void paintData(Graphics g) {
        if (this.displayPanel == null) {
            return;
        }
        Color old = g.getColor();
        g.setColor(Color.LIGHT_GRAY);
        g.setColor(old);
        Rectangle bounds = this.getBounds();
        AbstractFusionBean bean = this.model.getBean();
        FusionChartDataNode dataNode = this.model.getDataNode();
        bean.setContainerWidth(bounds.width, dataNode);
        bean.setContainerHeight(bounds.height, dataNode);
        if (!this.displayPanel.isChartInited()) {
            return;
        }
        this.model.getDataNode().enableSnap(this.save4Snap);
        String script = QingTransferUtil.buildScript(this.model, !MiscUtil.isExecutedBook(this._sheet.getBook()));
        if (!StringUtil.isEmptyString((String)script) && !script.equals(this.lastExecutedScript)) {
            this.lastExecutedScript = script;
            this.execute(script);
        }
    }

    public boolean executeAndWait(long time, TimeUnit unit) {
        this.sleep(1);
        AbstractFusionBean bean = this.model.getBean();
        if (bean.getChartWidth() == 0 || bean.getChartHeight() == 0) {
            bean.setContainerWidth(this._width, null);
            bean.setContainerHeight(this._height, null);
        }
        this.executeRefresh();
        this.sleep(1);
        this.exportToBufferedImage();
        return true;
    }

    private void sleep(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void paintFocus(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle bounds = this.getBounds();
        int x = (int)((RectangularShape)bounds).getX();
        int y = (int)((RectangularShape)bounds).getY();
        int w = (int)((RectangularShape)bounds).getWidth();
        int h = (int)((RectangularShape)bounds).getHeight();
        int outArc = 12;
        int innerArc = 18;
        int distance = 6;
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double();
        ((RoundRectangle2D)rr).setRoundRect(x - distance, y - distance, w + 2 * distance, h + 2 * distance, w > outArc * 2 ? (double)outArc : (double)(w / 2), h > outArc * 2 ? (double)outArc : (double)(h / 2));
        RoundRectangle2D.Double innerRR = new RoundRectangle2D.Double();
        ((RoundRectangle2D)innerRR).setRoundRect(x, y, w, h, w > innerArc * 2 ? (double)innerArc : (double)(w / 2), h > innerArc * 2 ? (double)innerArc : (double)(h / 2));
        Graphics2D g2dd = (Graphics2D)g2d.create();
        this.focusArea = new Area(rr);
        this.focusArea.subtract(new Area(innerRR));
        g2dd.setColor(Color.gray);
        g2dd.draw(rr);
        Composite cps = g2d.getComposite();
        g2dd.setComposite(AlphaComposite.getInstance(3, 0.2f));
        g2dd.setColor(Color.cyan);
        g2dd.fill(this.focusArea);
        g2dd.setComposite(cps);
        this.paintTransformButton(g2dd, rr);
        this.paintHotSpot(g2dd, distance, x, y, w, h);
    }

    private void paintTransformButton(Graphics2D g2dd, RoundRectangle2D rr) {
        EmbedhLayer layer = this.model.getDataNode().getSheet().getEmbedments(false);
        if (layer != null && layer.selectionSize() > 1) {
            return;
        }
        if (!MiscUtil.isExecutedBook(this.model.getDataNode().getSheet().getBook()) || StringUtil.isEmptyString((String)this.model.getBean().getTransformable_chart())) {
            return;
        }
        int x = (int)rr.getX();
        int y = (int)rr.getY();
        this.transfRect = new Rectangle(x, y - 20, 80, 20);
        g2dd.setComposite(AlphaComposite.getInstance(3, 0.6f));
        g2dd.fillRect(this.transfRect.x, this.transfRect.y, this.transfRect.width, this.transfRect.height);
        g2dd.setColor(Color.black);
        g2dd.setFont(new Font(null, 0, 12));
        g2dd.drawString(CtrlEXTMessages.getMLS("switchChart", "\u5207\u6362\u56fe\u8868"), x + 10, y - 6);
        int centerX = x + 70;
        int startY = y - 13;
        Polygon triangle = new Polygon();
        triangle.addPoint(centerX - 5, startY);
        triangle.addPoint(centerX + 5, startY);
        triangle.addPoint(centerX, startY + 5);
        g2dd.fill(triangle);
    }

    private void paintHotSpot(Graphics2D g2dd, int distance, int x, int y, int w, int h) {
        g2dd.setColor(Color.black);
        int ptDistance = distance / 2;
        int ptx = x - ptDistance;
        int pty = y - ptDistance;
        int ptx2 = x + w - 1 + ptDistance;
        int pty2 = y + h - 1 + ptDistance;
        g2dd.drawOval(ptx, pty, 1, 1);
        g2dd.drawOval(ptx + ++ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx, pty + ptDistance, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 - ptDistance, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + ptDistance, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + 2 * ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx2, pty, 1, 1);
        g2dd.drawOval(ptx2 - ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx2, pty + ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 + ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 + 2 * ptDistance, 1, 1);
        g2dd.drawOval(ptx2, pty2, 1, 1);
        g2dd.drawOval(ptx2 - ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx2, pty2 - ptDistance, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 - ptDistance, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + ptDistance, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + 2 * ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx, pty2, 1, 1);
        g2dd.drawOval(ptx + ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx, pty2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 + ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 + 2 * ptDistance, 1, 1);
    }

    public void addDisplayPanel() {
        this.displayPanel = new QingChartDisplayPanel(this.readyFunctionInitor, null, false, false);
        this.container.add((Component)this.displayPanel.getDisplayPanel(), (Object)"Center");
    }

    public QingChartDisplayPanel getDisplayPanel() {
        return this.displayPanel;
    }

    @Override
    protected byte[] saveCustom() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        try {
            FusionChartDataNode dn;
            out.writeString("1.4");
            String str = this.model.getChartType().getName();
            if (!StringUtil.isEmptyString((String)str)) {
                out.writeByte(1);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = (dn = this.model.getDataNode()).getDataFormula()))) {
                out.writeByte(2);
                out.writeString(str);
            }
            GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Var.class, (Object)new VarSerializer()).serializeSpecialFloatingPointValues().setPrettyPrinting().disableHtmlEscaping();
            if (dn.getDataWithoutCalc() != null) {
                Object dataWithoutCalc = dn.getDataWithoutCalc();
                out.writeByte(28);
                if (dataWithoutCalc instanceof double[][]) {
                    out.writeByte(2);
                    out.writeString(JsonUtil.encodeToString(gsonBuilder, dataWithoutCalc));
                } else if (dataWithoutCalc instanceof Object[]) {
                    out.writeByte(1);
                    for (Object obj : (Object[])dataWithoutCalc) {
                        if (obj instanceof double[][]) {
                            out.writeByte(2);
                        } else if (obj instanceof double[]) {
                            out.writeByte(5);
                        } else if (obj instanceof Double) {
                            out.writeByte(6);
                        }
                        out.writeString(JsonUtil.encodeToString(gsonBuilder, obj));
                    }
                    out.writeByte(28);
                }
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getGroupFormula()))) {
                out.writeByte(3);
                out.writeString(str);
            }
            if (dn.getGroupKeysWithoutCalc() != null && dn.getGroupKeysWithoutCalc().length > 0) {
                out.writeByte(29);
                out.writeString(JsonUtil.encodeToString(dn.getGroupKeysWithoutCalc()));
            }
            if (!StringUtil.isEmptyString((String)(str = this.model.getDataNode().getSeriesKeysFormula()))) {
                out.writeByte(16);
                out.writeString(str);
            }
            if (dn.getSeriesKeysWithoutCalc() != null) {
                out.writeByte(30);
                Object seriesKeys = dn.getSeriesKeysWithoutCalc();
                if (seriesKeys instanceof String[]) {
                    out.writeByte(3);
                    out.writeString(JsonUtil.encodeToString(seriesKeys));
                } else if (seriesKeys instanceof Object[]) {
                    out.writeByte(1);
                    for (Object obj : (Object[])seriesKeys) {
                        if (obj instanceof String[]) {
                            out.writeByte(3);
                        } else if (obj instanceof String) {
                            out.writeByte(4);
                        }
                        out.writeString(JsonUtil.encodeToString(obj));
                    }
                    out.writeByte(30);
                }
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getChartTitleFormula()))) {
                out.writeByte(5);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getCategoryAxisTitleFormula()))) {
                out.writeByte(6);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getValueAxisTitleFormula()))) {
                out.writeByte(7);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = this.model.getBean().getTransformable_chart()))) {
                out.writeByte(23);
                out.writeString(str);
            }
            out.writeByte(11);
            out.writeBoolean(dn.getDateFormat());
            out.writeByte(19);
            out.writeString(dn.getColorXML());
            out.writeByte(20);
            out.writeString(dn.getNumberFormatXML());
            out.writeByte(21);
            out.writeString(dn.getXyRestrictionXML());
            out.writeByte(22);
            out.writeInt(this.model.getBean().getLastSelectedIndex());
            out.writeByte(10);
            out.writeByte(15);
            out.writeLong(dn.getExprTag());
            int size = dn.getFormulaSize();
            for (int i = 0; i < size; ++i) {
                Object formulas = dn.getFormula(i);
                if (formulas instanceof String) {
                    out.writeByte(12);
                    out.writeString((String)formulas);
                    continue;
                }
                if (formulas instanceof String[]) {
                    out.writeByte(13);
                    this.writeArray(out, (String[])formulas);
                    continue;
                }
                if (formulas != null) continue;
                out.writeByte(14);
            }
            out.writeByte(10);
            out.writeByte(18);
            out.writeBoolean(this.save4Snap);
            out.writeByte(8);
            out.writeInt(dn.getAngle());
            out.writeByte(9);
            out.writeBoolean(dn.isSerialByCol());
            DataFromDataset fromDataset = dn.getFromDataset();
            if (fromDataset != null) {
                out.writeByte(24);
                out.writeString(this.model.getDataFrom());
                if ("dataset".equals(this.model.getDataFrom())) {
                    IXmlElement element = ChartUtil.toXml(fromDataset, this.model.getChartType());
                    byte[] xmlByte = XmlUtil.saveXmlBytes((IXmlElement)element);
                    out.writeLengthBytes(xmlByte);
                }
            }
            ExprContext ctx = this._sheet.getDeps().getExprContext();
            ETTargets targets = this.model.getExtTargets();
            BookToKds.writeTransitionTarget((byte)25, targets, out, ctx, dn);
            InnerLinkTargets innerTargets = this.model.getInnerTargets();
            BookToKds.writeInnerTransitionTarget((byte)26, innerTargets, out, ctx, dn);
            if (this.displayPanel != null && !StringUtil.isEmptyString((String)(str = this.displayPanel.getChartID())) || !StringUtil.isEmptyString((String)(str = this.model.getChartID()))) {
                out.writeByte(27);
                out.writeString(str);
            }
            out.writeByte(35);
            int size2 = dn.getResultSize();
            for (int i = 0; i < size2; ++i) {
                out.writeByte(1);
                Object resultFormal = dn.getResult(i);
                if (resultFormal == null) {
                    out.writeByte(14);
                    continue;
                }
                for (Object obj : (Object[])resultFormal) {
                    if (obj instanceof Variant[][]) {
                        out.writeByte(8);
                    } else if (obj == null) {
                        out.writeByte(14);
                    }
                    out.writeString(JsonUtil.encodeToString(gsonBuilder, obj));
                }
                out.writeByte(1);
            }
            out.writeByte(35);
            out.writeByte(36);
            out.writeBoolean(dn.isDirty());
            out.writeByte(0);
            out.close();
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return bs.toByteArray();
    }

    private void writeArray(KDSDataOutputStream out, String[] arr) throws IOException {
        if (arr == null) {
            out.writeInt(0);
            return;
        }
        int len = arr.length;
        out.writeInt(len);
        for (String s : arr) {
            out.writeString(s);
        }
    }

    private String[] readArray(KDSDataInputStream in, int len) throws IOException {
        String[] arr = new String[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readString();
        }
        return arr;
    }

    @Override
    protected void loadCustom(byte[] str, boolean create) {
        try {
            byte id;
            KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
            this.model = new FlashChartModel();
            FusionChartDataNode data = new FusionChartDataNode(this._sheet);
            this.model.setDataNode(data);
            String version = is.readString();
            FusionChartDataNode dn = this.model.getDataNode();
            block45: while ((id = is.readByte()) != 0) {
                switch (id) {
                    case 1: {
                        QingChartType type = QingChartType.getType(is.readString());
                        this.model.setChartType(type);
                        this.model.setBean(AbstractFusionBean.createBean(type));
                        this.model.getBean().setChartType(type);
                        dn.setChartType(this.model.getChartType());
                        continue block45;
                    }
                    case 2: {
                        dn.setDataFormula(is.readString());
                        continue block45;
                    }
                    case 28: {
                        if ("1.1".equals(version)) {
                            dn.setData(JsonUtil.decodeFromString(is.readString(), double[][].class));
                            continue block45;
                        }
                        if (this.laterThan("1.3", version)) {
                            byte dataType = is.readByte();
                            if (dataType == 1) {
                                byte tag;
                                ArrayList<Object> list = new ArrayList<Object>(8);
                                while ((tag = is.readByte()) != 28) {
                                    if (tag == 2) {
                                        list.add(JsonUtil.decodeFromString(is.readString(), double[][].class));
                                        continue;
                                    }
                                    if (tag == 5) {
                                        list.add(JsonUtil.decodeFromString(is.readString(), double[].class));
                                        continue;
                                    }
                                    if (tag != 6) continue;
                                    list.add(JsonUtil.decodeFromString(is.readString(), Double.class));
                                }
                                dn.setData(list.toArray());
                                continue block45;
                            }
                            if (dataType != 2) continue block45;
                            dn.setData(JsonUtil.decodeFromString(is.readString(), double[][].class));
                            continue block45;
                        }
                        if (!this.laterThan("1.1", version)) continue block45;
                        byte dataType = is.readByte();
                        if (dataType == 1) {
                            dn.setData(JsonUtil.decodeFromString(is.readString(), Object[].class));
                            continue block45;
                        }
                        if (dataType != 2) continue block45;
                        dn.setData(JsonUtil.decodeFromString(is.readString(), double[][].class));
                        continue block45;
                    }
                    case 3: {
                        dn.setGroupFormula(is.readString());
                        continue block45;
                    }
                    case 29: {
                        dn.setGroupKeys(JsonUtil.decodeFromString(is.readString(), String[].class));
                        continue block45;
                    }
                    case 16: {
                        FusionChartDataNode data2 = this.model.getDataNode();
                        data2.setSeriesKeysFormula(is.readString());
                        continue block45;
                    }
                    case 30: {
                        if (this.laterThan("1.3", version)) {
                            byte dataType = is.readByte();
                            if (dataType == 1) {
                                byte tag;
                                ArrayList<Object> list = new ArrayList<Object>(8);
                                while ((tag = is.readByte()) != 30) {
                                    if (tag == 3) {
                                        list.add(JsonUtil.decodeFromString(is.readString(), String[].class));
                                        continue;
                                    }
                                    if (tag != 4) continue;
                                    list.add(JsonUtil.decodeFromString(is.readString(), String.class));
                                }
                                dn.setSerieskeys(list.toArray());
                                continue block45;
                            }
                            if (dataType != 3) continue block45;
                            dn.setSerieskeys(JsonUtil.decodeFromString(is.readString(), String[].class));
                            continue block45;
                        }
                        if (this.laterThan("1.2", version)) {
                            byte dataType = is.readByte();
                            if (dataType == 1) {
                                dn.setSerieskeys(JsonUtil.decodeFromString(is.readString(), Object[].class));
                                continue block45;
                            }
                            if (dataType != 3) continue block45;
                            dn.setSerieskeys(JsonUtil.decodeFromString(is.readString(), String[].class));
                            continue block45;
                        }
                        dn.setSerieskeys(JsonUtil.decodeFromString(is.readString(), String[].class));
                        continue block45;
                    }
                    case 5: {
                        dn.setChartTitleFormula(is.readString());
                        continue block45;
                    }
                    case 6: {
                        dn.setCategoryAxisTitleFormula(is.readString());
                        continue block45;
                    }
                    case 7: {
                        dn.setValueAxisTitleFormula(is.readString());
                        continue block45;
                    }
                    case 8: {
                        dn.setAngle(is.readInt());
                        continue block45;
                    }
                    case 9: {
                        dn.setSerialByCol(is.readBoolean());
                        continue block45;
                    }
                    case 11: {
                        dn.setDateFormat(is.readBoolean());
                        continue block45;
                    }
                    case 10: {
                        byte next = is.readByte();
                        dn.setExprTag(is.readLong());
                        next = is.readByte();
                        int i = 0;
                        while (next != 10) {
                            switch (next) {
                                case 12: {
                                    dn.setFormula(is.readString(), i++);
                                    break;
                                }
                                case 13: {
                                    String[] datas = this.readArray(is, is.readInt());
                                    AbstractChartPanel.repairUnSafeChar(datas);
                                    dn.setFormula(datas, i++);
                                    break;
                                }
                                case 14: {
                                    dn.setFormula((String)null, i++);
                                    break;
                                }
                            }
                            next = is.readByte();
                        }
                        continue block45;
                    }
                    case 35: {
                        byte rNext = is.readByte();
                        int j = 0;
                        while (rNext != 35) {
                            if (rNext == 1) {
                                rNext = is.readByte();
                                switch (rNext) {
                                    case 8: {
                                        byte tag;
                                        ArrayList<Variant[][]> list = new ArrayList<Variant[][]>(8);
                                        do {
                                            list.add(JsonUtil.decodeFromString(is.readString(), Variant[][].class));
                                        } while ((tag = is.readByte()) != 1);
                                        dn.setResult(list.toArray(), j++);
                                        break;
                                    }
                                    case 14: {
                                        dn.setResult(null, j++);
                                        break;
                                    }
                                }
                            }
                            rNext = is.readByte();
                        }
                        continue block45;
                    }
                    case 36: {
                        dn.setDirty(is.readBoolean());
                        continue block45;
                    }
                    case 18: {
                        this.save4Snap = is.readBoolean();
                        continue block45;
                    }
                    case 19: {
                        dn.setColorXML(is.readString());
                        this.model.getBean().getChartColorTemplate().setXmlValue(dn.getColorXML());
                        continue block45;
                    }
                    case 20: {
                        dn.setNumberFormatXML(is.readString());
                        this.model.getBean().getChartNumberFormat().setXmlValue(dn.getNumberFormatXML());
                        continue block45;
                    }
                    case 21: {
                        dn.setXyRestrictionXML(is.readString());
                        continue block45;
                    }
                    case 22: {
                        this.model.getBean().setLastSelectedIndex(is.readInt());
                        continue block45;
                    }
                    case 23: {
                        this.model.getBean().setTransformable_chart(is.readString());
                        continue block45;
                    }
                    case 24: {
                        String dataFrom = is.readString();
                        this.model.setDataFrom(dataFrom);
                        dn.setDataFrom(dataFrom);
                        if (!"dataset".equals(dataFrom)) continue block45;
                        try {
                            IXmlElement element = XmlUtil.loadXmlBytes((byte[])is.readLengthBytes());
                            dn.setFromDataset(ChartUtil.parseXml(element, this.model.getChartType()));
                        }
                        catch (XmlParsingException e) {
                            if (!MiscUtil.shouldLog()) continue block45;
                            MiscUtil.log(e);
                        }
                        continue block45;
                    }
                    case 25: {
                        ETTargets targets = KDSBinaryBook.readTransitionTarget(is, this._sheet, dn, -1);
                        this.model.setExtTargets(targets);
                        continue block45;
                    }
                    case 26: {
                        InnerLinkTargets innerTargets = KDSBinaryBook.readInnerTransitionTarget(is, this._sheet, dn);
                        this.model.setInnerTargets(innerTargets);
                        continue block45;
                    }
                    case 27: {
                        this.model.setChartID(is.readString());
                        continue block45;
                    }
                    case 17: {
                        is.readString();
                        continue block45;
                    }
                    case 31: {
                        is.readString();
                        continue block45;
                    }
                    case 33: {
                        is.readString();
                        continue block45;
                    }
                    case 34: {
                        is.readString();
                        continue block45;
                    }
                }
            }
            is.close();
            this.model.getBean().setChartName(this.getName());
            this.model.setFrameWorkType(ChartFrameWorkType.QINGCHART);
        }
        catch (IOException ioe) {
            logger.error((Object)"err", (Throwable)ioe);
        }
    }

    private boolean laterThan(String preVersion, String currVersion) {
        if (StringUtil.isEmptyString((String)preVersion) || StringUtil.isEmptyString((String)currVersion)) {
            return false;
        }
        return new BigDecimal(currVersion).compareTo(new BigDecimal(preVersion)) > 0;
    }

    @Override
    public Component getPhysicalUI() {
        if (this.container == null) {
            this.container = new KDPanel((LayoutManager)new BorderLayout());
            if (!SwingUtilities.isEventDispatchThread()) {
                Runnable t = () -> {
                    if (null == this.displayPanel) {
                        this.addDisplayPanel();
                    }
                };
                SwingUtilities.invokeLater(t);
            } else if (null == this.displayPanel) {
                this.addDisplayPanel();
            }
        }
        return this.container;
    }

    @Override
    public void setUIPhysical(boolean physical) {
    }

    @Override
    public void execute(String script) {
        this.displayPanel.execute(script);
        if (this.splitArray != null && this.splitArray.length > 0) {
            int len = this.splitArray.length / 2;
            for (int i = 0; i < len; ++i) {
                QingChart splitQingChart;
                QingChartDisplayPanel panel;
                if (this.splitArray[i * 2] == null || this.splitArray[2 * i + 1] == null || !(panel = (splitQingChart = (QingChart)this.splitArray[2 * i + 1]).getDisplayPanel()).isChartInited()) continue;
                splitQingChart.execute(script);
            }
        }
    }

    @Override
    public void executeRefresh() {
        this.model.getDataNode().setDirty(true);
        this.model.getDataNode().enableSnap(this.save4Snap);
        String script = QingTransferUtil.buildScript(this.model, !MiscUtil.isExecutedBook(this._sheet.getBook()));
        if (this.save4Snap) {
            this.model.getDataNode().enableSnap(false);
        }
        this.lastExecutedScript = script;
        this.execute(script);
    }

    public void enableExport4Snap() {
        if (this.save4Snap) {
            return;
        }
        this.save4Snap = true;
        this.model.getDataNode().setDirty(true);
        this.model.getDataNode().enableSnap(true);
        AbstractFusionBean bean = this.model.getBean();
        bean.setContainerWidth(this.getWidth(), null);
        bean.setContainerHeight(this.getHeight(), null);
        this.lastExecutedScript = QingTransferUtil.buildScript(this.model, !MiscUtil.isExecutedBook(this._sheet.getBook()));
    }

    @Override
    public void split(SpreadView[] splitViews, SpreadContext.PhysicalEmbedXListener listener) {
        if (splitViews == null || this.splitArray != null) {
            return;
        }
        int len = splitViews.length;
        if (this.splitArray == null || this.splitArray.length == 0) {
            this.splitArray = new Object[2 * len];
        }
        Rectangle bounds = this.getBounds();
        for (int i = 0; i < len; ++i) {
            QingChart newChart = new QingChart(this.getSheet(), this.getModel());
            newChart.main_chart = this;
            newChart.getModel().getXml();
            newChart.setBounds(bounds);
            Component physicUI = newChart.getPhysicalUI();
            physicUI.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
            if (splitViews[i] == null) continue;
            splitViews[i].add(physicUI);
            splitViews[i].revalidate();
            if (null != listener) {
                if (newChart.getDisplayPanel() == null) {
                    newChart.addDisplayPanel();
                }
                newChart.getNativeComponent().addMouseListener(listener);
                newChart.getNativeComponent().addKeyListener(listener);
            }
            newChart.lastBounds = bounds;
            this.splitArray[i * 2] = splitViews[i];
            this.splitArray[i * 2 + 1] = newChart;
        }
    }

    @Override
    public boolean setBounds(int x, int y, int w, int h, boolean updateAnchor) {
        QingChart.transitionBounds.x = x;
        QingChart.transitionBounds.y = y;
        QingChart.transitionBounds.width = w;
        QingChart.transitionBounds.height = h;
        if (this.splitArray != null) {
            int len = this.splitArray.length / 2;
            for (int i = 0; i < len; ++i) {
                if (this.splitArray[i * 2] == null || this.splitArray[2 * i + 1] == null) continue;
                ((QingChart)this.splitArray[2 * i + 1]).setBounds(x, y, w, h, updateAnchor);
                ((QingChart)this.splitArray[2 * i + 1]).getPhysicalUI().setBounds(x, y, w, h);
                ((SpreadView)this.splitArray[i * 2]).revalidate();
                ((SpreadView)this.splitArray[i * 2]).doLayout();
            }
        }
        return super.setBounds(x, y, w, h, updateAnchor);
    }

    @Override
    public String getLastExecutedScript() {
        if (StringUtil.isEmptyString((String)this.lastExecutedScript)) {
            AbstractFusionBean bean = this.model.getBean();
            this.model.getDataNode().enableSnap(true);
            bean.setContainerWidth(this.getWidth(), null);
            bean.setContainerHeight(this.getHeight(), null);
            this.lastExecutedScript = QingTransferUtil.buildScript(this.model, !MiscUtil.isExecutedBook(this._sheet.getBook()));
            this.model.getDataNode().enableSnap(false);
        }
        return this.lastExecutedScript;
    }

    @Override
    public void merge() {
        if (this.splitArray == null) {
            return;
        }
        int len = this.splitArray.length / 2;
        for (int i = 0; i < len; ++i) {
            if (this.splitArray[i * 2] == null || this.splitArray[i * 2 + 1] == null) continue;
            ((SpreadView)this.splitArray[i * 2]).remove(((QingChart)this.splitArray[i * 2 + 1]).getPhysicalUI());
            ((SpreadView)this.splitArray[i * 2]).revalidate();
            ((SpreadView)this.splitArray[i * 2]).repaint();
        }
        this.splitArray = null;
    }

    @Override
    public Component getNativeComponent() {
        return this.displayPanel.getNativeComponent();
    }

    public void setSrc(QingChart c) {
        this.src = c;
    }

    @Override
    public BufferedImage exportToBufferedImage() {
        if (this.imageData != null) {
            return this.imageData;
        }
        try {
            Rectangle rect = this.getNativeComponent().getBounds();
            this.imageData = new BufferedImage(rect.width, rect.height, 2);
            Graphics g = this.imageData.getGraphics();
            this.getNativeComponent().paint(g);
            g.dispose();
            if (this.src != null) {
                this.src.setCachedImg(this.imageData);
            }
            return this.imageData;
        }
        catch (Exception ex) {
            logger.error((Object)"err", (Throwable)ex);
            return this.getErrorImage();
        }
    }

    public BufferedImage getErrorImage() {
        BufferedImage ret = ChartImageUtil.getErrorImage();
        if (ret != null) {
            Rectangle rect = this.getBounds();
            this.setBounds(rect.x, rect.y, ret.getWidth(), ret.getHeight());
        }
        return ret;
    }

    @Override
    public void destory() {
        if (null != this.displayPanel) {
            this.displayPanel.close();
        }
    }

    public void initFunctions(IExecutePanel browser) {
        if (!MiscUtil.isExecutedBook(this._sheet.getBook())) {
            this.displayPanel.getNativeComponent().addMouseListener(new QingChartRightMouseClickListener());
        } else {
            this.displayPanel.registerClickHandler(new QingChartHyperLinkHandler(ResovlerHelper.getCurrentChartSpreadContext(this)));
        }
    }

    @Override
    public String getEmbedId() {
        if (this.displayPanel != null) {
            return this.displayPanel.getChartID();
        }
        return null;
    }

    private class QingChartFunctionInitializer
    implements IChartReadyFunction {
        private List<IChartReadyFunction> functions = new ArrayList<IChartReadyFunction>();

        private QingChartFunctionInitializer() {
        }

        @Override
        public void onReady(IExecutePanel browser) {
            QingChart.this.initFunctions(browser);
            for (IChartReadyFunction f : this.functions) {
                f.onReady(browser);
            }
            QingChart.this.executeRefresh();
        }

        public void addReadyFunction(IChartReadyFunction f) {
            if (null != f) {
                this.functions.add(f);
            }
        }
    }

    private class QingChartRightMouseClickListener
    extends MouseAdapter {
        private KDPopupMenu popMenu = new KDPopupMenu();

        public QingChartRightMouseClickListener() {
            KDMenuItem menuItem = new KDMenuItem(CtrlEXTMessages.getMLS("setChartProperties", "\u8bbe\u7f6e\u56fe\u8868\u5c5e\u6027"));
            menuItem.addActionListener(e -> {
                SpreadContext context = ResovlerHelper.getCurrentChartSpreadContext(QingChart.this.main_chart);
                ResovlerHelper.showStepWizzard(context, QingChart.this.main_chart, "chartSettings");
            });
            this.popMenu.add((JMenuItem)menuItem);
            KDMenuItem picItem = new KDMenuItem(CtrlEXTMessages.getMLS("saveAsImage", "\u53e6\u5b58\u4e3a\u56fe\u7247"));
            picItem.setVisible(false);
            picItem.addActionListener(e -> {
                KDFileChooser chooser = new KDFileChooser();
                Window w = SwingUtilities.getWindowAncestor((Component)((Object)ResovlerHelper.getCurrentChartSpreadContext(QingChart.this)));
                chooser.setSelectedFile(new File(FilenameUtils.normalize((String)(QingChart.this.getModel().getChartType().getAlias() + ".png"))));
                int option = chooser.showSaveDialog((Component)w);
                if (option == 0) {
                    File f = chooser.getSelectedFile();
                    try {
                        String path = f.getCanonicalPath();
                        if (!path.toLowerCase(Locale.CHINA).endsWith(".png")) {
                            path = path + ".png";
                        }
                        f = FileUtil.createFile((String)path);
                        this.saveImageToFile(f);
                    }
                    catch (Exception e1) {
                        logger.error((Object)"err", (Throwable)e1);
                    }
                }
            });
            this.popMenu.add((JMenuItem)picItem);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3 && !this.popMenu.isVisible()) {
                this.showMenu(e.getX(), e.getY());
            }
        }

        public void showMenu(int x, int y) {
            this.popMenu.show(QingChart.this.getNativeComponent(), x, y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean saveImageToFile(File f) {
            BufferedImage image = QingChart.this.exportToBufferedImage();
            FileOutputStream fos = null;
            boolean flag = false;
            try {
                fos = new FileOutputStream(f);
                flag = ImageIO.write((RenderedImage)image, ".png".substring(1), fos);
            }
            catch (IOException e) {
                try {
                    logger.error((Object)"err", (Throwable)e);
                }
                catch (Throwable throwable) {
                    StreamUtil.closeCloseable(fos);
                    throw throwable;
                }
                StreamUtil.closeCloseable((Closeable)fos);
            }
            StreamUtil.closeCloseable((Closeable)fos);
            return flag;
        }
    }
}

