/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.ColorUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartFactory;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.DiscreteColorConfirmer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.TreeChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.IQingChartTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.GsonUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.swing.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractQingChart {
    protected AbstractNormalChartModel chartModel;
    protected TreeChartModel treeChartModel;
    protected Map<String, String> styles;
    protected transient List<String> colors;
    protected transient DiscreteColorConfirmer colorConfirmer;

    public String initScript(FlashChartModel model) {
        AbstractQingChart chart = this.assembleChart(model);
        return String.format("funChartDoDraw('%s','%s', %d, %d)", model.getChartType().getName(), chart, model.getBean().getChartWidth() + 10, model.getBean().getChartHeight() + 6);
    }

    public abstract AbstractNormalChartModel loadDemoData();

    public String initDemoScript(FlashChartModel model) {
        this.configDemoCustomStyle(model);
        int w = model.getBean().getChartWidth() == 0 ? 691 : model.getBean().getChartWidth() + 10;
        int h = model.getBean().getChartHeight() == 0 ? 240 : model.getBean().getChartHeight() + 6;
        return String.format("funChartDoDraw('%s','%s', %d, %d)", model.getChartType().getName(), this, w, h);
    }

    protected void configDemoCustomStyle(FlashChartModel model) {
        Chart chart = model.getBean().getChart();
        model.getBean().buildChart(model.getDataNode());
        this.setChartModel(this.loadDemoData());
        this.colors = QingTransferUtil.toRGBA(model.getBean().initColors());
        List<AbstractNormalChartModel.Series> series = this.chartModel.getSeries();
        for (int i = 0; i < series.size(); ++i) {
            series.get(i).setColor(this.colors.get(i / this.colors.size()));
        }
        this.configureDemo(model);
        this.configureDataFormat(model);
        this.collectLegend();
        this.addStyle(QingStyle.BACKGROUND, chart);
        this.addStyle("legendFontSize", chart.baseFontSize);
        this.addStyle("dataLabelFontSize", chart.baseFontSize);
        this.addStyle("axisFontSize", chart.baseFontSize);
        this.addStyle("rulerFontSize", chart.baseFontSize);
        this.addStyle("reflineTipsFontSize", chart.baseFontSize);
    }

    public final AbstractQingChart assembleChart(FlashChartModel model) {
        IQingChartTransfer transferImpl = QingChartFactory.getTransferImpl(model.getChartType());
        transferImpl.prepare(model);
        AbstractQingChart qingChart = transferImpl.process(model);
        transferImpl.after();
        return qingChart;
    }

    public void collectLegend() {
        this.colorConfirmer = new DiscreteColorConfirmer(this.colors.toArray(new String[0]), Integer.MAX_VALUE);
        for (int i = 0; i < this.chartModel.getSeries().size(); ++i) {
            AbstractNormalChartModel.Series series = this.chartModel.getSeries().get(i);
            if (series.getName() == null) {
                series.setName("");
            }
            series.setOrderingValue(i);
            series.setColor(this.colors.get(i % this.colors.size()));
            this.colorConfirmer.getColor(series, series.getName());
        }
    }

    public void setChartModel(AbstractNormalChartModel chartModel) {
        this.chartModel = chartModel;
    }

    public List<String> getColors() {
        return this.colors;
    }

    public void setColors(List<String> colors) {
        this.colors = colors;
    }

    public abstract AbstractNormalChartModel createChartModel();

    public String getStyle(String name) {
        if (this.styles == null) {
            return null;
        }
        return this.styles.get(name);
    }

    public void addStyle(String name, String value) {
        if (this.styles == null) {
            this.styles = new HashMap<String, String>(8);
        }
        this.styles.put(name, value);
    }

    public void addStyle(QingStyle qingStyle, Chart chart) {
        if (this.styles == null) {
            this.styles = new HashMap<String, String>(8);
        }
        this.styles.put(qingStyle.key(), qingStyle.transfer(chart));
    }

    protected void configureDemo(FlashChartModel model) {
        AbstractFusionBean bean = model.getBean();
        if (bean != null) {
            Chart chart = bean.getChart();
            if (bean.getChart_bgColor().getValue() == null) {
                this.addStyle("background", "#FFF");
            } else {
                this.addStyle("background", ColorUtil.colorToHexStr((Color)bean.getChart_bgColor().getColorValue()));
            }
            this.addStyle("numberFormat", QingTransferUtil.XMLtoQingNumFormat(bean.getChartNumberFormat().getXmlValue()));
            this.addStyle(QingStyle.DATA_LABEL_OVERLAPPABLE, chart);
            if (!StringUtil.isEmptyString((String)chart.caption)) {
                chart.chartTopMargin = String.valueOf(Double.parseDouble(chart.chartTopMargin) + Double.parseDouble(chart.captionFontSize));
            }
            if (!StringUtil.isEmptyString((String)chart.subCaption) && !StringUtil.isEmptyString((String)chart.caption)) {
                chart.chartTopMargin = String.valueOf(Double.parseDouble(chart.chartTopMargin) + Double.parseDouble(chart.subCaptionFontSize));
            }
            this.configureDataFormat(model);
            this.addStyle("chartTitle", chart.caption);
            this.addStyle("chartDeputyTitle", chart.subCaption);
            this.addStyle("chartTitleFontSize", chart.captionFontSize);
            this.addStyle("chartDeputyTitleFontSize", chart.subCaptionFontSize);
            this.addStyle("chartTitleFontName", chart.captionFontName);
            this.addStyle(QingStyle.CHART_TITLE_COLOR, chart);
            this.addStyle("chartDeputyTitleFontName", chart.subCaptionFontName);
            this.addStyle(QingStyle.CHART_DEPUTY_TITLE_COLOR, chart);
            this.addStyle("chartTitleAlign", chart.captionAlign);
            this.addStyle("topMargin", chart.chartTopMargin);
            this.addStyle("leftMargin", chart.chartLeftMargin);
            this.addStyle("bottomMargin", chart.chartBottomMargin);
            this.addStyle("rightMargin", chart.chartRightMargin);
            this.addStyle(QingStyle.BORDER_ALPHA, chart);
        }
    }

    protected void configureTypeTitle(String typeTitle) {
        this.chartModel.setCategoryTitle(StringUtils.isEmpty((String)typeTitle) ? CtrlEXTMessages.getMLS("category", "\u5206\u7c7b") : typeTitle);
    }

    protected void configureDataName(String dataName) {
        List<AbstractNormalChartModel.Series> series = this.chartModel.getSeries();
        for (int i = 0; i < series.size(); ++i) {
            series.get(i).setName(StringUtils.isEmpty((String)dataName) ? CtrlEXTMessages.getMLS("numValue", "\u6570\u503c") : dataName);
        }
    }

    protected void configureTreeTitle(String categoryTitle, String groupTitle, Boolean bMul) {
        ArrayList<String> arrayList;
        categoryTitle = StringUtils.isEmpty((String)categoryTitle) ? CtrlEXTMessages.getMLS("category", "\u5206\u7c7b") : categoryTitle;
        String string = groupTitle = StringUtils.isEmpty((String)groupTitle) ? CtrlEXTMessages.getMLS("group", "\u5206\u7ec4") : groupTitle;
        if (bMul.booleanValue()) {
            arrayList = new ArrayList<String>(2);
            arrayList.add(categoryTitle);
            arrayList.add(groupTitle);
        } else {
            arrayList = new ArrayList(1);
            arrayList.add(categoryTitle);
        }
        this.treeChartModel.setLabelCaptions(arrayList);
    }

    protected void configureTreeDataName(String dataName) {
        this.treeChartModel.setSizeCaption(StringUtils.isEmpty((String)dataName) ? CtrlEXTMessages.getMLS("numValue", "\u6570\u503c") : dataName);
    }

    protected void configureDataFormat(FlashChartModel model) {
        if (this.chartModel == null) {
            return;
        }
        List<AbstractNormalChartModel.Series> series = this.chartModel.getSeries();
        for (int i = 0; i < series.size(); ++i) {
            this.configFormat(model, series.get(i));
        }
    }

    private void configFormat(FlashChartModel model, AbstractNormalChartModel.Series series) {
        List<AbstractNormalChartModel.INode> nodes = series.getNodes();
        for (int j = 0; j < nodes.size(); ++j) {
            if (!(nodes.get(j) instanceof AbstractNormalChartModel.Node)) {
                return;
            }
            AbstractNormalChartModel.Node node = (AbstractNormalChartModel.Node)nodes.get(j);
            this.formatNodeNumber(model, node);
        }
        series.setFormatString(QingTransferUtil.XMLtoQingNumFormat(model.getBean().getChartNumberFormat().getXmlValue()));
    }

    protected void formatNodeNumber(FlashChartModel model, AbstractNormalChartModel.Node node) {
        if (node == null || node.getValue() == null) {
            return;
        }
        AbstractFusionBean bean = model.getBean();
        String formatXml = bean.getChartNumberFormat().getXmlValue();
        Chart chart = bean.getChart();
        String value = NumberFormatTemplateEditor.applayPattern(node.getValue(), formatXml, chart.numberPrefix, chart.numberSuffix);
        node.setText(value);
    }

    public String toString() {
        return GsonUtil.format(this);
    }
}

