/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Line;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Trendlines;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.calculator.AbstractCalculator;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractTrendLineChart
extends AbstractQingChart {
    protected void configureTrendline(FlashChartModel model) {
        AbstractFusionBean bean = model.getBean();
        Chart chart = bean.getChart();
        Object[] data = ChartDataTransferUtil.converToData(this.chartModel.getSeries());
        List<List<AbstractNormalChartModel.PaintableLine>> lists = AbstractTrendLineChart.configureTrendlinePaintableLine(data, bean);
        this.chartModel.setPaintableLines(lists);
        this.addStyle(QingStyle.REFLINE_COLOR, chart);
        this.addStyle(QingStyle.REFLINE_COLOR_HOVER, chart);
        this.addStyle(QingStyle.REFLINE_TIPS_COLOR, chart);
    }

    public static List<List<AbstractNormalChartModel.PaintableLine>> configureTrendlinePaintableLine(Object[] data, AbstractFusionBean bean) {
        AbstractCalculator calculator = null;
        AbstractCalculator.Refline refline = new AbstractCalculator.Refline();
        ArrayList<AbstractNormalChartModel.PaintableLine> paintableLines = new ArrayList<AbstractNormalChartModel.PaintableLine>();
        Trendlines trendlines = bean.getTrendlines();
        if (trendlines == null || trendlines.lines == null || trendlines.lines.length == 0) {
            return null;
        }
        for (int i = 0; i < data.length; ++i) {
            double[][] seriesData = (double[][])data[i];
            for (int j = 0; j < seriesData.length; ++j) {
                for (int k = 0; k < seriesData[0].length; ++k) {
                    double value = seriesData[j][k];
                    if ("NaN".equalsIgnoreCase(String.valueOf(value))) continue;
                    if (calculator == null) {
                        Line leftLine = trendlines.lines[0];
                        Line rightLine = trendlines.lines[1];
                        refline.setValue(leftLine.startValue);
                        refline.setFormat(QingTransferUtil.XMLtoQingNumFormat(bean.getChartNumberFormat().getXmlValue()));
                        if (rightLine.displayvalue != null) {
                            refline.setLabel(rightLine.displayvalue.trim());
                        }
                        calculator = AbstractCalculator.create(refline);
                    }
                    calculator.joinCalc(BigDecimal.valueOf(value));
                }
            }
            if (calculator == null) continue;
            paintableLines.add(calculator.getLine());
        }
        return Collections.singletonList(paintableLines);
    }
}

