/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.area;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.area.AbstractAreaChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.json.JsonLocation;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.SingleSeriesChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.sort.ISortChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.sort.SortSingleChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.nio.charset.StandardCharsets;

public class AreaChart
extends AbstractAreaChart {
    private ISortChart sortChart;

    @Override
    public AbstractNormalChartModel createChartModel() {
        SingleSeriesChartModel chartModel = new SingleSeriesChartModel();
        this.setChartModel(chartModel);
        return chartModel;
    }

    @Override
    public AbstractNormalChartModel loadDemoData() {
        this.sortChart = new SortSingleChart();
        String areaJson = QingTransferUtil.getResourceAsString(JsonLocation.class, "area.json", StandardCharsets.UTF_8);
        JsonUtil.CustomJsonParser jsonParser = new JsonUtil.CustomJsonParser();
        jsonParser.addCustomDecoder(AbstractNormalChartModel.INode.class, new AbstractNormalChartModel.INode.JsonDecoder());
        return JsonUtil.decodeFromString(jsonParser, areaJson, SingleSeriesChartModel.class);
    }

    @Override
    public String initDemoScript(FlashChartModel model) {
        super.initDemoScript(model);
        Chart chart = model.getBean().getChart();
        this.addStyle(QingStyle.Y_AXIS_NUMBER_FORMAT, chart);
        this.sortChart.sortChart(model, this.chartModel);
        this.collectLegend();
        this.configureDataName(chart.seriesName);
        int w = model.getBean().getChartWidth() == 0 ? 691 : model.getBean().getChartWidth() + 10;
        int h = model.getBean().getChartHeight() == 0 ? 240 : model.getBean().getChartHeight() + 6;
        return String.format("funChartDoDraw('%s','%s', %d, %d)", QingChartType.QING_CT_AREA.getName(), this, w, h);
    }
}

