/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.area;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.area.AbstractAreaChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.json.JsonLocation;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.Legends;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.MultiSeriesChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class STAreaChart
extends AbstractAreaChart {
    private Legends.DiscreteColorLegend legend;

    @Override
    public String initDemoScript(FlashChartModel model) {
        super.initDemoScript(model);
        Chart chart = model.getBean().getChart();
        this.addStyle(QingStyle.SHOW_LEGEND, chart);
        this.addStyle(QingStyle.Y_AXIS_NUMBER_FORMAT, chart);
        int w = model.getBean().getChartWidth() == 0 ? 691 : model.getBean().getChartWidth() + 10;
        int h = model.getBean().getChartHeight() == 0 ? 240 : model.getBean().getChartHeight() + 6;
        return String.format("funChartDoDraw('%s','%s', %d, %d)", QingChartType.QING_CT_ST_AREA.getName(), this, w, h);
    }

    @Override
    public AbstractNormalChartModel loadDemoData() {
        String areaJson = QingTransferUtil.getResourceAsString(JsonLocation.class, "starea.json", StandardCharsets.UTF_8);
        JsonUtil.CustomJsonParser jsonParser = new JsonUtil.CustomJsonParser();
        jsonParser.addCustomDecoder(AbstractNormalChartModel.INode.class, new AbstractNormalChartModel.INode.JsonDecoder());
        return JsonUtil.decodeFromString(jsonParser, areaJson, MultiSeriesChartModel.class);
    }

    @Override
    public AbstractNormalChartModel createChartModel() {
        MultiSeriesChartModel chartModel = new MultiSeriesChartModel();
        this.setChartModel(chartModel);
        return chartModel;
    }

    @Override
    public void collectLegend() {
        super.collectLegend();
        this.setLegend(this.colorConfirmer.createLegend());
    }

    public Legends.DiscreteColorLegend getLegend() {
        return this.legend;
    }

    public void setLegend(Legends.DiscreteColorLegend legend) {
        this.legend = legend;
    }

    @Override
    protected void configureTrendline(FlashChartModel model) {
        AbstractFusionBean bean = model.getBean();
        Chart chart = bean.getChart();
        Object[] data = ChartDataTransferUtil.converToData(this.chartModel.getSeries());
        List<List<AbstractNormalChartModel.PaintableLine>> lists = ChartDataTransferUtil.configureTrendlinePaintableLine(data, bean);
        this.chartModel.setPaintableLines(lists);
        this.addStyle(QingStyle.REFLINE_COLOR, chart);
        this.addStyle(QingStyle.REFLINE_COLOR_HOVER, chart);
        this.addStyle(QingStyle.REFLINE_TIPS_COLOR, chart);
    }
}

