/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.combina;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractTrendLineChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.json.JsonLocation;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.DiscreteColorConfirmer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.Legends;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.MultiSeriesChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class AbstractCombinaChart
extends AbstractTrendLineChart {
    private Legends.DiscreteColorLegend legend;

    @Override
    public AbstractNormalChartModel loadDemoData() {
        String dialJson = QingTransferUtil.getResourceAsString(JsonLocation.class, "combina.json", StandardCharsets.UTF_8);
        JsonUtil.CustomJsonParser jsonParser = new JsonUtil.CustomJsonParser();
        jsonParser.addCustomDecoder(AbstractNormalChartModel.INode.class, new AbstractNormalChartModel.INode.JsonDecoder());
        return JsonUtil.decodeFromString(jsonParser, dialJson, MultiSeriesChartModel.class);
    }

    @Override
    public void configDemoCustomStyle(FlashChartModel model) {
        super.configDemoCustomStyle(model);
        super.configureTrendline(model);
        List<AbstractNormalChartModel.Series> series = this.chartModel.getSeries();
        for (int i = 0; i < series.size(); ++i) {
            series.get(i).setColor((String)this.colors.get(i % this.colors.size()));
        }
        AbstractFusionBean bean = model.getBean();
        Chart chart = bean.getChart();
        this.configureTypeTitle(chart.categoryTitle);
        if (!StringUtil.isEmptyString((String)chart.chart_yUnitText)) {
            this.addStyle(QingStyle.Y_UNITTEXT, chart);
        }
        if (!StringUtil.isEmptyString((String)chart.chart_xUnitText)) {
            this.addStyle(QingStyle.X_UNITTEXT, chart);
        }
        this.addStyle(QingStyle.Y_AXIS_NUMBER_FORMAT, chart);
        this.addStyle(QingStyle.X_AXIS_NUMBER_FORMAT, chart);
        this.addStyle(QingStyle.SHOW_LEGEND, chart);
        chart.showLabels = "4";
        this.addStyle(QingStyle.DATALABEL, chart);
        this.addStyle(QingStyle.DATALABEL_FORMAT, chart);
        this.addStyle(QingStyle.Y_RULERSCALE, chart);
        this.addStyle(QingStyle.SECOND_RULERSCALE, chart);
        this.addStyle(QingStyle.Y_RULERSTART, chart);
        this.addStyle(QingStyle.X_RULERSTART, chart);
        this.addStyle(QingStyle.SMOOTH_CURVE, chart);
        this.addStyle(QingStyle.DATA_ANCHORS, chart);
    }

    @Override
    public void collectLegend() {
        this.colorConfirmer = new DiscreteColorConfirmer(this.colors.toArray(new String[0]), Integer.MAX_VALUE);
        for (int i = 0; i < this.chartModel.getSeries().size(); ++i) {
            AbstractNormalChartModel.Series series = this.chartModel.getSeries().get(i);
            if (series.getName() == null) {
                series.setName("");
            }
            series.setOrderingValue(i);
            series.setColor((String)this.colors.get(i % this.colors.size()));
            this.colorConfirmer.getColor(series, series.getName() == null ? "" : series.getName());
        }
        this.setLegend(this.colorConfirmer.createLegend());
    }

    public Legends.DiscreteColorLegend getLegend() {
        return this.legend;
    }

    public void setLegend(Legends.DiscreteColorLegend legend) {
        this.legend = legend;
    }

    @Override
    public AbstractNormalChartModel createChartModel() {
        MultiSeriesChartModel chartModel = new MultiSeriesChartModel();
        this.setChartModel(chartModel);
        return chartModel;
    }
}

