/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.scatter;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Line;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Trendlines;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractTrendLineChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.Legends;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.MultiSeriesChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.calculator.AbstractCalculator;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SimilarScatterPlotChart
extends AbstractTrendLineChart {
    private Legends.DiscreteColorLegend legend;

    @Override
    public String initDemoScript(FlashChartModel model) {
        super.initDemoScript(model);
        this.configureTrendline(model);
        Chart chart = model.getBean().getChart();
        this.chartModel.setCategoryTitle(chart.seriesName == null ? CtrlEXTMessages.getMLS("KEY_VALIDATION_value", "\u6570\u503c") : chart.seriesName);
        this.processSeriesData();
        this.applyCategoryNumberFormat(chart);
        this.addStyle(QingStyle.Y_RULERSTART, chart);
        this.addStyle(QingStyle.Y_UNITTEXT, chart);
        this.addStyle(QingStyle.Y_AXIS_NUMBER_FORMAT, chart);
        this.addStyle(QingStyle.X_UNITTEXT, chart);
        this.addStyle(QingStyle.X_AXIS_NUMBER_FORMAT, chart);
        this.addStyle(QingStyle.X_RULERSTART, chart);
        this.addStyle(QingStyle.SHOW_LEGEND, chart);
        return null;
    }

    @Override
    public AbstractNormalChartModel createChartModel() {
        MultiSeriesChartModel chartModel = new MultiSeriesChartModel();
        this.setChartModel(chartModel);
        return chartModel;
    }

    @Override
    public AbstractNormalChartModel loadDemoData() {
        return null;
    }

    @Override
    public void collectLegend() {
        super.collectLegend();
        this.setLegend(this.colorConfirmer.createLegend());
    }

    protected void applyCategoryNumberFormat(Chart chart) {
        List<AbstractNormalChartModel.Category> categories = this.chartModel.getCategories();
        for (int i = 0; i < categories.size(); ++i) {
            int j;
            AbstractNormalChartModel.Category category = categories.get(i);
            CharSequence[] strs = category.getLabel().split(",");
            if (this.isSactter()) {
                for (j = 0; j < 3; ++j) {
                    strs[j] = NumberFormatTemplateEditor.applayPattern(((String)strs[j]).trim(), chart.dataLabelFormat);
                }
            } else {
                for (j = 0; j < 2; ++j) {
                    strs[j] = NumberFormatTemplateEditor.applayPattern(((String)strs[j]).trim(), chart.dataLabelFormat);
                }
            }
            category.setLabel(String.join((CharSequence)", ", strs));
        }
    }

    protected void processSeriesData() {
        List<AbstractNormalChartModel.Series> arrSerie = this.chartModel.getSeries();
        List<AbstractNormalChartModel.INode> nodes = arrSerie.get(1).getNodes();
        int size = nodes.size();
        ArrayList<AbstractNormalChartModel.INode> newNodes = new ArrayList<AbstractNormalChartModel.INode>(size * 2);
        for (int i = 0; i < size * 2; ++i) {
            newNodes.add(null);
            if (i < size) {
                newNodes.set(i, null);
                continue;
            }
            newNodes.set(i, nodes.get(i % size));
        }
        arrSerie.get(1).setNodes(newNodes);
    }

    protected boolean isSactter() {
        return false;
    }

    @Override
    protected void configureTrendline(FlashChartModel model) {
        AbstractFusionBean bean = model.getBean();
        Chart chart = bean.getChart();
        Object[] data = ChartDataTransferUtil.converToXYData(this.chartModel.getSeries());
        List<List<AbstractNormalChartModel.PaintableLine>> lists = SimilarScatterPlotChart.configureXYTrendlinePaintableLine(data, bean);
        this.chartModel.setPaintableLines(lists);
        ChartDataTransferUtil.applyChartTrendlineColor(chart, bean);
        this.addStyle(QingStyle.REFLINE_COLOR, chart);
        this.addStyle(QingStyle.REFLINE_COLOR_HOVER, chart);
        this.addStyle(QingStyle.REFLINE_TIPS_COLOR, chart);
    }

    public static List<List<AbstractNormalChartModel.PaintableLine>> configureXYTrendlinePaintableLine(Object[] data, AbstractFusionBean bean) {
        AbstractCalculator xCalculator = null;
        AbstractCalculator yCalculator = null;
        AbstractCalculator.Refline xRefline = new AbstractCalculator.Refline();
        AbstractCalculator.Refline yRefline = new AbstractCalculator.Refline();
        ArrayList<AbstractNormalChartModel.PaintableLine> xPaintableLines = new ArrayList<AbstractNormalChartModel.PaintableLine>();
        ArrayList<AbstractNormalChartModel.PaintableLine> yPaintableLines = new ArrayList<AbstractNormalChartModel.PaintableLine>();
        Chart chart = bean.getChart();
        if (chart == null) {
            return null;
        }
        Trendlines trendlines = bean.getTrendlines();
        for (int i = 0; i < data.length; ++i) {
            double[][] seriesData = (double[][])data[i];
            for (int j = 0; j < seriesData.length; ++j) {
                if (seriesData[0].length < 2) continue;
                double xValue = seriesData[j][0];
                double yValue = seriesData[j][1];
                if ("NaN".equalsIgnoreCase(String.valueOf(xValue)) || "NaN".equalsIgnoreCase(String.valueOf(yValue))) continue;
                if (xCalculator == null && trendlines != null && trendlines.lines != null && trendlines.lines.length != 0) {
                    Line leftLine = trendlines.lines[0];
                    Line rightLine = trendlines.lines[1];
                    xRefline.setValue(leftLine.startValue);
                    xRefline.setFormat(QingTransferUtil.XMLtoQingNumFormat(bean.getChartNumberFormat().getXmlValue()));
                    if (rightLine.displayvalue != null) {
                        xRefline.setLabel(rightLine.displayvalue.trim());
                    }
                    xCalculator = AbstractCalculator.create(xRefline);
                }
                if (yCalculator == null && !StringUtil.isEmptyString((String)chart.trendlineYValue)) {
                    yRefline.setValue(chart.trendlineYValue);
                    yRefline.setFormat(QingTransferUtil.XMLtoQingNumFormat(bean.getChartNumberFormat().getXmlValue()));
                    if (!StringUtil.isEmptyString((String)chart.trendlineYDisplayValue)) {
                        yRefline.setLabel(chart.trendlineYDisplayValue.trim());
                    }
                    yCalculator = AbstractCalculator.create(yRefline);
                }
                if (xCalculator != null) {
                    xCalculator.joinCalc(BigDecimal.valueOf(xValue));
                }
                if (yCalculator == null) continue;
                yCalculator.joinCalc(BigDecimal.valueOf(yValue));
            }
        }
        if (xCalculator != null) {
            xPaintableLines.add(xCalculator.getLine());
        }
        if (yCalculator != null) {
            yPaintableLines.add(yCalculator.getLine());
        }
        ArrayList<List<AbstractNormalChartModel.PaintableLine>> list = new ArrayList<List<AbstractNormalChartModel.PaintableLine>>();
        list.add(xPaintableLines);
        list.add(yPaintableLines);
        return list;
    }

    public Legends.DiscreteColorLegend getLegend() {
        return this.legend;
    }

    public void setLegend(Legends.DiscreteColorLegend legend) {
        this.legend = legend;
    }
}

