/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.tree;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.json.JsonLocation;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.tree.AbstractTreeChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.DiscreteColorConfirmer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.TreeChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class RectTreeChart
extends AbstractTreeChart {
    @Override
    public TreeChartModel loadDemoData() {
        String treeJson = QingTransferUtil.getResourceAsString(JsonLocation.class, "recttree.json", StandardCharsets.UTF_8);
        JsonUtil.CustomJsonParser jsonParser = new JsonUtil.CustomJsonParser();
        jsonParser.addCustomDecoder(AbstractNormalChartModel.INode.class, new AbstractNormalChartModel.INode.JsonDecoder());
        return JsonUtil.decodeFromString(jsonParser, treeJson, TreeChartModel.class);
    }

    @Override
    protected void configDemoCustomStyle(FlashChartModel model) {
        super.configDemoCustomStyle(model);
        Chart chart = model.getBean().getChart();
        this.configureTreeTitle(chart.categoryTitle, chart.groupTitle, false);
    }

    @Override
    public void collectLegend() {
        this.colorConfirmer = new DiscreteColorConfirmer(this.colors.toArray(new String[0]), Integer.MAX_VALUE);
        List<AbstractNormalChartModel.TreeChartNode> treeChartNodeList = this.treeChartModel.getRoot().getChildren();
        for (int i = 0; i < treeChartNodeList.size(); ++i) {
            AbstractNormalChartModel.TreeChartNode treeChartNode = treeChartNodeList.get(i);
            if ("0".equals(treeChartNode.getSize())) continue;
            treeChartNode.setOrderingValue(i);
            this.colorConfirmer.getRectTreeColor(treeChartNode, treeChartNode.getLabel());
        }
        this.setLegend(this.colorConfirmer.createLegend());
    }

    @Override
    public void sortedDemo(TreeChartModel treeChartModel, FlashChartModel model) {
        List<AbstractNormalChartModel.TreeChartNode> children = treeChartModel.getRoot().getChildren();
        treeChartModel.setMeasureFormat(QingTransferUtil.XMLtoQingNumFormat(model.getBean().getChartNumberFormat().getXmlValue()));
        children.sort((o1, o2) -> Double.compare(Math.abs(new Double(o2.getSize())), Math.abs(new Double(o1.getSize()))));
        for (int i = 0; i < children.size(); ++i) {
            children.get(i).setColor((String)this.colors.get(i % this.colors.size()));
        }
    }
}

