/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.calculator;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.calculator.AbstractCalculator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MedianCalculator
extends AbstractCalculator {
    private List<BigDecimal> _collector = new ArrayList<BigDecimal>(8);

    public MedianCalculator(AbstractCalculator.Refline refline) {
        super(refline);
    }

    @Override
    public void joinCalc(BigDecimal value) {
        this._collector.add(value);
    }

    @Override
    public BigDecimal doCalc() {
        Object mid;
        int size = this._collector.size();
        if (size == 0) {
            return null;
        }
        Object[] ary = this._collector.toArray(new BigDecimal[0]);
        Arrays.sort(ary);
        int half = size >> 1;
        if (size % 2 == 0) {
            Object mid1 = ary[half - 1];
            Object mid2 = ary[half];
            int scale = Math.max(((BigDecimal)mid1).scale(), ((BigDecimal)mid2).scale());
            scale = Math.min(15, Math.max(8, scale));
            mid = ((BigDecimal)mid1).add((BigDecimal)mid2).divide(new BigDecimal(2), scale, 4);
        } else {
            mid = ary[half];
        }
        return mid;
    }

    @Override
    public AbstractNormalChartModel.PaintableLine getLine() {
        BigDecimal value = this.doCalc();
        if (value == null) {
            return null;
        }
        AbstractNormalChartModel.PaintableLine paintableLine = new AbstractNormalChartModel.PaintableLine();
        paintableLine.setLineValue(value.toString());
        if (StringUtil.isEmptyString((String)this.refline.getLabel())) {
            paintableLine.setLabel(null);
        } else {
            paintableLine.setLabel(this.refline.getLabel());
        }
        paintableLine.setTipsTitle(CtrlEXTMessages.getMLS("median", "\u4e2d\u4f4d\u6570"));
        paintableLine.setTipsText(this.format(value));
        return paintableLine;
    }
}

