/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.pie;

import com.kingdee.cosmic.ctrl.common.LanguageManager;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ShowNegativeComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.SortEnum;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.pie.SimilarPieChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.Legends;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.SingleSeriesQingChartTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimilarPieTransferImpl
extends SingleSeriesQingChartTransfer {
    @Override
    protected boolean fillColorToCategory() {
        return true;
    }

    @Override
    public void personalizedStyle() {
        this.qingChart.addStyle(QingStyle.SHOW_LEGEND, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_DATALABEL, this.chart);
        this.qingChart.addStyle(QingStyle.DATALABEL_FORMAT, this.chart);
        this.qingChart.addStyle(QingStyle.DATALABEL_TYPE, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_NEGATIVE, this.chart);
    }

    public static boolean isModulus(String modulus) {
        return ShowNegativeComboBoxEditor.getAbs().equals(modulus);
    }

    @Override
    public AbstractQingChart process(FlashChartModel model) {
        AbstractQingChart qingChart = super.process(model);
        qingChart.collectLegend();
        return qingChart;
    }

    @Override
    public void after() {
        super.after();
        this.removeNegative();
    }

    @Override
    protected int calcTopN() {
        return ChartDataTransferUtil.calcTopN(this.chart.chartTopN);
    }

    private void removeNegative() {
        if (ShowNegativeComboBoxEditor.getIgnore().equals(this.chart.chartShowNegative)) {
            List<AbstractNormalChartModel.Series> series = this.chartModel.getSeries();
            List<AbstractNormalChartModel.Category> categories = this.chartModel.getCategories();
            Legends.DiscreteColorLegend legend = ((SimilarPieChart)this.qingChart).getLegend();
            List<AbstractNormalChartModel.INode> nodes = series.get(0).getNodes();
            Iterator<AbstractNormalChartModel.INode> iterator = nodes.iterator();
            int i = 0;
            int cursor = 0;
            while (iterator.hasNext()) {
                AbstractNormalChartModel.INode node = iterator.next();
                if (Double.parseDouble(((AbstractNormalChartModel.Node)node).getValue()) < 0.0) {
                    iterator.remove();
                    categories.remove(i - cursor);
                    legend.getColors().remove(i - cursor);
                    legend.getTexts().remove(i - cursor);
                    ++cursor;
                }
                ++i;
            }
        }
    }

    @Override
    protected void collectSeries() {
        int topN = this.calcTopN();
        double[][] arrSeriesValue = (double[][])this.dataNode.getData();
        SortEnum sortType = ChartDataTransferUtil.loadSortType(this.dataNode);
        Object[] groupKeys = this.dataNode.getGroupKeys();
        ChartDataTransferUtil.sortProcess(groupKeys, arrSeriesValue[0], sortType, true, SimilarPieTransferImpl.isModulus(this.chart.chartShowNegative));
        int nodeNum = arrSeriesValue[0].length;
        ArrayList<AbstractNormalChartModel.INode> arrNode = new ArrayList<AbstractNormalChartModel.INode>(8);
        AbstractNormalChartModel.Node otherNode = null;
        for (int i = 0; i < nodeNum; ++i) {
            String value = String.valueOf(arrSeriesValue[0][i]);
            if (topN <= i) {
                if (otherNode == null) {
                    otherNode = new AbstractNormalChartModel.Node();
                    otherNode.setValue("0");
                    otherNode.setText("0");
                    arrNode.add(otherNode);
                }
                if (value.equalsIgnoreCase("NaN")) continue;
                String base = otherNode.getValue();
                if (StringUtil.isEmptyString((String)base)) {
                    base = "0";
                }
                if (!(arrSeriesValue[0][i] >= 0.0) && !ShowNegativeComboBoxEditor.getAbs().equals(this.chart.chartShowNegative)) continue;
                otherNode.setValue(String.valueOf(new BigDecimal(base).add(BigDecimal.valueOf(Math.abs(arrSeriesValue[0][i])))));
                otherNode.setText(String.valueOf(new BigDecimal(base).add(BigDecimal.valueOf(Math.abs(arrSeriesValue[0][i])))));
                continue;
            }
            AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
            if (value.equalsIgnoreCase("NaN")) {
                value = "0";
            }
            node.setValue(value);
            node.setText(value);
            this.formatNodeNumber(node);
            arrNode.add(node);
        }
        this.formatNodeNumber(otherNode);
        AbstractNormalChartModel.Series series = new AbstractNormalChartModel.Series();
        series.setName(this.chart.seriesName);
        series.setNodes(arrNode);
        series.setColor((String)this.colors.get(0));
        series.setFormatString(QingTransferUtil.toQingNumFormat(this.chart));
        ArrayList<AbstractNormalChartModel.Series> seriesList = new ArrayList<AbstractNormalChartModel.Series>(1);
        seriesList.add(series);
        List<AbstractNormalChartModel.Category> categories = this.chartModel.getCategories();
        if (SortEnum.NORMAL != sortType) {
            for (int i = 0; i < categories.size(); ++i) {
                AbstractNormalChartModel.Category category = categories.get(i);
                if (topN > i) {
                    category.setLabel((String)groupKeys[i]);
                    continue;
                }
                String otherLabel = LanguageManager.getLangMessage((String)"others", QingChart.class, (String)"\u5176\u5b83");
                category.setLabel(otherLabel);
            }
        }
        this.chartModel.setSeries(seriesList);
    }
}

