/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.tree;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ShowNegativeComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.SortEnum;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.tree.AbstractTreeChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.tree.RectTreeChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.TreeChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.SingleSeriesQingChartTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import java.util.ArrayList;
import java.util.List;

public class RectTreeTransferImpl
extends SingleSeriesQingChartTransfer {
    @Override
    public void prepare(FlashChartModel model) {
        super.prepare(model);
        this.qingChart = new RectTreeChart();
        this.qingChart.setColors(this.colors);
        this.chartModel = this.qingChart.createChartModel();
        this.treeChartModel = ((AbstractTreeChart)this.qingChart).createTreeChartModel();
    }

    @Override
    public void personalizedStyle() {
        super.personalizedStyle();
        this.qingChart.addStyle(QingStyle.SHOW_DATALABEL, this.chart);
        this.qingChart.addStyle(QingStyle.NUMERAL_FORMAT, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_NEGATIVE, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_LEGEND, this.chart);
    }

    @Override
    public void after() {
        super.after();
        ArrayList<String> list = new ArrayList<String>(8);
        list.add(this.chart.categoryTitle);
        this.treeChartModel.setLabelCaptions(list);
        this.treeChartModel.setSizeCaption(this.chart.seriesName);
        String formatXml = this.bean.getChartNumberFormat().getXmlValue();
        this.treeChartModel.setMeasureFormat(QingTransferUtil.XMLtoQingNumFormat(formatXml));
        this.sortRectTree();
        ChartDataTransferUtil.removeNegative(this.chartModel, this.chart);
        this.collectRoot(this.chartModel, this.treeChartModel);
        this.qingChart.collectLegend();
    }

    public void collectRoot(AbstractNormalChartModel chartModel, TreeChartModel treeChartModel) {
        List<AbstractNormalChartModel.Series> series = chartModel.getSeries();
        List<AbstractNormalChartModel.Category> categories = chartModel.getCategories();
        List<AbstractNormalChartModel.INode> arrNode = series.get(0).getNodes();
        AbstractNormalChartModel.TreeChartNode treeRoot = new AbstractNormalChartModel.TreeChartNode();
        ArrayList<AbstractNormalChartModel.TreeChartNode> treeChildrenList = new ArrayList<AbstractNormalChartModel.TreeChartNode>(arrNode.size());
        for (int i = 0; i < arrNode.size(); ++i) {
            AbstractNormalChartModel.TreeChartNode treeNode = new AbstractNormalChartModel.TreeChartNode();
            AbstractNormalChartModel.Category category = categories.get(i);
            AbstractNormalChartModel.Node node = (AbstractNormalChartModel.Node)arrNode.get(i);
            treeNode.setLabel(category.getLabel());
            treeNode.setSize(node.getValue());
            treeNode.setColor(category.getColor());
            treeChildrenList.add(treeNode);
        }
        treeRoot.setChildren(treeChildrenList);
        treeChartModel.setRoot(treeRoot);
    }

    @Override
    protected boolean fillColorToCategory() {
        return true;
    }

    public boolean isModulus(String modulus) {
        return ShowNegativeComboBoxEditor.getAbs().equals(modulus);
    }

    public void sortRectTree() {
        List<AbstractNormalChartModel.Category> categoryList = this.chartModel.getCategories();
        double[][] oData = (double[][])ChartDataTransferUtil.converToData(this.chartModel.getSeries())[0];
        Object[] group = categoryList.toArray();
        int len = oData[0].length;
        double[] dataSorted = oData[0];
        ChartDataTransferUtil.sortProcess(group, dataSorted, SortEnum.DESC, false, this.isModulus(this.chart.chartShowNegative));
        ArrayList<AbstractNormalChartModel.INode> nodeList = new ArrayList<AbstractNormalChartModel.INode>(len);
        ArrayList<AbstractNormalChartModel.Category> newCategoryList = new ArrayList<AbstractNormalChartModel.Category>(len);
        for (int i = 0; i < len; ++i) {
            String value = String.valueOf(dataSorted[i]);
            AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
            node.setValue(value);
            node.setText(value);
            this.formatNodeNumber(node);
            nodeList.add(node);
            newCategoryList.add((AbstractNormalChartModel.Category)group[i]);
        }
        this.chartModel.setCategories(newCategoryList);
        this.chartModel.getSeries().get(0).setNodes(nodeList);
    }
}

