/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.undo;

import com.kingdee.cosmic.ctrl.kds.model.struct.undo.AbstractUndoableEdit;
import com.kingdee.cosmic.ctrl.kds.model.struct.undo.IUndoableEdit;
import com.kingdee.cosmic.ctrl.kds.model.struct.undo.UndoException;
import java.util.ArrayList;

public class CompoundUndoableEdit
extends AbstractUndoableEdit {
    boolean inProgress = true;
    protected ArrayList edits = new ArrayList();

    public int size() {
        return this.edits.size();
    }

    public IUndoableEdit getEditAt(int index) {
        return (IUndoableEdit)this.edits.get(index);
    }

    @Override
    public void undo() throws UndoException {
        super.undo();
        int i = this.edits.size();
        while (i-- > 0) {
            ((IUndoableEdit)this.edits.get(i)).undo();
        }
    }

    @Override
    public void redo() throws UndoException {
        super.redo();
        int size = this.edits.size();
        for (int i = 0; i < size; ++i) {
            ((IUndoableEdit)this.edits.get(i)).redo();
        }
    }

    protected IUndoableEdit lastEdit() {
        int size = this.edits.size();
        if (size > 0) {
            return (IUndoableEdit)this.edits.get(size - 1);
        }
        return null;
    }

    @Override
    public void die() {
        for (int i = this.edits.size() - 1; i >= 0; --i) {
            ((IUndoableEdit)this.edits.get(i)).die();
        }
        super.die();
    }

    @Override
    public boolean addEdit(IUndoableEdit anEdit) {
        if (!this.inProgress) {
            return false;
        }
        IUndoableEdit last = this.lastEdit();
        if (last == null) {
            this.edits.add(anEdit);
        } else if (!last.addEdit(anEdit)) {
            if (anEdit.replaceEdit(last)) {
                this.edits.remove(this.edits.size() - 1);
            }
            this.edits.add(anEdit);
        }
        return true;
    }

    public void end() {
        this.inProgress = false;
    }

    @Override
    public boolean canUndo() {
        return !this.isInProgress() && super.canUndo();
    }

    @Override
    public boolean canRedo() {
        return !this.isInProgress() && super.canRedo();
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    @Override
    public boolean isSignificant() {
        int size = this.edits.size();
        for (int i = 0; i < size; ++i) {
            if (!((IUndoableEdit)this.edits.get(i)).isSignificant()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getPresentationName() {
        IUndoableEdit last = this.lastEdit();
        if (last != null) {
            return last.getPresentationName();
        }
        return super.getPresentationName();
    }

    @Override
    public String getUndoPresentationName() {
        IUndoableEdit last = this.lastEdit();
        if (last != null) {
            return last.getUndoPresentationName();
        }
        return super.getUndoPresentationName();
    }

    @Override
    public String getRedoPresentationName() {
        IUndoableEdit last = this.lastEdit();
        if (last != null) {
            return last.getRedoPresentationName();
        }
        return super.getRedoPresentationName();
    }

    public String toString() {
        return super.toString() + " inProgress: " + this.inProgress + " edits: " + this.edits;
    }
}

