/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.undo;

import com.kingdee.cosmic.ctrl.kds.model.struct.undo.CompoundUndoableEdit;
import com.kingdee.cosmic.ctrl.kds.model.struct.undo.IUndoableEdit;
import com.kingdee.cosmic.ctrl.kds.model.struct.undo.IUndoableEditListener;
import com.kingdee.cosmic.ctrl.kds.model.struct.undo.UndoException;
import com.kingdee.cosmic.ctrl.kds.model.struct.undo.UndoableEditEvent;

public class UndoManager
extends CompoundUndoableEdit
implements IUndoableEditListener {
    int indexOfNextAdd = 0;
    int limit = 16;
    private boolean _enable = true;
    private CompoundUndoableEdit _group;
    private int _groupCount;

    public UndoManager() {
        this.edits.ensureCapacity(this.limit);
    }

    public void enable(boolean enable) {
        this._enable = enable;
    }

    public boolean isEnable() {
        return this._enable;
    }

    public void startGroup() {
        if (this._groupCount <= 0) {
            this._group = new CompoundUndoableEdit();
            this._groupCount = 0;
        }
        ++this._groupCount;
    }

    public void endGroup() {
        --this._groupCount;
        if (this._groupCount <= 0) {
            --this._groupCount;
            if (this._groupCount <= 0) {
                if (this._group != null && this._group.isInProgress() && !this._group.edits.isEmpty()) {
                    CompoundUndoableEdit group = this._group;
                    group.end();
                    this._group = null;
                    this.addEdit(group);
                }
                this._group = null;
            }
        }
    }

    public void cancelGroup() {
        --this._groupCount;
        if (this._groupCount <= 0) {
            if (this._group != null && this._group.isInProgress()) {
                CompoundUndoableEdit group = this._group;
                this._group = null;
                group.end();
                group.undo();
            }
            this._group = null;
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public void discardAllEdits() {
        int size = this.edits.size();
        for (int i = 0; i < size; ++i) {
            ((IUndoableEdit)this.edits.get(i)).die();
        }
        this.edits.clear();
        this.indexOfNextAdd = 0;
    }

    protected void trimForLimit() {
        int size;
        if (this.limit > 0 && (size = this.edits.size()) > this.limit) {
            int halfLimit = this.limit / 2;
            int keepTo = this.indexOfNextAdd - 1 + halfLimit;
            int keepFrom = this.indexOfNextAdd - 1 - halfLimit;
            if (keepTo - keepFrom + 1 > this.limit) {
                ++keepFrom;
            }
            if (keepFrom < 0) {
                keepTo -= keepFrom;
                keepFrom = 0;
            }
            if (keepTo >= size) {
                int delta = size - keepTo - 1;
                keepTo += delta;
                keepFrom += delta;
            }
            this.trimEdits(keepTo + 1, size - 1);
            this.trimEdits(0, keepFrom - 1);
        }
    }

    public void trimEdits(int from, int to) {
        if (from <= to) {
            for (int i = to; from <= i; --i) {
                ((IUndoableEdit)this.edits.get(i)).die();
                this.edits.remove(i);
            }
            if (this.indexOfNextAdd > to) {
                this.indexOfNextAdd -= to - from + 1;
            } else if (this.indexOfNextAdd >= from) {
                this.indexOfNextAdd = from;
            }
        }
    }

    public void setLimit(int l) {
        if (!this.inProgress) {
            throw new RuntimeException("Attempt to call UndoManager.setLimit() after UndoManager.end() has been called");
        }
        this.limit = l;
        this.trimForLimit();
    }

    protected IUndoableEdit editToBeUndone() {
        int i = this.indexOfNextAdd;
        while (i > 0) {
            IUndoableEdit edit;
            if (!(edit = (IUndoableEdit)this.edits.get(--i)).isSignificant()) continue;
            return edit;
        }
        return null;
    }

    protected IUndoableEdit editToBeRedone() {
        int count = this.edits.size();
        int i = this.indexOfNextAdd;
        while (i < count) {
            IUndoableEdit edit;
            if (!(edit = (IUndoableEdit)this.edits.get(i++)).isSignificant()) continue;
            return edit;
        }
        return null;
    }

    protected void undoTo(IUndoableEdit edit) throws UndoException {
        boolean done = false;
        while (!done) {
            IUndoableEdit next = (IUndoableEdit)this.edits.get(--this.indexOfNextAdd);
            next.undo();
            done = next == edit;
        }
    }

    protected void redoTo(IUndoableEdit edit) throws UndoException {
        boolean done = false;
        while (!done) {
            IUndoableEdit next = (IUndoableEdit)this.edits.get(this.indexOfNextAdd++);
            next.redo();
            done = next == edit;
        }
    }

    public void undoOrRedo() throws UndoException {
        if (this.indexOfNextAdd == this.edits.size()) {
            this.undo();
        } else {
            this.redo();
        }
    }

    public boolean canUndoOrRedo() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.canUndo();
        }
        return this.canRedo();
    }

    public int getIndexOfNextAdd() {
        return this.indexOfNextAdd;
    }

    public void undoSteps(int step) throws UndoException {
        for (int i = 0; i < step && this.canUndo(); ++i) {
            this.undo();
        }
    }

    public void redoSteps(int step) throws UndoException {
        for (int i = 0; i < step && this.canRedo(); ++i) {
            this.redo();
        }
    }

    @Override
    public void undo() throws UndoException {
        if (this.inProgress) {
            IUndoableEdit edit = this.editToBeUndone();
            if (edit == null) {
                throw new UndoException("Undo");
            }
            this.undoTo(edit);
        } else {
            super.undo();
        }
    }

    @Override
    public boolean canUndo() {
        if (this.inProgress) {
            IUndoableEdit edit = this.editToBeUndone();
            return edit != null && edit.canUndo();
        }
        return super.canUndo();
    }

    @Override
    public void redo() throws UndoException {
        if (this.inProgress) {
            IUndoableEdit edit = this.editToBeRedone();
            if (edit == null) {
                throw new UndoException("Redo");
            }
            this.redoTo(edit);
        } else {
            super.redo();
        }
    }

    @Override
    public boolean canRedo() {
        if (this.inProgress) {
            IUndoableEdit edit = this.editToBeRedone();
            return edit != null && edit.canRedo();
        }
        return super.canRedo();
    }

    @Override
    public boolean addEdit(IUndoableEdit anEdit) {
        if (!this._enable) {
            return false;
        }
        if (this._group != null) {
            return this._group.addEdit(anEdit);
        }
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
        boolean retVal = super.addEdit(anEdit);
        if (this.inProgress) {
            retVal = true;
        }
        this.indexOfNextAdd = this.edits.size();
        this.trimForLimit();
        return retVal;
    }

    @Override
    public void end() {
        super.end();
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
    }

    public String getUndoOrRedoPresentationName() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.getUndoPresentationName();
        }
        return this.getRedoPresentationName();
    }

    @Override
    public String getUndoPresentationName() {
        if (this.inProgress) {
            if (this.canUndo()) {
                return this.editToBeUndone().getUndoPresentationName();
            }
            return "Undo";
        }
        return super.getUndoPresentationName();
    }

    @Override
    public String getRedoPresentationName() {
        if (this.inProgress) {
            if (this.canRedo()) {
                return this.editToBeRedone().getRedoPresentationName();
            }
            return "Redo";
        }
        return super.getRedoPresentationName();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.addEdit(e.getEdit());
    }

    @Override
    public String toString() {
        return super.toString() + " limit: " + this.limit + " indexOfNextAdd: " + this.indexOfNextAdd;
    }
}

