/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.util;

import com.kingdee.cosmic.ctrl.common.KDToolkit;
import com.kingdee.cosmic.ctrl.kds.model.util.IntMarkEntry;
import java.util.Arrays;

public abstract class AbstractIntMarkArray {
    private static final int MIN_SIZE = 10;
    protected IntMarkEntry[] _array = null;
    protected int _count = 0;

    protected AbstractIntMarkArray() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        if (!this.isNull()) {
            for (int i = 0; i < this._count; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(this._array[i]);
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public int size() {
        return this._count;
    }

    public boolean isNull() {
        return this._count == 0 || this._array == null;
    }

    public void clear() {
        if (this._array != null) {
            Arrays.fill(this._array, 0, this._count, null);
        }
        this._count = 0;
    }

    public int getMaxIntMark() {
        return this.isNull() ? -1 : this._array[this._count - 1].getIntMark();
    }

    public int insert(IntMarkEntry[] aIns) {
        if (aIns == null) {
            return 0;
        }
        int replaced = 0;
        for (int i = 0; i < aIns.length; ++i) {
            if (this.insert(aIns[i]) == null) continue;
            ++replaced;
        }
        return replaced;
    }

    public IntMarkEntry insert(IntMarkEntry e) {
        int intMark = e.getIntMark();
        if (intMark > this.getIndexLimit()) {
            return null;
        }
        IntMarkEntry oldEntry = e;
        if (this.isNull()) {
            if (this._array == null) {
                this._array = new IntMarkEntry[10];
            }
            this._array[0] = e;
            this._count = 1;
        } else if (this._array[this._count - 1].getIntMark() < intMark) {
            this.append(e);
        } else {
            int pos = this.search(intMark);
            if (pos >= 0) {
                oldEntry = this._array[pos];
            } else {
                pos = -(pos + 1);
                if (this._count + 1 > this._array.length) {
                    Object[] newArray = new IntMarkEntry[this.getIncreasedCellsSize()];
                    KDToolkit.arraycopy((Object[])this._array, (int)0, (Object[])newArray, (int)0, (int)pos);
                    KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])newArray, (int)(pos + 1), (int)(this._count - pos));
                    this._array = newArray;
                } else {
                    KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])this._array, (int)(pos + 1), (int)(this._count - pos));
                }
                ++this._count;
            }
            this._array[pos] = e;
        }
        return oldEntry;
    }

    public void insert(IntMarkEntry e, int pos) {
        int intMark = e.getIntMark();
        if (intMark > this.getIndexLimit()) {
            return;
        }
        if (this.isNull()) {
            if (this._array == null) {
                this._array = new IntMarkEntry[10];
            }
            this._array[0] = e;
            this._count = 1;
        } else {
            pos = -(pos + 1);
            if (this._count + 1 > this._array.length) {
                Object[] newArray = new IntMarkEntry[this.getIncreasedCellsSize()];
                KDToolkit.arraycopy((Object[])this._array, (int)0, (Object[])newArray, (int)0, (int)pos);
                if (this._count > pos) {
                    KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])newArray, (int)(pos + 1), (int)(this._count - pos));
                }
                this._array = newArray;
            } else if (this._count > pos) {
                KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])this._array, (int)(pos + 1), (int)(this._count - pos));
            }
            this._array[pos] = e;
            ++this._count;
        }
    }

    protected void append(IntMarkEntry e) {
        if (this._count + 1 > this._array.length) {
            Object[] newArray = new IntMarkEntry[this.getIncreasedCellsSize()];
            KDToolkit.arraycopy((Object[])this._array, (int)0, (Object[])newArray, (int)0, (int)this._count);
            this._array = newArray;
        }
        this._array[this._count] = e;
        ++this._count;
    }

    protected int getIncreasedCellsSize() {
        return Math.min(this.getIndexLimit() + 1, this._array.length * 3 / 2 + 1);
    }

    public int search(int intMark) {
        if (this.isNull()) {
            return -1;
        }
        int min = this._array[0].getIntMark();
        int max = this._array[this._count - 1].getIntMark();
        if (intMark < min) {
            return -1;
        }
        if (intMark > max) {
            return -(this._count + 1);
        }
        if (intMark == min) {
            return 0;
        }
        if (intMark == max) {
            return this._count - 1;
        }
        if (intMark >= 0 && intMark < this._count && intMark == this._array[intMark].getIntMark()) {
            return intMark;
        }
        int low = 0;
        int high = this._count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int midVal = this._array[mid].getIntMark();
            if (midVal < intMark) {
                low = mid + 1;
                continue;
            }
            if (midVal > intMark) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public IntMarkEntry[] insert(int from, int to, boolean updateIntMark, boolean bState) {
        IntMarkEntry ie;
        int pos;
        int limit = this.getIndexLimit();
        if ((from = Math.min(from, limit)) > (to = Math.min(to, limit))) {
            return null;
        }
        int n = to - from + 1;
        for (pos = this.getProperPos(from, false); pos < this._count && (ie = this._array[pos]).getIntMark() + n <= limit; ++pos) {
            if (!updateIntMark) continue;
            ie.setIntMark(ie.getIntMark() + n);
        }
        Object[] aOut = null;
        if (pos < this._count) {
            int outSize = this._count - pos;
            if (bState) {
                aOut = new IntMarkEntry[outSize];
                KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])aOut, (int)0, (int)outSize);
            }
            Arrays.fill(this._array, pos, this._count, null);
            this._count -= outSize;
        }
        return aOut;
    }

    public IntMarkEntry remove(int intMark) {
        return this.removeByPos(this.search(intMark));
    }

    public IntMarkEntry removeByPos(int pos) {
        if (pos < 0 || pos >= this._count) {
            return null;
        }
        IntMarkEntry oldEntry = this._array[pos];
        int remain = this._count - (pos + 1);
        KDToolkit.arraycopy((Object[])this._array, (int)(pos + 1), (Object[])this._array, (int)pos, (int)remain);
        this._array[--this._count] = null;
        return oldEntry;
    }

    public IntMarkEntry[] remove(int from, int to, boolean updateIntMark, boolean bState) {
        int limit = this.getIndexLimit();
        if ((from = Math.min(from, limit)) > (to = Math.min(to, limit))) {
            return null;
        }
        int pos = this.getProperPos(from, false);
        int pos2 = this.getProperPos(to, true);
        Object[] aOut = null;
        if (pos <= pos2) {
            int outSize = pos2 - pos + 1;
            if (bState) {
                aOut = new IntMarkEntry[outSize];
                KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])aOut, (int)0, (int)aOut.length);
            }
            int remain = this._count - (pos2 + 1);
            KDToolkit.arraycopy((Object[])this._array, (int)(pos2 + 1), (Object[])this._array, (int)pos, (int)remain);
            Arrays.fill(this._array, this._count - outSize, this._count, null);
            this._count -= outSize;
        }
        if (updateIntMark) {
            int offset = to - from + 1;
            while (pos < this._count) {
                IntMarkEntry ie = this._array[pos];
                ie.setIntMark(ie.getIntMark() - offset);
                ++pos;
            }
        }
        return aOut;
    }

    public void trimToSize() {
        if (!this.isNull() && this._array.length != this._count) {
            Object[] newArray = new IntMarkEntry[this._count];
            KDToolkit.arraycopy((Object[])this._array, (int)0, (Object[])newArray, (int)0, (int)this._count);
            this._array = newArray;
        }
    }

    public int getProperPos(int index, boolean bLater) {
        int pos = this.search(index);
        if (pos < 0) {
            pos = -(pos + 1);
            if (bLater) {
                --pos;
            }
        }
        return pos;
    }

    public IntMarkEntry[] subset(int from, int to) {
        int pos2;
        Object[] array = null;
        int pos = this.getProperPos(from, false);
        if (pos <= (pos2 = this.getProperPos(to, true))) {
            array = new IntMarkEntry[pos2 - pos + 1];
            KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])array, (int)0, (int)array.length);
        }
        return array;
    }

    protected abstract int getIndexLimit();
}

