/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.util.profile;

import com.kingdee.cosmic.ctrl.kds.model.util.profile.IObjectProfileNode;
import com.kingdee.cosmic.ctrl.kds.model.util.profile.ObjectProfiler;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public abstract class ObjectProfileVisitors {
    public static IObjectProfileNode.INodeVisitor newDefaultNodePrinter(PrintWriter out, String indent, DecimalFormat format, boolean shortClassNames) {
        return new DefaultNodePrinter(out, indent, format, shortClassNames);
    }

    public static IObjectProfileNode.INodeVisitor newXMLNodePrinter(OutputStream out, String indent, DecimalFormat format, boolean shortClassNames) {
        return new XMLNodePrinter(out, indent, format, shortClassNames);
    }

    private ObjectProfileVisitors() {
    }

    private static final class XMLNodePrinter
    extends AbstractProfileNodeVisitor {
        private final PrintWriter m_out;
        private final String m_indent;
        private final DecimalFormat m_format;
        private final boolean m_shortClassNames;
        private static final String ENCODING = "UTF-8";

        @Override
        public void previsit(IObjectProfileNode node) {
            boolean isRoot;
            IObjectProfileNode root = node.root();
            boolean bl = isRoot = root == node;
            if (isRoot) {
                this.m_out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.m_out.println("<input>");
            }
            StringBuffer indent = new StringBuffer();
            int pLimit = node.pathlength();
            for (int p = 0; p < pLimit; ++p) {
                indent.append(this.m_indent);
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<object");
            sb.append(" size=\"");
            sb.append(node.size());
            sb.append('\"');
            if (!isRoot) {
                sb.append(" part=\"");
                sb.append(this.m_format.format((double)node.size() / (double)root.size()));
                sb.append('\"');
            }
            sb.append(" name=\"");
            XMLNodePrinter.XMLEscape(node.name(), sb);
            sb.append('\"');
            if (node.object() != null) {
                sb.append(" objclass=\"");
                XMLNodePrinter.XMLEscape(ObjectProfiler.typeName(node.object().getClass(), this.m_shortClassNames), sb);
                sb.append('\"');
                if (node.refcount() > 1) {
                    sb.append(" refcount=\"");
                    sb.append(node.refcount());
                    sb.append('\"');
                }
            }
            sb.append('>');
            this.m_out.print(indent);
            this.m_out.println(sb);
        }

        @Override
        public void postvisit(IObjectProfileNode node) {
            StringBuffer indent = new StringBuffer();
            int pLimit = node.pathlength();
            for (int p = 0; p < pLimit; ++p) {
                indent.append(this.m_indent);
            }
            this.m_out.print(indent);
            this.m_out.println("</object>");
            if (node.root() == node) {
                this.m_out.println("</input>");
                this.m_out.flush();
            }
        }

        XMLNodePrinter(OutputStream out, String indent, DecimalFormat format, boolean shortClassNames) {
            assert (out != null) : "null input: out";
            try {
                this.m_out = new PrintWriter(new OutputStreamWriter(out, ENCODING));
            }
            catch (UnsupportedEncodingException uee) {
                throw new Error(uee);
            }
            String string = this.m_indent = indent != null ? indent : "  ";
            if (format != null) {
                this.m_format = format;
            } else {
                this.m_format = (DecimalFormat)NumberFormat.getPercentInstance();
                this.m_format.setMaximumFractionDigits(2);
            }
            this.m_shortClassNames = shortClassNames;
        }

        private static void XMLEscape(String s, StringBuffer append) {
            char[] chars = s.toCharArray();
            int iLimit = s.length();
            block6: for (int i = 0; i < iLimit; ++i) {
                char c = chars[i];
                switch (c) {
                    case '<': {
                        append.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        append.append("&gt;");
                        continue block6;
                    }
                    case '\"': {
                        append.append("&#34;");
                        continue block6;
                    }
                    case '&': {
                        append.append("&amp;");
                        continue block6;
                    }
                    default: {
                        append.append(c);
                    }
                }
            }
        }
    }

    private static final class DefaultNodePrinter
    extends AbstractProfileNodeVisitor {
        private final PrintWriter m_out;
        private final String m_indent;
        private final DecimalFormat m_format;
        private final boolean m_shortClassNames;

        @Override
        public void previsit(IObjectProfileNode node) {
            StringBuffer sb = new StringBuffer();
            int pLimit = node.pathlength();
            for (int p = 0; p < pLimit; ++p) {
                sb.append(this.m_indent);
            }
            IObjectProfileNode root = node.root();
            sb.append(node.size());
            if (node != root) {
                sb.append(" (");
                sb.append(this.m_format.format((double)node.size() / (double)root.size()));
                sb.append(')');
            }
            sb.append(" -> ");
            sb.append(node.name());
            if (node.object() != null) {
                sb.append(" : ");
                sb.append(ObjectProfiler.typeName(node.object().getClass(), this.m_shortClassNames));
                if (node.refcount() > 1) {
                    sb.append(", refcount=");
                    sb.append(node.refcount());
                }
            }
            this.m_out.println(sb);
            this.m_out.flush();
        }

        DefaultNodePrinter(PrintWriter out, String indent, DecimalFormat format, boolean shortClassNames) {
            assert (out != null) : "null input: out";
            this.m_out = out;
            String string = this.m_indent = indent != null ? indent : "| ";
            if (format != null) {
                this.m_format = format;
            } else {
                this.m_format = (DecimalFormat)NumberFormat.getPercentInstance();
                this.m_format.setMaximumFractionDigits(1);
            }
            this.m_shortClassNames = shortClassNames;
        }
    }

    private static abstract class AbstractProfileNodeVisitor
    implements IObjectProfileNode.INodeVisitor {
        private AbstractProfileNodeVisitor() {
        }

        @Override
        public void previsit(IObjectProfileNode node) {
        }

        @Override
        public void postvisit(IObjectProfileNode node) {
        }
    }
}

