/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.print;

import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedSheetArray;
import com.kingdee.cosmic.ctrl.kds.print.SheetPrintJobImp;
import com.kingdee.cosmic.ctrl.kds.print.SpreadSheetPrintJob;
import com.kingdee.cosmic.ctrl.kds.print.SpreadTablePageSetupUI;
import com.kingdee.cosmic.ctrl.print.IVariantParser;
import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePrintSetupModel;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePrintSetupUI;
import com.kingdee.cosmic.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.cosmic.ctrl.print.extend.IMultiPrintJobProvider;
import com.kingdee.cosmic.ctrl.print.extend.JobChangerListener;
import com.kingdee.cosmic.ctrl.print.printjob.IBeforePaginationListener;
import com.kingdee.cosmic.ctrl.print.printjob.IPrintJob;
import com.kingdee.cosmic.ctrl.print.resource.TableResources;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class MultiPrintJobProvider
implements IMultiPrintJobProvider {
    private SpreadContext context;
    PrintConfigModel printmodel = new TablePrintSetupModel();
    String configName = TableResources.getMsg((String)"tree.name");
    protected Book _book;

    public MultiPrintJobProvider(SpreadContext context) {
        this.context = context;
    }

    public MultiPrintJobProvider(Book book) {
        this._book = book;
    }

    public Component getParentWindow() {
        return this.context;
    }

    public PrintConfigModel createPrintConfigModel() {
        return this.printmodel;
    }

    public String getPageSetupConfigName() {
        return this.configName;
    }

    public Class getPageSetupUIClass() {
        return SpreadTablePageSetupUI.class;
    }

    public Class getPrintSetupUIClass() {
        return TablePrintSetupUI.class;
    }

    public Book getBook() {
        if (this.context != null) {
            return this.context.getBook();
        }
        return this._book;
    }

    public IPrintJob createPrintJob(String jobname) {
        SpreadSheetPrintJob job = null;
        Sheet sheet = this.getBook().getSheetByID(jobname);
        if (sheet != null) {
            SheetPrintJobImp spji = new SheetPrintJobImp(sheet, this.context);
            sheet.setPrintInfo(spji);
            job = new SpreadSheetPrintJob(spji, this.printmodel, this.configName);
            job.setUserObject((Object)this.context);
        }
        return job;
    }

    public IConfigModel createJobConfigModel() {
        return new TablePageSetupModel();
    }

    public List getSelectJobs() {
        ArrayList<String> list = new ArrayList<String>(4);
        SortedSheetArray sheets = this.getBook().getSelectSheets();
        for (int i = 0; i < sheets.size(); ++i) {
            Sheet sheet = sheets.getSheet(i);
            list.add(sheet.getID());
        }
        return list;
    }

    public List getAllJobs() {
        ArrayList<String> list = new ArrayList<String>(4);
        Book book = this.getBook();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet sheet = book.getSheet(i);
            list.add(sheet.getID());
        }
        return list;
    }

    public void setJobChangeListener(JobChangerListener manager) {
    }

    public int getJobCount() {
        return this.getBook().getSheetCount();
    }

    public String getJobName(int index) {
        return this.getBook().getSheet(index).getID();
    }

    public boolean isEmptyJob(String jobname) {
        Sheet sheet = this.getBook().getSheet(jobname);
        if (sheet == null) {
            return true;
        }
        return sheet.getMaxColIndex() <= -1 && sheet.getMaxRowIndex() <= -1;
    }

    public IBeforePaginationListener getBeforePaginationListener() {
        return null;
    }

    public void createHeaderFooter(IPrintJob job, String name) {
    }

    public IVariantParser getVariantParser(String name) {
        return null;
    }
}

