/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.lfm;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.lfm.IExtThemeConfiguration;
import java.awt.Color;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StaticColorContainer
implements IExtThemeConfiguration {
    private static final Logger logger = LogUtil.getPackageLogger(StaticColorContainer.class);
    private static String _colorSpaceName = IExtThemeConfiguration.getColorSpaceBussinessSteady();
    private static HashMap _colorMaps = new HashMap();

    @Override
    public void setContainerColorSpace(String colorSpaceName) {
        _colorSpaceName = colorSpaceName;
        _colorMaps.clear();
    }

    private static void initColors() {
        DefaultHandler dh = new DefaultHandler(){
            private String currentTemplateName;
            private String currentModelName;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equals("template")) {
                    this.currentTemplateName = attributes.getValue("type");
                    _colorMaps.put(this.currentTemplateName, new HashMap());
                } else if (qName.equals("colors")) {
                    this.currentModelName = attributes.getValue("name");
                    HashMap map = (HashMap)_colorMaps.get(this.currentTemplateName);
                    map.put(this.currentModelName, new ArrayList());
                } else if (qName.equals("value")) {
                    HashMap map = (HashMap)_colorMaps.get(this.currentTemplateName);
                    ArrayList currentColors = (ArrayList)map.get(this.currentModelName);
                    String color = attributes.getValue("color");
                    String alpha = attributes.getValue("alpha");
                    currentColors.add(new Color(Integer.parseInt(color.substring(0, 2), 16), Integer.parseInt(color.substring(2, 4), 16), Integer.parseInt(color.substring(4), 16), Integer.parseInt(alpha)));
                }
            }
        };
        String language = Locale.getDefault().getLanguage();
        String str = "";
        switch (language) {
            case "zh": 
            case "zh-ch": {
                str = "CN";
                break;
            }
            case "en": {
                str = "US";
                break;
            }
            case "zh-tw": {
                str = "TW";
                break;
            }
            default: {
                str = "US";
            }
        }
        String xmlFileName = "template_" + str + ".xml";
        try (InputStream stream = StaticColorContainer.class.getResourceAsStream(xmlFileName);){
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.newSAXParser().parse(stream, dh);
        }
        catch (Exception e) {
            System.out.println("------------------------------\u521d\u59cb\u5316\u914d\u8272\u65b9\u6848\u5931\u8d25-------------------------------");
            logger.error((Object)"err", (Throwable)e);
            System.out.println("------------------------------------------------------------------------------");
        }
    }

    @Override
    public Object getColors(String templateName, String typeName) {
        HashMap templateMap;
        if (_colorMaps.isEmpty()) {
            StaticColorContainer.initColors();
        }
        if ((templateMap = (HashMap)_colorMaps.get(templateName)) == null) {
            templateMap = (HashMap)_colorMaps.get(_colorSpaceName);
        }
        ArrayList set = (ArrayList)templateMap.get(typeName);
        Color[] ret = new Color[set.size()];
        set.toArray(ret);
        return ret;
    }
}

