/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common;

import com.kingdee.cosmic.ctrl.common.NullValue;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.CollectionUtil;
import com.kingdee.cosmic.ctrl.common.util.ColorUtil;
import com.kingdee.cosmic.ctrl.common.util.DBUtil;
import com.kingdee.cosmic.ctrl.common.util.FileUtil;
import com.kingdee.cosmic.ctrl.common.util.FontUtil;
import com.kingdee.cosmic.ctrl.common.util.GraphicsUtil;
import com.kingdee.cosmic.ctrl.common.util.LangUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.MapUtil;
import com.kingdee.cosmic.ctrl.common.util.NumberUtil;
import com.kingdee.cosmic.ctrl.common.util.ObjectUtil;
import com.kingdee.cosmic.ctrl.common.util.PathUtil;
import com.kingdee.cosmic.ctrl.common.util.ReflectUtil;
import com.kingdee.cosmic.ctrl.common.util.ScaleUtil;
import com.kingdee.cosmic.ctrl.common.util.StreamUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import java.util.Locale;

public final class CtrlUtil {
    public static final boolean is64BitJVM() {
        String prop = System.getProperty("sun.arch.data.model");
        if (null == prop) {
            prop = System.getProperty("com.ibm.vm.bitmode");
        }
        return "64".equals(prop);
    }

    public static String getOSArch() {
        return System.getProperty("os.arch");
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static boolean isWinOS() {
        return CtrlUtil.getOSName().startsWith("Win");
    }

    public static boolean isLinuxOS() {
        return CtrlUtil.getOSName().equals("Linux");
    }

    public static boolean isMacOS() {
        return CtrlUtil.getOSName().startsWith("Mac OS");
    }

    public static int compareJDKVersion(String sourceVersion) {
        int j;
        String currentVersion = System.getProperty("java.version");
        if (currentVersion == null) {
            throw new IllegalStateException("didn't found java version");
        }
        sourceVersion = sourceVersion.replace('_', '.').replace('_', '.').replaceAll("[^\\d.]+", "0");
        currentVersion = currentVersion.replace('_', '.').replace('_', '.').replaceAll("[^\\d.]+", "0");
        String[] srcArr = sourceVersion.toLowerCase(Locale.ROOT).split("\\.");
        String[] currArr = currentVersion.toLowerCase(Locale.ROOT).split("\\.");
        int i = 0;
        for (j = 0; i < srcArr.length && j < currArr.length; ++i, ++j) {
            if (Long.parseLong(srcArr[i]) > Long.parseLong(currArr[j])) {
                return 1;
            }
            if (Long.parseLong(srcArr[i]) >= Long.parseLong(currArr[j])) continue;
            return -1;
        }
        while (i < srcArr.length) {
            if (Long.parseLong(srcArr[i]) != 0L) {
                return 1;
            }
            ++i;
        }
        while (j < currArr.length) {
            if (Long.parseLong(currArr[j]) != 0L) {
                return -1;
            }
            ++j;
        }
        return 0;
    }

    public static class DB
    extends DBUtil {
    }

    public static class Lang
    extends LangUtil {
    }

    public static class Graphics
    extends GraphicsUtil {
    }

    public static class Array
    extends ArrayUtil {
    }

    public static class Collection
    extends CollectionUtil {
    }

    public static class Color
    extends ColorUtil {
    }

    public static class Font
    extends FontUtil {
    }

    public static class File
    extends FileUtil {
    }

    public static class Path
    extends PathUtil {
    }

    public static class Reflect
    extends ReflectUtil {
    }

    public static class Log
    extends LogUtil {
    }

    public static class Scale
    extends ScaleUtil {
    }

    public static class Map
    extends MapUtil {
    }

    public static class Num
    extends NumberUtil {
    }

    public static class Obj
    extends ObjectUtil {
    }

    public static class Stream
    extends StreamUtil {
    }

    public static class Xml
    extends XmlUtil {
    }

    public static class Str
    extends StringUtil {
    }

    public static class Null
    extends NullValue {
    }
}

