/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common;

import com.kingdee.cosmic.ctrl.common.util.FileUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StreamUtil;
import com.kingdee.cosmic.ctrl.common.util.SystemPropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class GlobalLocator {
    private static Logger logger = LogUtil.getPackageLogger(GlobalLocator.class);
    private static final GlobalLocator instance = new GlobalLocator();
    private final String CTRL_HOME = "ctrlhome";
    private final String USER_HOME = "user.home";
    private final String RESOURCE_HOME = "com/kingdee/cosmic/ctrl/ctrlhome";
    public static final String TEMP_DIR = "/temp";
    private String homeDir;

    public static GlobalLocator getInstance() {
        return instance;
    }

    private GlobalLocator() {
        this.makeHomeDir();
    }

    private void makeHomeDir() {
        this.homeDir = System.getProperty("ctrlhome");
        if (this.homeDir == null) {
            URL url;
            ClassLoader clsLdr = this.getClass().getClassLoader();
            if (clsLdr == null) {
                clsLdr = ClassLoader.getSystemClassLoader();
            }
            if ((url = clsLdr.getResource("ctrlhome")) != null) {
                this.homeDir = url.getPath();
                logger.info((Object)("ctrlhome = {Class Path} : " + this.homeDir));
            }
            if (this.homeDir == null) {
                this.homeDir = System.getProperty("user.home") + FileUtil.FILE_SEPARATOR + "ctrlhome";
            }
        } else {
            logger.info((Object)("ctrlhome = {CTRL_HOME} : " + this.homeDir));
        }
        int z = this.homeDir.length() - 1;
        char c = this.homeDir.charAt(z);
        if (c == File.separatorChar || c == '/') {
            this.homeDir = this.homeDir.substring(0, z);
        }
        SystemPropertyUtil.setString("ctrlhome", this.homeDir);
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public String makeFilePath(String pathText) {
        if (pathText == null || this.homeDir == null) {
            return null;
        }
        if (pathText.length() == 0) {
            return this.homeDir;
        }
        if (pathText.charAt(0) == '/') {
            if (File.separatorChar != '/') {
                pathText = pathText.replace('/', File.separatorChar);
            }
            return this.homeDir + pathText;
        }
        return pathText;
    }

    public URL makeURL(String pathText) throws MalformedURLException {
        if (-1 == (pathText = this.makeFilePath(pathText)).indexOf("://")) {
            pathText = "file:///" + pathText;
        }
        return new URL(pathText);
    }

    public String makeResourcePath(String pathText) {
        return "com/kingdee/cosmic/ctrl/ctrlhome" + pathText;
    }

    public InputStream loadResourceFile(String pathText) throws IOException {
        String resPath = this.makeResourcePath(pathText);
        URL resUrl = this.getClass().getClassLoader().getResource(resPath);
        return resUrl.openStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createResourceFile(String pathText) throws IOException {
        String resPath = this.makeResourcePath(pathText);
        URL resUrl = this.getClass().getClassLoader().getResource(resPath);
        if (resUrl == null) {
            logger.error((Object)"Cannot locate resource");
            return null;
        }
        String filePath = this.makeFilePath(pathText);
        File f = FileUtil.createFile(filePath);
        if (f == null) {
            return null;
        }
        InputStream res = null;
        FileOutputStream fos = null;
        try {
            res = resUrl.openStream();
            fos = new FileOutputStream(f);
            StreamUtil.copy(res, fos, 4096);
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(res);
            StreamUtil.closeStream(fos);
            throw throwable;
        }
        StreamUtil.closeStream(res);
        StreamUtil.closeStream(fos);
        logger.info((Object)"File created successful");
        return f;
    }

    public File createTempFile(String prefix, String suffix) {
        try {
            File temp = File.createTempFile(prefix, suffix, this.locateResourceFolder(TEMP_DIR));
            return temp;
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
            return null;
        }
    }

    public File locateResourceFolder(String pathText) {
        String filePath = this.makeFilePath(pathText);
        File f = new File(FilenameUtils.normalize((String)filePath));
        if (!f.exists() && (f = FileUtil.createFolder(filePath)) == null) {
            return null;
        }
        if (f.isDirectory()) {
            return f;
        }
        return null;
    }

    public File locateResourceFile(String pathText) {
        File f = new File(FilenameUtils.normalize((String)this.makeFilePath(pathText)));
        if (!f.exists()) {
            try {
                f = this.createResourceFile(pathText);
            }
            catch (Exception e) {
                return null;
            }
            if (f == null) {
                return null;
            }
        }
        if (f.isFile()) {
            return f;
        }
        return null;
    }

    public InputStream locateResourceFileStream(String pathText) {
        FileInputStream fis;
        File f = this.locateResourceFile(pathText);
        if (f == null) {
            return null;
        }
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"err", (Throwable)e);
            return null;
        }
        return fis;
    }
}

