/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.tool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.NoSuchElementException;

public class Monitor {
    protected Schedule schedule = new Schedule();
    protected Schedule realSche = new Schedule();

    public boolean checkEvents() {
        boolean ret = true;
        int size = this.schedule.size();
        for (int i = 0; i < size; ++i) {
            int flag = this.schedule.getFlag(i);
            ret &= flag == 0;
        }
        return ret;
    }

    public boolean checkAllFired() {
        boolean ret = true;
        int size = this.schedule.size();
        for (int i = 0; i < size; ++i) {
            int flag = this.schedule.getFlag(i);
            ret &= flag != 1;
        }
        return ret;
    }

    public boolean checkOrder() {
        return this.schedule.isOrderly();
    }

    public EventListener register(EventListener listener) {
        return (EventListener)this.getProxy(listener);
    }

    public void addItem(EventListener listener, String method) {
        Object hdl = listener;
        Class<?> cls = listener.getClass();
        if (Proxy.isProxyClass(cls)) {
            ListenerProxy proxy = (ListenerProxy)Proxy.getInvocationHandler(listener);
            hdl = proxy.getReal();
        }
        this.schedule.add(hdl, method);
    }

    public void clean() {
        this.schedule.clear();
        this.realSche.clear();
    }

    public void printSchedule() {
        this.printSchedule(this.schedule);
    }

    public void printRealSche() {
        this.printSchedule(this.realSche);
    }

    private void printSchedule(Schedule sche) {
    }

    private Object getProxy(Object obj) {
        Class<?> cls = obj.getClass();
        ListenerProxy hdl = new ListenerProxy(obj);
        return Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), (InvocationHandler)hdl);
    }

    public static class Result {
        public static final int OK = 0;
        public static final int FALSE = 1;
        public static final int FAILED = -1;

        public static String getDescription(int flag) {
            String ret;
            switch (flag) {
                case 0: {
                    ret = "OK";
                    break;
                }
                case 1: {
                    ret = "FALSE";
                    break;
                }
                case -1: {
                    ret = "FAILED";
                    break;
                }
                default: {
                    ret = "UNKNOWN";
                }
            }
            return ret;
        }
    }

    protected static class Schedule {
        private boolean orderly = true;
        private List list = new ArrayList();

        public void add(Object obj, String method) {
            Item item = new Item(obj, method);
            this.list.add(item);
        }

        public void add(Object obj, String method, int flag, int times) {
            Item item = new Item(obj, method, flag, times);
            this.list.add(item);
        }

        public void setFlag(Object obj, String method) {
            boolean done = false;
            int start = 0;
            int index = -1;
            while (!done) {
                index = this.indexOf(obj, method, start);
                if (index != -1) {
                    done = this.setFlag(index, 0, false);
                    start = index + 1;
                    continue;
                }
                if (start <= 0) break;
                done = this.setFlag(start - 1, -1, true);
            }
        }

        private boolean setFlag(int index, int flag, boolean always) {
            boolean ret = true;
            Item item = (Item)this.list.get(index);
            if (item != null) {
                if (item.getResult() != 1) {
                    if (always) {
                        item.setResult(flag);
                        item.IncTimes();
                        this.checkOrderly(index);
                    } else {
                        ret = false;
                    }
                } else {
                    item.setResult(flag);
                    item.IncTimes();
                    this.checkOrderly(index);
                }
            }
            return ret;
        }

        private void checkOrderly(int index) {
            if (index > 0) {
                Item item = (Item)this.list.get(index - 1);
                if (item == null) {
                    throw new NoSuchElementException();
                }
                if (item.getResult() == 1) {
                    this.orderly = false;
                }
            }
        }

        public int getFlag(int index) {
            Item item = (Item)this.list.get(index);
            if (item != null) {
                return item.getResult();
            }
            throw new NoSuchElementException();
        }

        private int indexOf(Object obj, String method, int start) {
            int ret = -1;
            int size = this.list.size();
            for (int i = start; i < size; ++i) {
                Item item = (Item)this.list.get(i);
                if (item == null || obj != item.getActor() || !method.equals(item.getAction())) continue;
                ret = i;
                break;
            }
            return ret;
        }

        public int size() {
            return this.list.size();
        }

        public void clear() {
            this.list.clear();
            this.orderly = true;
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public boolean isOrderly() {
            return this.orderly;
        }

        protected static class Item {
            private Object actor;
            private String action;
            private int result;
            private int times = 0;

            public Item(Object actor, String action) {
                this.actor = actor;
                this.action = action;
                this.setResult(1);
            }

            public Item(Object actor, String action, int flag, int times) {
                this.actor = actor;
                this.action = action;
                this.times = times;
                this.setResult(flag);
            }

            public int getResult() {
                return this.result;
            }

            public void setResult(int i) {
                this.result = i;
            }

            public void IncTimes() {
                ++this.times;
            }

            public int getTimes() {
                return this.times;
            }

            public String getAction() {
                return this.action;
            }

            public Object getActor() {
                return this.actor;
            }

            public String toString() {
                String str = this.actor + "." + this.action + ": " + Result.getDescription(this.getResult()) + " " + this.times;
                return str;
            }
        }
    }

    private class ListenerProxy
    implements InvocationHandler {
        private Object real;

        public ListenerProxy(Object obj) {
            this.real = obj;
        }

        public Object getReal() {
            return this.real;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Monitor.this.schedule.setFlag(this.real, method.getName());
            Monitor.this.realSche.add(this.real, method.getName(), 0, 1);
            Object o = method.invoke(this.real, args);
            return o;
        }
    }
}

