/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util;

import com.kingdee.cosmic.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.common.variant.Variant;
import java.util.Calendar;

public class DateUtil {
    private static Calendar baseDate;

    public static Calendar getBaseDate() {
        if (baseDate == null) {
            baseDate = Calendar.getInstance();
            baseDate.set(14, 0);
            baseDate.set(1900, 0, 0, 0, 0, 0);
        }
        return baseDate;
    }

    public static Variant days360(Variant start_date, Variant end_date, boolean method) throws SyntaxErrorException {
        int d2;
        int m2;
        int y2;
        int d1;
        int m1;
        int y1;
        int dc;
        Calendar start = start_date.toCalendar();
        Calendar end = end_date.toCalendar();
        if (start == null && end == null) {
            return new Variant(0);
        }
        if (start == null) {
            start = DateUtil.getBaseDate();
        } else if (end == null) {
            end = DateUtil.getBaseDate();
        }
        long tStart = start.getTimeInMillis();
        long tEnd = end.getTimeInMillis();
        int n = tEnd > tStart ? 1 : (dc = tStart == tEnd ? 0 : -1);
        if (dc == 0) {
            return new Variant(0);
        }
        if (dc > 0) {
            y1 = start.get(1);
            m1 = start.get(2);
            d1 = start.get(5);
            y2 = end.get(1);
            m2 = end.get(2);
            d2 = end.get(5);
        } else {
            y1 = end.get(1);
            m1 = end.get(2);
            d1 = end.get(5);
            y2 = start.get(1);
            m2 = start.get(2);
            d2 = start.get(5);
        }
        if (method) {
            if (d1 == 31) {
                d1 = 30;
            }
            if (d2 == 31) {
                d2 = 30;
            }
        } else {
            if (d1 == 31) {
                d1 = 30;
            }
            if (d2 == 31) {
                if (d1 < 30) {
                    if (m2 == 11) {
                        ++y2;
                        m2 = 1;
                    } else {
                        ++m2;
                    }
                    d2 = 1;
                } else {
                    d2 = 30;
                }
            }
        }
        int dAll = DateUtil.days360_Help(y1, m1, d1, y2, m2, d2);
        return new Variant(dc > 0 ? dAll : -dAll);
    }

    private static int days360_Help(int y1, int m1, int d1, int y2, int m2, int d2) {
        int dy = y2 - y1;
        int dm = m2 - m1;
        int dd = d2 - d1;
        int dAll = 0;
        if (dy == 0) {
            dAll = dm == 0 ? (dd == 0 ? 0 : dd) : (dm - 1) * 30 + (30 - d1) + d2;
        } else {
            dAll = (dy - 1) * 360;
            dAll += (11 - m1) * 30;
            dAll += 30 - d1 + 1;
            dAll += m2 * 30;
            dAll += d2 - 1;
        }
        return dAll;
    }
}

