/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.util.LangUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class LangResource {
    public static final String T_RESOURCE = "resource";
    public static final String T_RS = "rs";
    public static final String T_LANG = "lang";
    public static final String A_KEY = "key";
    public static final String A_LOCALE = "locale";
    public static final String A_VALUE = "value";
    public static final String KEY_SPLIT = ":";
    private HashMap res;
    private String defaultLang;
    public static char KEY_PREFIX = "#".charAt(0);

    public LangResource() {
        this.setDefaultLang(LangUtil.makeDefaultLang());
        this.res = new HashMap();
    }

    public void setDefaultLang(String lang) {
        this.defaultLang = lang;
    }

    private String makeLangKey(String key, String locale) {
        return key + KEY_SPLIT + locale;
    }

    public void addString(String key, String locale, String value) {
        this.res.put(this.makeLangKey(key, locale), value);
    }

    public String getString(String key) {
        return (String)this.res.get(this.makeLangKey(key, this.defaultLang));
    }

    public String getString(String key, String locale) {
        return (String)this.res.get(this.makeLangKey(key, locale));
    }

    public static final LangResource loadAllResource(IXmlElement xml) {
        return LangResource.loadResource(xml, null);
    }

    public static final LangResource loadDefaultResource(IXmlElement xml) {
        return LangResource.loadResource(xml, LangUtil.makeDefaultLang());
    }

    public static final LangResource loadResource(IXmlElement xml, String lang) {
        LangResource res = new LangResource();
        if (xml != null) {
            List lst = xml.searchChildren(T_RS);
            Iterator itr = lst.iterator();
            while (itr.hasNext()) {
                LangResource.loadRs((IXmlElement)itr.next(), res, lang);
            }
        }
        return res;
    }

    private static final void loadRs(IXmlElement xmlRs, LangResource out, String lang) {
        String key = xmlRs.getAttribute(A_KEY);
        List lst = xmlRs.searchChildren(T_LANG);
        for (IXmlElement xmlLang : lst) {
            String loc = xmlLang.getAttribute(A_LOCALE);
            if (lang != null && !lang.equals(loc)) continue;
            String val = xmlLang.getAttribute(A_VALUE);
            out.addString(key, loc, StringUtil.fromProperty(val));
        }
    }

    public static String getResString(String valKey, LangResource res) {
        String s;
        if (valKey != null && valKey.length() > 1 && KEY_PREFIX == valKey.charAt(0) && (s = res.getString(valKey.substring(1))) != null) {
            return s;
        }
        return valKey;
    }
}

