/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.util;

import java.util.Properties;
import java.util.Set;

public class SystemPropertyUtil {
    public static void setProperty(Properties properties) {
        Set<Object> keySet = properties.keySet();
        for (Object key : keySet) {
            if (!(key instanceof String)) continue;
            String keyString = (String)key;
            SystemPropertyUtil.setPropertyIfNotExist(keyString, properties.getProperty(keyString));
        }
    }

    public static void setPropertyIfNotExist(String key, String newValue) {
        String oldValue = SystemPropertyUtil.getString(key);
        if (oldValue == null || "".equals(oldValue.trim())) {
            SystemPropertyUtil.setString(key, newValue);
        }
    }

    public static String getString(String key) {
        return System.getProperty(key);
    }

    public static void setString(String key, String value) {
        System.setProperty(key, value);
    }

    public static String getString(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }

    public static int getInt(String key, int defaultValue) {
        String value = System.getProperty(key);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static long getLong(String key, long defaultValue) {
        String value = System.getProperty(key);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = System.getProperty(key);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static Properties getProperties() {
        return System.getProperties();
    }
}

