/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.variant;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.log4j.Logger;

public class ChinaComparator {
    private static final Logger logger = LogUtil.getPackageLogger(ChinaComparator.class);
    private static int BUFFER_SIZE = 8096;
    private static Comparator _cmp = null;
    private static Integer MAX_SIZE = 5;
    private static ArrayBlockingQueue<Comparator> queue = new ArrayBlockingQueue(MAX_SIZE);

    public static synchronized Comparator getInstance() {
        if (_cmp != null) {
            return _cmp;
        }
        _cmp = ChinaComparator.createComparator();
        return _cmp;
    }

    private static Comparator createComparator() {
        RuleBasedCollator cmp;
        StringBuilder rules = new StringBuilder(102400);
        int count = BUFFER_SIZE;
        char[] buffer = new char[BUFFER_SIZE];
        ClassLoader cl = ChinaComparator.class.getClassLoader();
        InputStream is = cl.getResourceAsStream("com/kingdee/cosmic/ctrl/common/variant/py.txt");
        if (is == null) {
            throw new RuntimeException(CtrlCommonMessages.getMLS("resourceFileNotFound", "\u672a\u53d1\u73b0\u8d44\u6e90\u6587\u4ef6") + " com/kingdee/cosmic/ctrl/common/variant/py.txt");
        }
        try (InputStreamReader isr = new InputStreamReader(is, "UTF-8");){
            while (count == BUFFER_SIZE && (count = isr.read(buffer, 0, count)) >= 0) {
                rules.append(buffer, 0, count);
            }
            cmp = new RuleBasedCollator(rules.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(CtrlCommonMessages.getMLS("loadResourceFile", "\u88c5\u8f7d\u8d44\u6e90\u6587\u4ef6") + " com/kingdee/cosmic/ctrl/common/variant/py.txt", e);
        }
        return cmp;
    }

    public static Comparator getComparator() {
        try {
            return queue.take();
        }
        catch (InterruptedException e) {
            logger.error((Object)"err", (Throwable)e);
            Comparator cmp = ChinaComparator.createComparator();
            ChinaComparator.addComparator(cmp);
            return cmp;
        }
    }

    public static void addComparator(Comparator cmp) {
        try {
            queue.add(cmp);
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    static {
        try {
            for (int i = 0; i < MAX_SIZE; ++i) {
                queue.put(ChinaComparator.createComparator());
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }
}

