/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.data.meta;

import com.kingdee.cosmic.ctrl.common.FullPath;
import com.kingdee.cosmic.ctrl.data.DataDefType;
import com.kingdee.cosmic.ctrl.data.meta.MetaClass;
import com.kingdee.cosmic.ctrl.data.meta.MetaLibrary;
import com.kingdee.cosmic.ctrl.data.meta.MetaPackage;
import java.util.List;

public class MetaUtil {
    public static boolean likeRows(MetaClass mc) {
        if (mc == null) {
            return false;
        }
        DataDefType mcType = DataDefType.fromName(mc.getType());
        if (mcType == null) {
            return false;
        }
        return DataDefType.likeRows(mcType);
    }

    public static final FullPath makeFullPath(MetaClass mc, MetaLibrary ml) {
        FullPath fp = new FullPath();
        if (ml != null) {
            fp.setSpace(ml.getFullName());
        }
        if (mc != null) {
            fp.setPathx(mc.getFullName());
        }
        return fp;
    }

    public static MetaPackage makeMetaPackage(MetaClass mc) {
        MetaPackage rootPackage;
        MetaPackage tempPackage = rootPackage = new MetaPackage();
        String expr = mc.getExpr();
        String[] strPks = expr.split("\\.");
        for (int i = 0; i < strPks.length - 1; ++i) {
            tempPackage.addPackage(new MetaPackage());
            tempPackage = (MetaPackage)tempPackage.getPackages().get(0);
            tempPackage.setName(strPks[i]);
        }
        tempPackage.addClass(mc);
        return rootPackage;
    }

    public static void convert2DBTable(MetaPackage mp) {
        List mcs = mp.getClasses();
        int z = mcs.size();
        for (int i = 0; i < z; ++i) {
            MetaClass mc = (MetaClass)mcs.get(i);
            mc.setType(DataDefType.DB_TABLE.getName());
            mc.setExpr(mc.getName());
        }
        List mps = mp.getPackages();
        z = mps.size();
        for (int i = 0; i < z; ++i) {
            MetaUtil.convert2DBTable((MetaPackage)mps.get(i));
        }
    }
}

