/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.data.meta.io;

import com.kingdee.cosmic.ctrl.common.DataType;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.data.DataDefType;
import com.kingdee.cosmic.ctrl.data.meta.MetaClass;
import com.kingdee.cosmic.ctrl.data.meta.MetaField;
import com.kingdee.cosmic.ctrl.data.meta.MetaLibrary;
import com.kingdee.cosmic.ctrl.data.meta.MetaPackage;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DB2Meta {
    private static final Logger log = LogUtil.getPackageLogger(DB2Meta.class);

    public static DataDefType toDataObjType(String type) {
        if ("TABLE".equals(type)) {
            return DataDefType.DB_TABLE;
        }
        if ("VIEW".equals(type)) {
            return DataDefType.DB_VIEW;
        }
        return null;
    }

    public MetaLibrary parseDataBase(Connection conn, String dbName) {
        MetaLibrary ml = new MetaLibrary();
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            ml.setName(dbName);
            String[] filterTypes = new String[]{"TABLE", "VIEW"};
            ResultSet rsTbls = dmd.getTables(null, null, "%", filterTypes);
            MetaPackage mpRoot = ml.getRootPackage();
            while (rsTbls.next()) {
                String tblType = rsTbls.getString("TABLE_TYPE");
                DataDefType mct = DB2Meta.toDataObjType(tblType);
                if (mct == null) continue;
                String tableName = rsTbls.getString("TABLE_NAME");
                ResultSet rsCols = dmd.getColumns(null, null, tableName, null);
                MetaClass mc = new MetaClass();
                mc.setNamex(tableName, mct.getName());
                mc.setExpr(tableName);
                while (rsCols.next()) {
                    MetaField mf = this.parseColumn(rsCols);
                    mc.addField(mf);
                }
                rsCols.close();
                mpRoot.addClass(mc);
            }
            rsTbls.close();
        }
        catch (SQLException e) {
            log.error((Object)"errmsg", (Throwable)e);
            return null;
        }
        return ml;
    }

    public MetaField parseColumn(ResultSet rsCols) throws SQLException {
        String name = rsCols.getString("COLUMN_NAME");
        int type = rsCols.getInt("DATA_TYPE");
        MetaField mf = new MetaField();
        mf.setName(name);
        mf.setExpr(name);
        mf.setType(DataType.fromJdbcType(type));
        return mf;
    }
}

