/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.data.meta.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.DataType;
import com.kingdee.cosmic.ctrl.data.meta.MetaClass;
import com.kingdee.cosmic.ctrl.data.meta.MetaField;
import com.kingdee.cosmic.ctrl.data.meta.MetaLibrary;
import com.kingdee.cosmic.ctrl.data.meta.MetaPackage;
import com.kingdee.cosmic.ctrl.data.modal.io.ParameterIO;
import com.kingdee.cosmic.ctrl.data.modal.io.Xml2Def;
import java.util.Iterator;

public class Xml2Meta {
    public MetaLibrary transform(IXmlElement xmlLib) {
        if ("Library".equals(xmlLib.getName())) {
            return Xml2Meta.parseLibrary(xmlLib);
        }
        return null;
    }

    public static MetaLibrary parseLibrary(IXmlElement xmlLib) {
        MetaLibrary ml = new MetaLibrary();
        Xml2Def.parseDefObj(ml, xmlLib);
        Xml2Meta.parsePackage(ml.getRootPackage(), xmlLib);
        return ml;
    }

    public static void parsePackage(MetaPackage pkg, IXmlElement xmlPkg) {
        Iterator itrCls = xmlPkg.searchChildren("Class").iterator();
        while (itrCls.hasNext()) {
            MetaClass subCls = Xml2Meta.parseClass((IXmlElement)itrCls.next());
            if (subCls == null) continue;
            pkg.addClass(subCls);
        }
        Iterator itrPkg = xmlPkg.searchChildren("Package").iterator();
        while (itrPkg.hasNext()) {
            MetaPackage subPkg = Xml2Meta.parsePackage((IXmlElement)itrPkg.next());
            if (subPkg == null) continue;
            pkg.addPackage(subPkg);
        }
    }

    public static MetaPackage parsePackage(IXmlElement xmlPkg) {
        if (!"Package".equals(xmlPkg.getName())) {
            return null;
        }
        MetaPackage mp = new MetaPackage();
        Xml2Def.parseDefObj(mp, xmlPkg);
        Xml2Meta.parsePackage(mp, xmlPkg);
        return mp;
    }

    public static MetaClass parseClass(IXmlElement xmlCls) {
        if (!"Class".equals(xmlCls.getName())) {
            return null;
        }
        MetaClass mc = new MetaClass();
        String ver = xmlCls.getAttribute("version");
        if (ver == null) {
            Xml2Def.upgradeSC(mc, xmlCls);
        } else {
            Xml2Def.parseDefObj(mc, xmlCls);
        }
        mc.setType(xmlCls.getAttribute("type"));
        mc.setExpr(xmlCls.getAttribute("expr"));
        IXmlElement elm = xmlCls.getChild("Parameters");
        if (elm != null) {
            mc.setParameters(ParameterIO.parseParameters(elm));
        }
        Iterator itr = xmlCls.searchChildren("Field").iterator();
        while (itr.hasNext()) {
            MetaField fld = Xml2Meta.parseField((IXmlElement)itr.next(), ver);
            if (fld == null) continue;
            mc.addField(fld);
        }
        return mc;
    }

    public static MetaField parseField(IXmlElement xmlFld, String ver) {
        if (!"Field".equals(xmlFld.getName())) {
            return null;
        }
        MetaField mf = new MetaField();
        if (ver == null) {
            Xml2Def.upgradeSC(mf, xmlFld);
        } else {
            Xml2Def.parseDefObj(mf, xmlFld);
        }
        mf.setType(DataType.fromName(xmlFld.getAttribute("type")));
        mf.setExpr(xmlFld.getAttribute("expr"));
        return mf;
    }
}

