/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.expr;

import com.kingdee.cosmic.ctrl.kdf.expr.ArrayStack;
import com.kingdee.cosmic.ctrl.kdf.expr.Element;
import com.kingdee.cosmic.ctrl.kdf.expr.ExprError;
import com.kingdee.cosmic.ctrl.kdf.expr.HashStack;
import com.kingdee.cosmic.ctrl.kdf.expr.IElement;
import com.kingdee.cosmic.ctrl.kdf.expr.MacroHelperListener;
import com.kingdee.cosmic.ctrl.kdf.expr.Parser;
import com.kingdee.cosmic.ctrl.kdf.expr.ParserBuffer;
import com.kingdee.cosmic.ctrl.kdf.expr.ParserHelperListener;
import com.kingdee.cosmic.ctrl.kdf.expr.RelationsListener;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Dependents {
    private static final int DEPS_CALLSTACK_OVERFLOW = 100;
    private HashMap deps = new HashMap();
    private HashMap elements = new HashMap();
    private ArrayList calcList;
    private ArrayStack callStack = new ArrayStack();
    private HashStack cycCheck = new HashStack();
    private ParserBuffer psrBuffer;
    private DepParserHelper psrHelper;
    private MacroHelperListener varListener;
    private int calcID;
    private boolean calculateThrough = false;

    public Dependents() {
        this.calcList = new ArrayList();
        this.psrHelper = new DepParserHelper();
        this.psrBuffer = new ParserBuffer(this.psrHelper);
        this.calcID = Integer.MIN_VALUE;
    }

    public void addMacroRelationsListener(MacroHelperListener listener) {
        this.varListener = listener;
    }

    public void add(String name, String formula) {
        if (!this.elements.containsKey(name)) {
            Element e = new Element(name, formula);
            this.elements.put(name, e);
            this.calcList.add(e);
            assert (e.isNeedCalc(this.calcID));
        } else {
            Element e = (Element)this.elements.get(name);
            if (!e.getFormula().equals(formula)) {
                e.setFormula(formula);
                this.queueElement(e);
            } else if (this.calculateThrough) {
                e.setNeedCalc(true);
                this.queueElement(e);
            }
        }
    }

    public boolean remove(String name) {
        Object obj = this.elements.remove(name);
        if (obj != null) {
            IElement e = (IElement)obj;
            e.setNeedCalc(true);
            this.queueElement(e);
            this.deps.remove(e);
            Iterator i = this.calcList.iterator();
            while (i.hasNext()) {
                IElement e2 = (IElement)i.next();
                if (e != e2) continue;
                i.remove();
            }
            return true;
        }
        return false;
    }

    public boolean removeAll() {
        boolean hasObj = !this.elements.isEmpty();
        this.deps.clear();
        this.elements.clear();
        this.calcList.clear();
        this.callStack.clear();
        this.cycCheck.clear();
        this.calcID = Integer.MIN_VALUE;
        return hasObj;
    }

    public boolean isDependent(String from, String to) {
        Object objFrom = this.elements.get(from);
        Object objTo = this.elements.get(to);
        if (objFrom == null || objTo == null) {
            return false;
        }
        Object objList = this.deps.get((IElement)objTo);
        return this.isDependent((ArrayList)objList, (IElement)objFrom);
    }

    private boolean isDependent(ArrayList list, IElement from) {
        if (list == null) {
            return false;
        }
        if (list.contains(from)) {
            return true;
        }
        for (IElement e : list) {
            Object objList = this.deps.get(e);
            if (objList == null || !this.isDependent((ArrayList)objList, from)) continue;
            return true;
        }
        return false;
    }

    public Object getDefaultFunctionProvider() {
        return this.psrBuffer.getFunctionProvider();
    }

    public void setDefaultFunctionProvider(Object functionProvider) {
        this.psrBuffer.setDefaultFunctionProvider(functionProvider);
    }

    public boolean calculate(String name, String formula, Variant rvarResult) {
        this.add(name, formula);
        this.calcQueue();
        rvarResult.setObject(null);
        IElement ie = this.get(name);
        if (ie != null) {
            rvarResult.setVariant(ie.getData());
        }
        return ie != null && !rvarResult.isNull();
    }

    public boolean isCalculateThrough() {
        return this.calculateThrough;
    }

    public void setCalculateThrough(boolean calculateThrough) {
        this.calculateThrough = calculateThrough;
    }

    private void createDependent(IElement refer, IElement referenced) {
        Object objList = this.deps.get(referenced);
        if (objList == null) {
            objList = new ArrayList(2);
            this.deps.put(referenced, objList);
        }
        ArrayList list = (ArrayList)objList;
        if (this.calculateThrough) {
            if (!list.contains(refer)) {
                list.add(refer);
            }
        } else {
            list.add(refer);
        }
    }

    public int size() {
        return this.deps.size();
    }

    public IElement get(Object name) {
        Object obj = this.elements.get(name);
        return obj == null ? null : (IElement)obj;
    }

    public void queueElement(IElement eStart) {
        if (this.calculateThrough) {
            this.increaseCalcID();
        }
        if (!eStart.isNeedCalc(this.calcID) || eStart.isQueued()) {
            return;
        }
        this.calcList.add(eStart);
        eStart.setQueued(true);
        int iStart = this.calcList.size();
        Object depList = this.deps.get(eStart);
        block0: while (true) {
            if (depList != null) {
                ArrayList list = (ArrayList)depList;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    IElement e = (IElement)list.get(i);
                    e.setNeedCalc(true);
                    this.calcList.add(e);
                    e.setQueued(true);
                }
            }
            this.deps.remove(eStart);
            while (iStart < this.calcList.size()) {
                eStart = (IElement)this.calcList.get(iStart);
                depList = this.deps.get(eStart);
                if (depList != null) continue block0;
                ++iStart;
            }
            if (depList == null) break;
        }
    }

    public void recalcAll() {
        this.deps.clear();
        assert (this.cycCheck.size() == 0);
        this.calcList.clear();
        for (Map.Entry e : this.elements.entrySet()) {
            IElement ie = (IElement)e.getValue();
            ie.setNeedCalc(true);
            this.calcList.add(ie);
            ie.setQueued(true);
        }
        this.calcQueue();
    }

    public void calcQueue() {
        assert (this.callStack.size() == 0);
        assert (this.cycCheck.size() == 0);
        if (this.calculateThrough) {
            this.increaseCalcID();
        }
        int i = 0;
        while (i < this.calcList.size()) {
            try {
                IElement ie = (IElement)this.calcList.get(i);
                if (ie.isNeedCalc(this.calcID)) {
                    this.calcElement(ie);
                }
                assert (this.callStack.size() == 0);
                this.cycCheck.clear();
                ++i;
            }
            catch (StackOverflowError e) {
                Object[] ao = this.callStack.toArray();
                for (int j = 0; j < ao.length; ++j) {
                    this.calcList.add(i, ao[j]);
                }
                this.callStack.clear();
            }
        }
        this.calcList.clear();
    }

    private int increaseCalcID() {
        ++this.calcID;
        if (this.calcID == Integer.MAX_VALUE) {
            this.calcID = -2147483647;
        }
        return this.calcID;
    }

    private void calcElement(IElement ie) {
        if (ie.isNeedCalc(this.calcID)) {
            this.callStack.push(ie);
            if (!this.cycCheck.contains(ie)) {
                this.cycCheck.push(ie);
            }
            ie.setQueued(false);
            Parser psr = this.psrBuffer.getParser(ie);
            ie.setData(psr.parse());
            this.psrBuffer.releaseParser(ie);
            ie.setCalcID(this.calcID);
            this.cycCheck.pop();
            this.callStack.pop();
        }
    }

    private Variant objectRef(IElement refer, IElement referenced) throws SyntaxErrorException {
        try {
            this.createDependent(refer, referenced);
            if (this.cycCheck.contains(referenced)) {
                ArrayList<String> al = new ArrayList<String>();
                Object[] ao = this.cycCheck.getStack().toArray();
                for (int i = 0; i < ao.length; ++i) {
                    IElement id = (IElement)ao[i];
                    al.add(id.getKey().toString() + "=" + id.getFormula());
                }
                ExprError.goError(32768L, al);
            }
            if (this.callStack.size() >= 100) {
                throw new StackOverflowError();
            }
            if (referenced.isNeedCalc(this.calcID)) {
                this.calcElement(referenced);
            }
        }
        catch (SyntaxErrorException e) {
            referenced.setData(new Variant(e));
            throw e;
        }
        return referenced.getData();
    }

    class DepParserHelper
    implements ParserHelperListener {
        DepParserHelper() {
        }

        @Override
        public long parseToken(Parser psr) throws SyntaxErrorException {
            if (Dependents.this.elements.containsKey(psr.getCurrentWord())) {
                return 0x100000000000000L;
            }
            return 0x400000000L;
        }

        @Override
        public void parseID(Parser psr, String id, Variant rvarResult) throws SyntaxErrorException {
            Object obj = Dependents.this.elements.get(id);
            if (obj != null && !Dependents.this.calculateThrough) {
                IElement referenced = (IElement)obj;
                Dependents.this.objectRef((IElement)psr.getOwner(), referenced);
                rvarResult.setVariant(referenced.getData());
            } else {
                if (Dependents.this.varListener != null) {
                    Variant varFormula = Variant.getNewEmptyVariant();
                    Variant varRlt = Variant.getNewEmptyVariant();
                    if (Dependents.this.varListener.queryVariable(psr, id, varFormula, varRlt)) {
                        if (!varRlt.isEmpty()) {
                            rvarResult.setVariant(varRlt);
                            return;
                        }
                        String formula = varFormula.toString();
                        if (formula.length() > 0) {
                            Element referenced = new Element(id, formula);
                            Dependents.this.elements.put(referenced.getKey(), referenced);
                            Dependents.this.objectRef((IElement)psr.getOwner(), referenced);
                            rvarResult.setVariant(referenced.getData());
                            return;
                        }
                    }
                }
                ExprError.goError(512L, id);
            }
        }

        @Override
        public Variant getObjectInstance(Parser psr, String name) throws SyntaxErrorException {
            Variant varObject = new Variant();
            if (Dependents.this.varListener != null) {
                if (Dependents.this.varListener.queryObjectInstance(psr, name, varObject) && varObject.getValue() != null) {
                    return varObject;
                }
                ExprError.goError(512L, "Cannt create " + name);
            }
            ExprError.goError(512L, name);
            return varObject;
        }

        @Override
        public boolean queryCell(Parser psr, RelationsListener listener, int row, int col, Variant rvarResult) throws SyntaxErrorException {
            ExprError.goError(512L, "Cell");
            return false;
        }

        @Override
        public String getMethodName(String methodName) {
            return methodName;
        }

        @Override
        public void processExt(Parser psr, Variant rvarResult) throws SyntaxErrorException {
            ExprError.goError(1L, "Not Implement.");
        }

        @Override
        public boolean externalMethod(Parser psr, String funcName, ArrayList params, Variant rvarResult) throws SyntaxErrorException {
            if (Dependents.this.varListener != null) {
                return Dependents.this.varListener.externalMethod(psr, funcName, params, rvarResult);
            }
            return false;
        }
    }
}

