/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.expr;

import com.kingdee.cosmic.ctrl.kdf.expr.IElement;
import com.kingdee.cosmic.ctrl.kdf.expr.Parser;
import com.kingdee.cosmic.ctrl.kdf.expr.ParserHelperListener;
import java.util.ArrayList;

class ParserBuffer {
    private ArrayList parsers;
    private int pos;
    private ParserHelperListener parserHelperListener;
    private Object functionProvider;

    public ParserBuffer(ParserHelperListener parserHelperListener) {
        this.parserHelperListener = parserHelperListener;
        this.parsers = new ArrayList();
        Parser psr = new Parser(null, null);
        psr.addParserHelperListener(parserHelperListener);
        this.parsers.add(psr);
        this.pos = this.parsers.size() - 1;
    }

    public Parser getParser(IElement ie) {
        assert (ie != null);
        Parser psr = null;
        if (this.pos >= this.parsers.size()) {
            psr = new Parser(ie, ie.getFormula());
            psr.addParserHelperListener(this.parserHelperListener);
            psr.setDefaultFunctionProvider(this.functionProvider);
            this.parsers.add(psr);
            this.pos = this.parsers.size();
        } else {
            Object obj = this.parsers.get(this.pos);
            ++this.pos;
            assert (obj instanceof Parser);
            psr = (Parser)obj;
            if (psr.getDefaultFunctionProvider() != this.functionProvider) {
                psr.setDefaultFunctionProvider(this.functionProvider);
            }
            psr.prepare(ie, ie.getFormula());
        }
        return psr;
    }

    public boolean releaseParser(IElement ie) {
        assert (ie != null);
        this.pos = Math.max(0, this.pos - 1);
        Parser psr = (Parser)this.parsers.get(this.pos);
        boolean ret = psr.getOwner() == ie;
        psr.prepare(null, null);
        return ret;
    }

    public Object getFunctionProvider() {
        return this.functionProvider;
    }

    public void setDefaultFunctionProvider(Object functionProvider) {
        this.functionProvider = functionProvider;
        for (int i = this.parsers.size() - 1; i >= 0; --i) {
            ((Parser)this.parsers.get(i)).setDefaultFunctionProvider(functionProvider);
        }
    }
}

