/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.expr;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class TimeSpan
implements Comparable {
    public static final long TicksPerMillisecond = 10000L;
    public static final long TicksPerSecond = 10000000L;
    public static final long TicksPerMinute = 600000000L;
    public static final long TicksPerHour = 36000000000L;
    public static final long TicksPerDay = 864000000000L;
    private static final int MillisPerSecond = 1000;
    private static final int MillisPerMinute = 60000;
    private static final int MillisPerHour = 3600000;
    private static final int MillisPerDay = 86400000;
    private static final long MaxSeconds = 922337203685L;
    private static final long MinSeconds = -922337203685L;
    private static final long MaxMilliSeconds = 922337203685477L;
    private static final long MinMilliSeconds = -922337203685477L;
    public static final TimeSpan Zero = new TimeSpan(0L);
    public static final TimeSpan MaxValue = new TimeSpan(Long.MAX_VALUE);
    public static final TimeSpan MinValue = new TimeSpan(Long.MIN_VALUE);
    long _ticks;

    public TimeSpan(long ticks) {
        this._ticks = ticks;
    }

    public TimeSpan(int hours, int minutes, int seconds) {
        this._ticks = TimeSpan.timeToTicks(hours, minutes, seconds);
    }

    public TimeSpan(int days, int hours, int minutes, int seconds) {
        this(days, hours, minutes, seconds, 0);
    }

    public TimeSpan(int days, int hours, int minutes, int seconds, int milliseconds) {
        BigDecimal totalMilliSeconds = BigDecimal.valueOf((double)days * 3600.0 * 24.0);
        totalMilliSeconds = totalMilliSeconds.add(BigDecimal.valueOf((double)hours * 3600.0 + (double)(minutes * 60) + (double)seconds));
        totalMilliSeconds = totalMilliSeconds.multiply(BigDecimal.valueOf(1000.0));
        totalMilliSeconds = totalMilliSeconds.add(BigDecimal.valueOf((double)milliseconds));
        if (totalMilliSeconds.compareTo(BigDecimal.valueOf(9.22337203685477E14)) > 0 || totalMilliSeconds.compareTo(BigDecimal.valueOf(-9.22337203685477E14)) < 0) {
            throw new ArithmeticException("Overflow_TimeSpanTooLong");
        }
        this._ticks = totalMilliSeconds.longValue() * 10000L;
    }

    public long getTicks() {
        return this._ticks;
    }

    public int getDays() {
        return (int)(this._ticks / 864000000000L);
    }

    public int getHours() {
        return (int)(this._ticks / 36000000000L % 24L);
    }

    public int getMilliseconds() {
        return (int)(this._ticks / 10000L % 1000L);
    }

    public int getMinutes() {
        return (int)(this._ticks / 600000000L % 60L);
    }

    public int getSeconds() {
        return (int)(this._ticks / 10000000L % 60L);
    }

    public double getTotalDays() {
        return (double)this._ticks / 8.64E11;
    }

    public double getTotalHours() {
        return (double)this._ticks / 3.6E10;
    }

    public double getTotalMilliseconds() {
        double temp = (double)this._ticks / 10000.0;
        if (temp > 9.22337203685477E14) {
            return 9.22337203685477E14;
        }
        if (temp < -9.22337203685477E14) {
            return -9.22337203685477E14;
        }
        return temp;
    }

    public double getTotalMinutes() {
        return (double)this._ticks / 6.0E8;
    }

    public double getTotalSeconds() {
        return (double)this._ticks / 1.0E7;
    }

    public TimeSpan add(TimeSpan ts) {
        long result = this._ticks + ts._ticks;
        if (this._ticks >> 63 == ts._ticks >> 63 && this._ticks >> 63 != result >> 63) {
            throw new ArithmeticException("Overflow_TimeSpanTooLong");
        }
        return new TimeSpan(result);
    }

    public static int compare(TimeSpan t1, TimeSpan t2) {
        if (t1._ticks > t2._ticks) {
            return 1;
        }
        if (t1._ticks < t2._ticks) {
            return -1;
        }
        return 0;
    }

    public int compareTo(Object value) {
        if (value == null) {
            return 1;
        }
        if (!(value instanceof TimeSpan)) {
            throw new ArithmeticException("Arg_MustBeTimeSpan");
        }
        long t = ((TimeSpan)value)._ticks;
        if (this._ticks > t) {
            return 1;
        }
        if (this._ticks < t) {
            return -1;
        }
        return 0;
    }

    public static TimeSpan fromDays(double value) {
        return TimeSpan.interval(value, 86400000);
    }

    public TimeSpan duration() {
        if (this._ticks == TimeSpan.MinValue._ticks) {
            throw new ArithmeticException("Overflow_NegateTwosCompNum");
        }
        return new TimeSpan(this._ticks >= 0L ? this._ticks : -this._ticks);
    }

    public boolean equals(Object value) {
        if (value instanceof TimeSpan) {
            return this._ticks == ((TimeSpan)value)._ticks;
        }
        return false;
    }

    public static boolean equals(TimeSpan t1, TimeSpan t2) {
        return t1._ticks == t2._ticks;
    }

    public int hashCode() {
        return (int)this._ticks ^ (int)(this._ticks >> 32);
    }

    public static TimeSpan fromHours(double value) {
        return TimeSpan.interval(value, 3600000);
    }

    private static TimeSpan interval(double value, int scale) {
        if (Double.isNaN(value)) {
            throw new ArithmeticException("Arg_CannotBeNaN");
        }
        double tmp = value * (double)scale;
        long millis = (long)(tmp + (value >= 0.0 ? 0.5 : -0.5));
        if (millis > 922337203685477L || millis < -922337203685477L || tmp < 0.0 && value > 0.0 || tmp > 0.0 && value < 0.0) {
            throw new ArithmeticException("Overflow_TimeSpanTooLong");
        }
        return new TimeSpan(millis * 10000L);
    }

    public static TimeSpan fromMilliseconds(double value) {
        return TimeSpan.interval(value, 1);
    }

    public static TimeSpan fromMinutes(double value) {
        return TimeSpan.interval(value, 60000);
    }

    public TimeSpan negate() {
        if (this._ticks == TimeSpan.MinValue._ticks) {
            throw new ArithmeticException("Overflow_NegateTwosCompNum");
        }
        return new TimeSpan(-this._ticks);
    }

    public static TimeSpan fromSeconds(double value) {
        return TimeSpan.interval(value, 1000);
    }

    public TimeSpan subtract(TimeSpan ts) {
        long result = this._ticks - ts._ticks;
        if (this._ticks >> 63 != ts._ticks >> 63 && this._ticks >> 63 != result >> 63) {
            throw new ArithmeticException("Overflow_TimeSpanTooLong");
        }
        return new TimeSpan(result);
    }

    public static TimeSpan fromTicks(long value) {
        return new TimeSpan(value);
    }

    static long timeToTicks(int hour, int minute, int second) {
        long totalSeconds = (long)hour * 3600L + (long)minute * 60L + (long)second;
        if (totalSeconds > 922337203685L || totalSeconds < -922337203685L) {
            throw new ArithmeticException("Overflow_TimeSpanTooLong");
        }
        return totalSeconds * 10000000L;
    }

    private String intToString(int n, int digits) {
        DecimalFormat df = new DecimalFormat();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < digits; ++i) {
            sb.append('0');
        }
        df.applyPattern(sb.toString());
        return df.format(n);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int day = (int)(this._ticks / 864000000000L);
        long time = this._ticks % 864000000000L;
        if (this._ticks < 0L) {
            sb.append('-');
            day = -day;
            time = -time;
        }
        if (day != 0) {
            sb.append(day);
            sb.append('.');
        }
        sb.append(this.intToString((int)(time / 36000000000L % 24L), 2));
        sb.append(':');
        sb.append(this.intToString((int)(time / 600000000L % 60L), 2));
        sb.append(':');
        sb.append(this.intToString((int)(time / 10000000L % 60L), 2));
        int t = (int)(time % 10000000L);
        if (t != 0) {
            sb.append('.');
            sb.append(this.intToString(t, 7));
        }
        return sb.toString();
    }
}

