/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.expr;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.kdf.expr.ExprError;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.VarBase;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import java.math.BigDecimal;

class VarBigDecimal
extends VarBase {
    VarBigDecimal() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch ((byte)right.getVt()) {
                case 14: 
                case 16: 
                case 17: {
                    ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
                    return;
                }
            }
            result.setObject(((BigDecimal)left.getValue()).add(right.toBigDecimal()), 10);
            return;
        }
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch ((byte)right.getVt()) {
                case 14: 
                case 16: 
                case 17: {
                    ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
                    return;
                }
            }
            result.setObject(((BigDecimal)left.getValue()).subtract(right.toBigDecimal()), 10);
            return;
        }
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch ((byte)right.getVt()) {
                case 14: 
                case 16: 
                case 17: {
                    ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
                    return;
                }
            }
            result.setObject(((BigDecimal)left.getValue()).multiply(right.toBigDecimal()), 10);
            return;
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch ((byte)right.getVt()) {
                case 14: 
                case 16: 
                case 17: {
                    ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
                    return;
                }
            }
            BigDecimal r = right.toBigDecimal();
            if (r.compareTo(BigDecimal.valueOf(0L)) == 0) {
                ExprError.goError(2L, CtrlCommonMessages.getMLS("divisionByZero", "\u9664\u6570\u4e3a\u96f6"));
            }
            BigDecimal l = (BigDecimal)left.getValue();
            result.setObject(l.divide(r, 10, 4), 10);
            return;
        }
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation2", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
    }
}

