/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.expr;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.kdf.expr.ExprError;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.Util;
import com.kingdee.cosmic.ctrl.kdf.expr.VarBase;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;

class VarBoolean
extends VarBase {
    VarBoolean() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        int leftval = Util.booleanToInt((Boolean)left.getValue());
        if (right.getVt() < 512) {
            boolean rightval = right.getVt() == 8 ? ((Boolean)right.getValue()).booleanValue() : right.booleanValue();
            result.setInt(leftval + Util.booleanToInt(rightval));
        }
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        int leftval = Util.booleanToInt((Boolean)left.getValue());
        if (right.getVt() < 512) {
            boolean rightval = right.getVt() == 8 ? ((Boolean)right.getValue()).booleanValue() : right.booleanValue();
            result.setInt(leftval - Util.booleanToInt(rightval));
        }
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        int leftval = Util.booleanToInt((Boolean)left.getValue());
        if (right.getVt() < 512) {
            boolean rightval = right.getVt() == 8 ? ((Boolean)right.getValue()).booleanValue() : right.booleanValue();
            result.setInt(leftval * Util.booleanToInt(rightval));
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        int leftval = Util.booleanToInt((Boolean)left.getValue());
        if (right.getVt() < 512) {
            int rightval = right.getVt() == 8 ? Util.booleanToInt((Boolean)right.getValue()) : Util.booleanToInt(right.booleanValue());
            if (rightval != 0) {
                result.setInt(leftval / rightval);
            } else {
                ExprError.goError(2L, CtrlCommonMessages.getMLS("divisionByZero", "\u9664\u6570\u4e3a\u96f6"));
            }
        }
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        int leftval = Util.booleanToInt((Boolean)left.getValue());
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.mod(leftval, ((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.mod(leftval, rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)right.getValue()).mod(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 10: {
                    Util.mod((double)leftval, right.doubleValue(), result);
                    break;
                }
                case 11: {
                    Variant vright = new Variant();
                    if (right.isNumeric(vright)) {
                        this.mod(left, vright, result);
                        break;
                    }
                    ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
                    break;
                }
                case 12: {
                    Util.mod((long)leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.mod((long)leftval, ((Calendar)right.getValue()).getTimeInMillis(), result);
                    break;
                }
                case 15: {
                    left.mod((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprError.goError(64L, CtrlCommonMessages.getMLS("unsupportedDataTypeOperation", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
                }
            }
        }
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        boolean leftval = (Boolean)left.getValue();
        if (right.getVt() < 512) {
            boolean rightval = right.getVt() == 8 ? ((Boolean)right.getValue()).booleanValue() : right.booleanValue();
            result.setBoolean(leftval & rightval);
        }
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        boolean leftval = (Boolean)left.getValue();
        if (right.getVt() < 512) {
            boolean rightval = right.getVt() == 8 ? ((Boolean)right.getValue()).booleanValue() : right.booleanValue();
            result.setBoolean(leftval | rightval);
        }
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        boolean leftval = (Boolean)left.getValue();
        if (right.getVt() < 512) {
            boolean rightval = right.getVt() == 8 ? ((Boolean)right.getValue()).booleanValue() : right.booleanValue();
            result.setBoolean(leftval ^ rightval);
        }
    }
}

