/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.formatter;

import com.kingdee.cosmic.ctrl.kdf.formatter.NumberResource;
import com.kingdee.cosmic.ctrl.kdf.formatter.PRCChineseBigNumberResource;
import com.kingdee.cosmic.ctrl.kdf.formatter.PRCChineseNumberResource;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberTranslate {
    private boolean langHabit = false;
    private static final String NULL_STRING = new String(new char[0]);
    private NumberResource resource;

    public static void main(String[] args) {
        NumberTranslate nt = new NumberTranslate(PRCChineseBigNumberResource.getInstance());
        System.out.println(nt.toNumber("2300000020"));
    }

    public NumberTranslate(NumberResource resource) {
        this.resource = resource;
    }

    public void setNumberResource(NumberResource resource) {
        this.resource = resource;
    }

    public boolean isLangHabit() {
        return this.langHabit;
    }

    public void setLangHabit(boolean langHabit) {
        this.langHabit = langHabit;
    }

    public String toDirect(BigInteger source) {
        char[] src = source.toString().toCharArray();
        for (int i = 0; i < src.length; ++i) {
            if (src[i] < '0' || src[i] > '9') continue;
            int idx = Character.digit(src[i], 10);
            src[i] = this.resource.getNumber(idx);
        }
        return new String(src);
    }

    public String toDirect(String source) {
        if (source == null || source.length() == 0) {
            return NULL_STRING;
        }
        char[] src = source.toCharArray();
        for (int i = 0; i < src.length; ++i) {
            if (src[i] < '0' || src[i] > '9') continue;
            int idx = Character.digit(src[i], 10);
            src[i] = this.resource.getNumber(idx);
        }
        return new String(src);
    }

    private String trans(String source, boolean needZero) {
        if (source == null || source.length() == 0) {
            return NULL_STRING;
        }
        StringBuilder result = new StringBuilder(NULL_STRING);
        char[] src = source.toCharArray();
        int len = src.length;
        int count = 0;
        char zero = this.resource.getNumber(0);
        if ("0".equals(source)) {
            return String.valueOf(zero);
        }
        for (int i = 0; i < len; ++i) {
            int val = Character.digit(src[i], 10);
            if (val == -1) continue;
            if (val == 0) {
                ++count;
                continue;
            }
            if (count > 0 || i == 0 && needZero) {
                result.append(zero);
                count = 0;
            }
            if (i != 0 || val != 1 || !this.isLangHabit() || len - 1 - i != 1) {
                result.append(this.resource.getNumber(val));
            }
            result.append(this.resource.getUnit(len - 1 - i));
        }
        return result.toString().trim();
    }

    private String trans(String source) {
        if (source == null || source.length() == 0) {
            return NULL_STRING;
        }
        StringBuilder result = new StringBuilder(NULL_STRING);
        char[] src = source.toCharArray();
        int len = src.length;
        int count = 0;
        char zero = this.resource.getNumber(0);
        if ("0".equals(source)) {
            return String.valueOf(zero);
        }
        for (int i = 0; i < len; ++i) {
            int val = Character.digit(src[i], 10);
            if (val == -1) continue;
            if (val == 0) {
                ++count;
                continue;
            }
            if (count > 0) {
                result.append(zero);
                count = 0;
            }
            if (i != 0 || val != 1 || !this.isLangHabit() || len - 1 - i != 1) {
                result.append(this.resource.getNumber(val));
            }
            result.append(this.resource.getUnit(len - 1 - i));
        }
        return result.toString().trim();
    }

    public String toNumber(String intValue) {
        String str;
        int decimalIndex = intValue.indexOf(46);
        if (decimalIndex == -1) {
            decimalIndex = intValue.indexOf(45);
        }
        if (decimalIndex != -1) {
            try {
                return this.toNumber(new BigDecimal(intValue));
            }
            catch (NumberFormatException nfe) {
                return intValue;
            }
        }
        int len = intValue.length();
        String[] ge = new String[]{intValue.substring(Math.max(0, len - 4), len), intValue.substring(Math.max(0, len - 8), Math.max(0, len - 4)), intValue.substring(Math.max(0, len - 12), Math.max(0, len - 8)), intValue.substring(0, Math.max(0, len - 12))};
        StringBuilder sb = new StringBuilder((int)((double)len * 1.5));
        boolean needZero = false;
        if (ge[3] != null && ge[3].length() > 0) {
            if (ge[3].length() > 4) {
                sb.append(this.toDirect(ge[3])).append(this.resource.getGroup(3));
            } else {
                str = this.trans(ge[3]);
                if (str != null && str.length() > 0) {
                    sb.append(str).append(this.resource.getGroup(3));
                }
            }
        }
        if (ge[2] != null && ge[2].length() > 0 && (str = this.trans(ge[2], needZero)) != null && str.length() > 0) {
            sb.append(str).append(this.resource.getGroup(2));
        }
        if (ge[1] != null && ge[1].length() > 0 && (str = this.trans(ge[1], needZero)) != null && str.length() > 0) {
            sb.append(str).append(this.resource.getGroup(1));
        }
        if (ge[0] != null && ge[0].length() > 0 && (str = this.trans(ge[0], needZero)) != null && str.length() > 0) {
            sb.append(str);
        }
        return sb.toString();
    }

    public String toNumber(BigDecimal source) {
        String str;
        int len;
        String[] ge;
        StringBuilder sb = new StringBuilder((int)((double)source.toString().length() * 1.5));
        BigInteger val = source.toBigInteger();
        String src1 = val.toString();
        String src2 = source.subtract(new BigDecimal(val)).toString();
        if (source.compareTo(BigDecimal.valueOf(0.0)) < 0) {
            char minus;
            if (this.resource instanceof PRCChineseNumberResource) {
                minus = ((PRCChineseNumberResource)this.resource).getMinus();
                sb.append(minus);
            } else if (this.resource instanceof PRCChineseBigNumberResource) {
                minus = ((PRCChineseBigNumberResource)this.resource).getMinus();
                sb.append(minus);
            }
            if (!"0".equals(src1)) {
                src1 = src1.substring(1);
            }
            src2 = src2.substring(1);
        }
        if ((ge = new String[]{src1.substring(Math.max(0, (len = src1.length()) - 4), len), src1.substring(Math.max(0, len - 8), Math.max(0, len - 4)), src1.substring(Math.max(0, len - 12), Math.max(0, len - 8)), src1.substring(0, Math.max(0, len - 12))})[3] != null && ge[3].length() > 0) {
            if (ge[3].length() > 4) {
                sb.append(this.toDirect(ge[3])).append(this.resource.getGroup(3));
            } else {
                str = this.trans(ge[3]);
                if (str != null && str.length() > 0) {
                    sb.append(str).append(this.resource.getGroup(3));
                }
            }
        }
        if (ge[2] != null && ge[2].length() > 0 && (str = this.trans(ge[2])) != null && str.length() > 0) {
            sb.append(str).append(this.resource.getGroup(2));
        }
        if (ge[1] != null && ge[1].length() > 0 && (str = this.trans(ge[1])) != null && str.length() > 0) {
            sb.append(str).append(this.resource.getGroup(1));
        }
        if (ge[0] != null && ge[0].length() > 0 && (str = this.trans(ge[0])) != null && str.length() > 0) {
            sb.append(str);
        }
        if (src2 != null && src2.length() > 2) {
            sb.append(this.resource.getPoint()).append(this.toDirect(src2.substring(2, src2.length())));
        }
        return sb.toString();
    }
}

