/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.formatter;

import com.kingdee.cosmic.ctrl.kdf.formatter.NumberTransEnglish;
import com.kingdee.cosmic.ctrl.kdf.formatter.NumberTranslate;
import com.kingdee.cosmic.ctrl.kdf.formatter.PRCChineseBigNumberResource;
import com.kingdee.cosmic.ctrl.kdf.formatter.PRCChineseNumberResource;
import com.kingdee.cosmic.ctrl.kdf.formatter.TraditionaryChineseBigNumberResource;
import com.kingdee.cosmic.ctrl.kdf.formatter.TraditionaryChineseNumberResource;
import java.math.BigDecimal;
import java.util.Locale;

public class StringFormatter {
    private StringFormatter() {
    }

    public static final String toPlural(String source) {
        if (source == null || source.length() == 0 || source.trim().length() == 0) {
            return source;
        }
        return source + "s";
    }

    public static final String toUpperCaseFirst(String source) {
        if (source == null || source.length() == 0) {
            return source;
        }
        StringBuilder sb = new StringBuilder(source.length());
        return sb.append(source.substring(0, 1).toUpperCase()).append(source.substring(1, source.length())).toString();
    }

    public static final String toUpperCase(String source) {
        if (source == null || source.length() == 0) {
            return source;
        }
        return source.toUpperCase(Locale.ENGLISH);
    }

    public static final String toUpperCase(String source, int start) {
        return StringFormatter.toUpperCase(source, start, source.length());
    }

    public static final String toUpperCase(String source, int start, int length) {
        if (source == null || source.length() == 0 || length <= 0 || start >= source.length()) {
            return source;
        }
        start = Math.max(start, 0);
        int end = Math.min(source.length(), start + length);
        StringBuilder sb = new StringBuilder(source.length());
        if (start == 0) {
            sb.append(source.substring(start, end).toUpperCase());
        } else {
            sb.append(source.substring(0, start)).append(source.substring(start, end).toUpperCase());
        }
        if (end < source.length()) {
            sb.append(source.substring(end, source.length()));
        }
        return sb.toString();
    }

    public static final String toLowerCaseFirst(String source) {
        StringBuilder sb = new StringBuilder(source.length());
        return sb.append(source.substring(0, 1).toLowerCase()).append(source.substring(1, source.length())).toString();
    }

    public static final String toLowerCase(String source) {
        if (source == null || source.length() == 0) {
            return source;
        }
        return source.toLowerCase(Locale.ENGLISH);
    }

    public static final String toLowerCase(String source, int start) {
        return StringFormatter.toLowerCase(source, start, source.length());
    }

    public static final String toLowerCase(String source, int start, int length) {
        if (source == null || source.length() == 0 || length <= 0 || start >= source.length()) {
            return source;
        }
        start = Math.max(start, 0);
        int end = Math.min(source.length(), start + length);
        StringBuilder sb = new StringBuilder(source.length());
        if (start == 0) {
            sb.append(source.substring(start, end).toLowerCase());
        } else {
            sb.append(source.substring(0, start)).append(source.substring(start, end).toLowerCase());
        }
        if (end < source.length()) {
            sb.append(source.substring(end, source.length()));
        }
        return sb.toString();
    }

    public static final String toSChineseUpperNumber(String source) {
        try {
            BigDecimal value = new BigDecimal(source);
            NumberTranslate trans = new NumberTranslate(PRCChineseBigNumberResource.getInstance());
            return trans.toNumber(value);
        }
        catch (NumberFormatException nfe) {
            return source;
        }
    }

    public static final String toSChineseLowerNumber(String source) {
        try {
            BigDecimal value = new BigDecimal(source);
            NumberTranslate trans = new NumberTranslate(PRCChineseNumberResource.getInstance());
            return trans.toNumber(value);
        }
        catch (NumberFormatException nfe) {
            return source;
        }
    }

    public static final String toTChineseUpperNumber(String source) {
        try {
            BigDecimal value = new BigDecimal(source);
            NumberTranslate trans = new NumberTranslate(TraditionaryChineseBigNumberResource.getInstance());
            return trans.toNumber(value);
        }
        catch (NumberFormatException nfe) {
            return source;
        }
    }

    public static final String toTChineseLowerNumber(String source) {
        try {
            BigDecimal value = new BigDecimal(source);
            NumberTranslate trans = new NumberTranslate(TraditionaryChineseNumberResource.getInstance());
            return trans.toNumber(value);
        }
        catch (NumberFormatException nfe) {
            return source;
        }
    }

    public static final String toEnglishNumber(String source) {
        try {
            return NumberTransEnglish.toEnglishNumber(source);
        }
        catch (NumberFormatException nfe) {
            return source;
        }
    }

    public static final String toEnglishNumber(String source, int type) {
        try {
            return NumberTransEnglish.toEnglishNumber(source, type);
        }
        catch (NumberFormatException nfe) {
            return source;
        }
    }
}

