/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.script.miniscript.exec;

import com.kingdee.cosmic.ctrl.script.miniscript.ScriptContext;
import com.kingdee.cosmic.ctrl.script.miniscript.ScriptResult;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.ICreateObjectListener;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.IDebugListener;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.ObjectIterator;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.OperationUtil;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.AdditiveExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.ArrayDim;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.ArrayInit;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.AssignOP;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.Break;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.ConditionOrExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.ConditionalAndExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.ConditionalExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.Continue;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.EqualityExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.ExclusiveOrExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.Exit;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.FifoStack;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.FuncallExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.Function;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.InclusiveAndExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.InclusiveOrExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.MultiplicativeExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.Null;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.PostfixExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.PreIncDecExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.RelactionalExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.Return;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.ScriptTypeObject;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.ShiftExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.SwitchCaseLabel;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.UnaryExp;
import com.kingdee.cosmic.ctrl.script.miniscript.exec.objs.Var;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.AdditiveExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.AllocationExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.AndExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ArgumentList;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.Arguments;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ArrayDimensions;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ArrayInitializer;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.Assignment;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.AssignmentOperator;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.Block;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.BooleanLiteral;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.BreakStatement;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.CharacterLiteral;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ConditionalAndExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ConditionalExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ConditionalOrExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ContinueStatement;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.EmptyStatement;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.EqualityExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ExclusiveOrExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ExitStatement;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.Expression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.FloatLiteral;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ForEachStatement;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ForInit;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ForStatement;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.IfStatement;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.InclusiveOrExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.IntegerLiteral;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.Literal;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.MiniScript;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.MultiplicativeExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.Node;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.NodeList;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.NodeListInterface;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.NodeListOptional;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.NodeOptional;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.NodeSequence;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.NodeToken;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.NullLiteral;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.PostfixExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.PreDecrementExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.PreIncrementExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.PrimaryExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.PrimaryPrefix;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.PrimarySuffix;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.PrimaryVariable;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.RelationalExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ReturnStatement;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ScriptType;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.ShiftExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.Statement;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.StatementExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.StringLiteral;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.SwitchLabel;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.SwitchStatement;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.UnaryExpression;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.UnaryExpressionNotPlusMinus;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.VariableDeclarator;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.VariableInitializer;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.WhileStatement1;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.WhileStatement2;
import com.kingdee.cosmic.ctrl.script.miniscript.parser.visitor.ObjectDepthFirst;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ExecutorVisitor
extends ObjectDepthFirst {
    private ScriptContext ctx;
    private ScriptResult res = null;
    private IDebugListener debugListener = null;
    private ICreateObjectListener createObjectListener = null;
    private boolean debug;
    private boolean oneStep = true;
    private int lastLine = -1;
    private NodeToken cuurentToken = null;

    public NodeToken getCurrentNodeToken() {
        return this.cuurentToken;
    }

    private void debugStop(NodeToken n) {
        this.cuurentToken = n;
        if (!this.debug) {
            return;
        }
        if (this.lastLine != n.beginLine) {
            this.lastLine = n.beginLine;
            this.outputVar(this.lastLine);
            if (this.debugListener != null) {
                this.debugListener.gotoLine(this.lastLine);
            }
            if (this.oneStep) {
                Thread.currentThread().suspend();
            }
        }
    }

    public void outputVar(int stopLine) {
        Map map = this.res.getVarMap();
        System.out.println("[\u65ad\u70b9]\u7b2c" + this.lastLine + "\u884c,\u5f53\u524d\u53d8\u91cf\u6570=" + map.size() + ":");
        for (Var key : map.keySet()) {
            key = key.getLinkHead();
            do {
                System.out.print("\t" + key.getLevel() + ":" + key.getName());
                System.out.println("=" + key.getValue());
            } while ((key = key.next()) != null);
        }
    }

    public ExecutorVisitor(ScriptContext ctx, boolean debug, int[] stopLines, IDebugListener debugListener, ICreateObjectListener createObjectListener) {
        this.ctx = ctx;
        this.debug = debug;
        this.debugListener = debugListener;
        this.createObjectListener = createObjectListener;
        this.oneStep = true;
        this.res = ctx.getScriptResult();
    }

    public void setOneOver(boolean oneStep) {
        this.oneStep = oneStep;
    }

    @Override
    public Object visit(NodeList n, Object argu) {
        return this.myVisit(n);
    }

    @Override
    public Object visit(NodeListOptional n, Object argu) {
        if (n.present()) {
            return this.myVisit(n);
        }
        return null;
    }

    @Override
    public Object visit(NodeOptional n, Object argu) {
        if (n.present()) {
            return n.node.accept(this, argu);
        }
        return null;
    }

    private FifoStack myVisit(NodeListInterface n) {
        Object _ret = null;
        FifoStack stack = new FifoStack();
        Enumeration e = n.elements();
        while (e.hasMoreElements()) {
            _ret = ((Node)e.nextElement()).accept(this, null);
            if (_ret == null) continue;
            if (_ret instanceof FifoStack) {
                FifoStack s = (FifoStack)_ret;
                boolean bbreak = false;
                while (s.size() > 0) {
                    Object obj = s.pop();
                    if (obj == Break.BREAK || obj == Exit.EXIT) {
                        stack.push(obj);
                        bbreak = true;
                        break;
                    }
                    if (obj instanceof Return) {
                        stack.push(((Return)obj).getValue());
                        bbreak = true;
                        break;
                    }
                    stack.push(obj);
                }
                if (!bbreak) continue;
                break;
            }
            if (_ret == Break.BREAK || _ret == Exit.EXIT) {
                stack.push(_ret);
                break;
            }
            if (_ret instanceof Return) {
                stack.push(((Return)_ret).getValue());
                break;
            }
            stack.push(_ret);
        }
        return stack;
    }

    @Override
    public Object visit(NodeSequence n, Object argu) {
        return this.myVisit(n);
    }

    @Override
    public Object visit(NodeToken n, Object argu) {
        this.debugStop(n);
        return n.tokenImage;
    }

    @Override
    public Object visit(MiniScript n, Object argu) {
        NodeListOptional list = n.nodeListOptional;
        Enumeration em = list.elements();
        while (em.hasMoreElements()) {
            Node node = (Node)em.nextElement();
            Object ret = node.accept(this, argu);
            if (ret == Exit.EXIT) {
                return ret;
            }
            if (!(ret instanceof Return)) continue;
            return ((Return)ret).getValue();
        }
        return null;
    }

    @Override
    public Object visit(Statement n, Object argu) {
        return n.nodeChoice.accept(this, argu);
    }

    @Override
    public Object visit(com.kingdee.cosmic.ctrl.script.miniscript.parser.syntaxtree.Function n, Object argu) {
        Function f = new Function(this);
        String name = (String)n.nodeToken1.accept(this, argu);
        f.setName(name);
        FifoStack stack = (FifoStack)n.nodeOptional.accept(this, argu);
        if (stack != null) {
            while (stack.size() > 0) {
                f.addParamName((String)stack.pop());
                if (stack.size() <= 0) break;
                stack.pop();
            }
        }
        f.setStatements(n.nodeListOptional);
        this.res.defineFunction(f);
        return f;
    }

    @Override
    public Object visit(VariableDeclarator n, Object argu) {
        ScriptResult res = this.ctx.getScriptResult();
        String name = (String)n.nodeToken1.accept(this, argu);
        Var var = new Var(name, this.ctx.getLevel());
        var.setMatchLevel(true);
        FifoStack stack = (FifoStack)n.nodeOptional.accept(this, argu);
        if (stack == null) {
            res.setVar(var, null);
            return null;
        }
        stack.pop();
        Object v = stack.pop();
        res.setVar(var, v);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visit(Block n, Object argu) {
        try {
            this.ctx.incLevel();
            NodeListOptional list = n.nodeListOptional;
            Enumeration em = list.elements();
            while (em.hasMoreElements()) {
                Node node = (Node)em.nextElement();
                Object ret = node.accept(this, argu);
                if (ret == Continue.CONTINUE || ret == Exit.EXIT || ret == Break.BREAK) {
                    Object object = ret;
                    return object;
                }
                if (!(ret instanceof Return)) continue;
                Object object = ((Return)ret).getValue();
                return object;
            }
        }
        finally {
            this.ctx.decLevel();
        }
        return null;
    }

    @Override
    public Object visit(EmptyStatement n, Object argu) {
        return null;
    }

    @Override
    public Object visit(IfStatement n, Object argu) {
        Boolean b;
        Object obj = n.expression.accept(this, argu);
        if (obj instanceof Var) {
            obj = this.res.getVar((Var)obj);
        }
        if ((b = (Boolean)obj).booleanValue()) {
            n.statement.accept(this, argu);
        } else {
            n.nodeOptional1.accept(this, argu);
        }
        return null;
    }

    @Override
    public Object visit(ForStatement n, Object argu) {
        this.ctx.incLevel();
        Object ret = n.nodeOptional.accept(this, argu);
        boolean b = (Boolean)n.expression.accept(this, argu);
        while (b) {
            this.ctx.incLevel();
            ret = n.statement.accept(this, argu);
            this.ctx.decLevel();
            if (ret == Break.BREAK || ret == Exit.EXIT) break;
            if (ret instanceof Return) {
                ret = ((Return)ret).getValue();
                break;
            }
            n.nodeOptional1.accept(this, argu);
            b = (Boolean)n.expression.accept(this, argu);
        }
        this.ctx.decLevel();
        return ret;
    }

    @Override
    public Object visit(ForInit n, Object argu) {
        Object ret = n.nodeChoice.accept(this, argu);
        FifoStack stack = (FifoStack)n.nodeListOptional.accept(this, argu);
        if (stack != null) {
            ret = stack.getList().getLast();
        }
        return ret;
    }

    @Override
    public Object visit(ForEachStatement n, Object argu) {
        this.ctx.incLevel();
        Object ret = null;
        Var var = new Var((String)n.nodeToken2.accept(this, argu), this.ctx.getLevel());
        var.setMatchLevel(true);
        this.res.setVar(var, var.getValue());
        Object cc = n.expression.accept(this, argu);
        if (cc != null) {
            if (cc instanceof Var) {
                cc = this.res.getVar((Var)cc);
            }
            Iterator iter = new ObjectIterator(cc).iterator();
            while (iter.hasNext()) {
                this.res.setVar(var, iter.next());
                ret = n.statement.accept(this, argu);
                if (ret == Break.BREAK || ret == Exit.EXIT) break;
                if (!(ret instanceof Return)) continue;
                ret = ((Return)ret).getValue();
                break;
            }
        }
        this.ctx.decLevel();
        return ret;
    }

    @Override
    public Object visit(WhileStatement1 n, Object argu) {
        Object ret = null;
        while (((Boolean)n.expression.accept(this, argu)).booleanValue()) {
            this.ctx.incLevel();
            ret = n.statement.accept(this, argu);
            this.ctx.decLevel();
            if (ret == Break.BREAK || ret == Exit.EXIT) break;
            if (!(ret instanceof Return)) continue;
            ret = ((Return)ret).getValue();
            break;
        }
        return ret;
    }

    @Override
    public Object visit(WhileStatement2 n, Object argu) {
        Object ret = null;
        do {
            this.ctx.incLevel();
            ret = n.statement.accept(this, argu);
            this.ctx.decLevel();
            if (ret == Break.BREAK || ret == Exit.EXIT) break;
            if (!(ret instanceof Return)) continue;
            ret = ((Return)ret).getValue();
            break;
        } while (((Boolean)n.expression.accept(this, argu)).booleanValue());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visit(SwitchStatement n, Object argu) {
        Object caseValue = n.expression.accept(this, argu);
        if (caseValue instanceof Var) {
            caseValue = this.res.getVar((Var)caseValue);
        }
        NodeListOptional list = n.nodeListOptional;
        Object ret = null;
        SwitchLabel label = null;
        NodeListOptional selectedLableStmt = null;
        boolean hasEnter = false;
        Enumeration em = list.elements();
        while (em.hasMoreElements()) {
            boolean b;
            NodeSequence node = (NodeSequence)em.nextElement();
            label = (SwitchLabel)node.elementAt(0);
            ret = label.accept(this, argu);
            if (ret == null) {
                selectedLableStmt = (NodeListOptional)node.elementAt(1);
                continue;
            }
            if (ret instanceof Var) {
                ret = this.res.getVar((Var)ret);
            }
            if (!(b = hasEnter || (Boolean)OperationUtil.op("==", caseValue, ret) != false)) continue;
            try {
                this.ctx.incLevel();
                hasEnter = true;
                selectedLableStmt = null;
                FifoStack r = (FifoStack)node.elementAt(1).accept(this, argu);
                if (r.size() != 1) continue;
                Object rr = r.pop();
                if (rr == Break.BREAK) {
                    Object object = ret;
                    return object;
                }
                if (rr == Exit.EXIT) {
                    Object object = rr;
                    return object;
                }
                if (!(ret instanceof Return)) continue;
                Object object = ((Return)ret).getValue();
                return object;
            }
            finally {
                this.ctx.decLevel();
            }
        }
        if (selectedLableStmt != null) {
            try {
                this.ctx.incLevel();
                Object object = selectedLableStmt.accept(this, argu);
                return object;
            }
            finally {
                this.ctx.decLevel();
            }
        }
        return null;
    }

    @Override
    public Object visit(SwitchLabel n, Object argu) {
        return new SwitchCaseLabel(null, (FifoStack)n.nodeChoice.accept(this, argu)).eval(this.res);
    }

    @Override
    public Object visit(BreakStatement n, Object argu) {
        return Break.BREAK;
    }

    @Override
    public Object visit(ReturnStatement n, Object argu) {
        return new Return(n.expression.accept(this, argu));
    }

    @Override
    public Object visit(ContinueStatement n, Object argu) {
        return Continue.CONTINUE;
    }

    @Override
    public Object visit(ExitStatement n, Object argu) {
        this.ctx.setLevel(0);
        return Exit.EXIT;
    }

    @Override
    public Object visit(StatementExpression n, Object argu) {
        return n.nodeChoice.accept(this, argu);
    }

    @Override
    public Object visit(Assignment n, Object argu) {
        Var var = (Var)n.primaryExpression.accept(this, argu);
        AssignOP op = (AssignOP)n.assignmentOperator.accept(this, argu);
        Object value = n.expression.accept(this, argu);
        return op.doAssign(var, value, this.res);
    }

    @Override
    public Object visit(PreIncrementExpression n, Object argu) {
        Object pre = n.nodeToken.accept(this, argu);
        FifoStack stack = new FifoStack();
        stack.push(pre);
        Object value = n.primaryExpression.accept(this, argu);
        return new PreIncDecExp(value, stack).eval(this.res);
    }

    @Override
    public Object visit(PreDecrementExpression n, Object argu) {
        Object pre = n.nodeToken.accept(this, argu);
        FifoStack stack = new FifoStack();
        stack.push(pre);
        Object value = n.primaryExpression.accept(this, argu);
        return new PreIncDecExp(value, stack).eval(this.res);
    }

    @Override
    public Object visit(PrimaryExpression n, Object argu) {
        Object obj = n.primaryPrefix.accept(this, argu);
        if (n.nodeListOptional.present()) {
            int c = 0;
            FifoStack stack = new FifoStack();
            Enumeration e = n.nodeListOptional.elements();
            while (e.hasMoreElements()) {
                PrimarySuffix ps = (PrimarySuffix)e.nextElement();
                ++c;
                FifoStack buf = (FifoStack)ps.accept(this, argu);
                stack.pushAll(buf);
            }
            obj = new FuncallExp(obj, stack, this.ctx.getVarRequestor()).eval(this.res);
        }
        return obj;
    }

    @Override
    public Object visit(PrimaryPrefix n, Object argu) {
        return n.nodeChoice.accept(this, argu);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object visit(PrimaryVariable n, Object argu) {
        FifoStack thisStack = (FifoStack)n.nodeOptional.accept(this, argu);
        boolean forceTopLevel = thisStack != null;
        int level = forceTopLevel ? 0 : this.ctx.getLevel();
        String name = (String)n.nodeToken.accept(this, argu);
        FifoStack v = (FifoStack)n.nodeOptional1.accept(this, argu);
        Var var = null;
        if (v != null) {
            v.pop();
            Object index = v.pop();
            if (index instanceof Var) {
                index = this.res.getVar((Var)index);
            }
            if (!(index instanceof Integer)) throw new RuntimeException("Array subscript must be integer type.");
            var = new Var(name, (Integer)index, level);
        } else {
            var = new Var(name, level);
        }
        var.setMatchLevel(forceTopLevel);
        return var;
    }

    @Override
    public Object visit(AllocationExpression n, Object argu) {
        ScriptTypeObject obj = new ScriptTypeObject(this.ctx, this.createObjectListener);
        obj.setTypeName((String)n.scriptType.accept(this, argu));
        obj.setArguments((FifoStack)n.nodeOptional.accept(this, argu));
        obj.setArrayDimensions((ArrayDim)n.nodeOptional1.accept(this, argu));
        return obj.createObject();
    }

    @Override
    public Object visit(ScriptType n, Object argu) {
        StringBuilder s = new StringBuilder();
        s.append(n.nodeToken.accept(this, argu));
        FifoStack stack = (FifoStack)n.nodeListOptional.accept(this, argu);
        if (stack != null) {
            while (stack.size() > 0) {
                s.append(stack.pop());
            }
        }
        return s.toString();
    }

    @Override
    public Object visit(ArrayDimensions n, Object argu) {
        return new ArrayDim((FifoStack)n.nodeChoice.accept(this, argu));
    }

    @Override
    public Object visit(ArrayInitializer n, Object argu) {
        ArrayInit ai = new ArrayInit((FifoStack)n.nodeListOptional.accept(this, argu));
        return ai;
    }

    @Override
    public Object visit(VariableInitializer n, Object argu) {
        return n.nodeChoice.accept(this, argu);
    }

    @Override
    public Object visit(PrimarySuffix n, Object argu) {
        return n.nodeChoice.accept(this, argu);
    }

    @Override
    public Object visit(Literal n, Object argu) {
        return n.nodeChoice.accept(this, argu);
    }

    @Override
    public Object visit(IntegerLiteral n, Object argu) {
        String s = (String)n.nodeToken.accept(this, argu);
        if (s.toUpperCase(Locale.ENGLISH).indexOf(76) != -1) {
            return Long.valueOf(s.substring(0, s.length() - 1));
        }
        return Integer.valueOf(s);
    }

    @Override
    public Object visit(FloatLiteral n, Object argu) {
        String s = (String)n.nodeToken.accept(this, argu);
        if (s.toUpperCase(Locale.ENGLISH).indexOf(68) != -1) {
            return new Double(s.substring(0, s.length() - 1));
        }
        return new Float(s);
    }

    @Override
    public Object visit(CharacterLiteral n, Object argu) {
        return Character.valueOf(((String)n.nodeToken.accept(this, argu)).charAt(1));
    }

    @Override
    public Object visit(StringLiteral n, Object argu) {
        String s = (String)n.nodeChoice.accept(this, argu);
        return s.substring(1, s.length() - 1).replaceAll("\\\\r", "\r").replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t").replaceAll("\\\\\"", "\"").replaceAll("\\\\'", "'").replaceAll("\\\\\\\\", "\\\\");
    }

    @Override
    public Object visit(BooleanLiteral n, Object argu) {
        String s = (String)n.nodeChoice.accept(this, argu);
        return Boolean.valueOf(s);
    }

    @Override
    public Object visit(NullLiteral n, Object argu) {
        return Null.NULL;
    }

    @Override
    public Object visit(Arguments n, Object argu) {
        return n.nodeChoice.accept(this, argu);
    }

    @Override
    public Object visit(ArgumentList n, Object argu) {
        return n.nodeSequence.accept(this, argu);
    }

    @Override
    public Object visit(AssignmentOperator n, Object argu) {
        return new AssignOP((String)n.nodeChoice.accept(this, argu));
    }

    @Override
    public Object visit(PostfixExpression n, Object argu) {
        Object _ret = n.primaryExpression.accept(this, argu);
        String op = (String)n.nodeOptional.accept(this, argu);
        FifoStack stack = null;
        if (op != null) {
            stack = new FifoStack();
            stack.push(op);
        }
        return new PostfixExp(_ret, stack).eval(this.res);
    }

    @Override
    public Object visit(Expression n, Object argu) {
        return n.nodeChoice.accept(this, argu);
    }

    @Override
    public Object visit(ConditionalExpression n, Object argu) {
        Object b = n.conditionalOrExpression.accept(this, argu);
        FifoStack stack = (FifoStack)n.nodeOptional.accept(this, argu);
        return new ConditionalExp(b, stack).eval(this.res);
    }

    @Override
    public Object visit(ConditionalOrExpression n, Object argu) {
        Object _ret = n.conditionalAndExpression.accept(this, argu);
        FifoStack stack = (FifoStack)n.nodeListOptional.accept(this, argu);
        return new ConditionOrExp(_ret, stack).eval(this.res);
    }

    @Override
    public Object visit(ConditionalAndExpression n, Object argu) {
        Object _ret = n.inclusiveOrExpression.accept(this, argu);
        FifoStack stack = (FifoStack)n.nodeListOptional.accept(this, argu);
        return new ConditionalAndExp(_ret, stack).eval(this.res);
    }

    @Override
    public Object visit(InclusiveOrExpression n, Object argu) {
        Object _ret = n.exclusiveOrExpression.accept(this, argu);
        FifoStack stack = (FifoStack)n.nodeListOptional.accept(this, argu);
        return new InclusiveOrExp(_ret, stack).eval(this.res);
    }

    @Override
    public Object visit(ExclusiveOrExpression n, Object argu) {
        Object _ret = n.andExpression.accept(this, argu);
        FifoStack stack = (FifoStack)n.nodeListOptional.accept(this, argu);
        return new ExclusiveOrExp(_ret, stack).eval(this.res);
    }

    @Override
    public Object visit(AndExpression n, Object argu) {
        Object _ret = n.equalityExpression.accept(this, argu);
        FifoStack stack = (FifoStack)n.nodeListOptional.accept(this, argu);
        return new InclusiveAndExp(_ret, stack).eval(this.res);
    }

    @Override
    public Object visit(EqualityExpression n, Object argu) {
        Object b = n.relationalExpression.accept(this, argu);
        FifoStack stack = (FifoStack)n.nodeListOptional.accept(this, argu);
        return new EqualityExp(b, stack).eval(this.res);
    }

    @Override
    public Object visit(RelationalExpression n, Object argu) {
        Object shift = n.shiftExpression.accept(this, argu);
        FifoStack stack = (FifoStack)n.nodeListOptional.accept(this, argu);
        return new RelactionalExp(shift, stack).eval(this.res);
    }

    @Override
    public Object visit(ShiftExpression n, Object argu) {
        Object _ret = n.additiveExpression.accept(this, argu);
        FifoStack stack = (FifoStack)n.nodeListOptional.accept(this, argu);
        return new ShiftExp(_ret, stack).eval(this.res);
    }

    @Override
    public Object visit(AdditiveExpression n, Object argu) {
        Object _ret = n.multiplicativeExpression.accept(this, argu);
        return new AdditiveExp(_ret, (FifoStack)n.nodeListOptional.accept(this, null)).eval(this.res);
    }

    @Override
    public Object visit(MultiplicativeExpression n, Object argu) {
        Object _ret = n.unaryExpression.accept(this, argu);
        return new MultiplicativeExp(_ret, (FifoStack)n.nodeListOptional.accept(this, null)).eval(this.res);
    }

    @Override
    public Object visit(UnaryExpression n, Object argu) {
        Object obj = n.nodeChoice.accept(this, argu);
        if (obj instanceof FifoStack) {
            obj = new UnaryExp(null, (FifoStack)obj).eval(this.res);
        }
        return obj;
    }

    @Override
    public Object visit(UnaryExpressionNotPlusMinus n, Object argu) {
        return n.nodeChoice.accept(this, argu);
    }
}

