/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.script.miniscript.exec;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectIterator {
    private static final EmptyItetator empty = new EmptyItetator();
    private Object cc;

    public ObjectIterator(Object value) {
        this.cc = value;
    }

    public Iterator iterator() {
        if (this.cc == null) {
            return empty;
        }
        if (this.cc.getClass().isArray()) {
            return new ArrayItetator(this.cc);
        }
        if (this.cc instanceof Collection) {
            return ((Collection)this.cc).iterator();
        }
        if (this.cc instanceof Enumeration) {
            return new EnumerationItetator((Enumeration)this.cc);
        }
        throw new RuntimeException(this.cc + " is not an array or collection type value!");
    }

    static class EmptyItetator
    implements Iterator {
        EmptyItetator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    }

    static class EnumerationItetator
    implements Iterator {
        private Enumeration v;

        public EnumerationItetator(Enumeration v) {
            this.v = v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.v.hasMoreElements();
        }

        public Object next() {
            return this.v.nextElement();
        }
    }

    static class ArrayItetator
    implements Iterator {
        private int len;
        private int i = 0;
        private Object v;

        public ArrayItetator(Object v) {
            this.v = v;
            this.len = Array.getLength(v);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.i < this.len;
        }

        public Object next() {
            return Array.get(this.v, this.i++);
        }
    }
}

