/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.print;

import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.preview.ButtonItem;
import com.kingdee.cosmic.ctrl.print.preview.PreviewBody;
import com.kingdee.cosmic.ctrl.print.preview.PreviewToolBar;
import com.kingdee.cosmic.ctrl.print.preview.PreviewWindow;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import com.kingdee.cosmic.ctrl.swing.ISimpleStatusBarRenderer;
import com.kingdee.cosmic.ctrl.swing.KDStatusBar;
import com.kingdee.cosmic.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.cosmic.ctrl.swing.SimpleStatusBarRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;

public class KDPreview {
    String previewTitle = null;
    private int windowType = 1;
    private boolean isCloseWhenPrint = true;
    private boolean isPrintDirect = false;
    private KDPrinter printer;
    private PreviewToolBar previewBar;
    private PreviewBody previewUI;
    private KDStatusBar statusBar;
    private PreviewWindow previewWindow;

    public KDPreview(KDPrinter printer) {
        this.printer = printer;
    }

    public void setStatus(String str) {
        this.getStatusBar().setRendererText(str, (Object)"first");
        this.getStatusBar().repaint();
    }

    public void setWindowType(int value) {
        this.windowType = value == 0 || value == 1 || value == 2 ? value : 2;
    }

    public PreviewToolBar getPreviewBar() {
        if (this.previewBar == null) {
            this.previewBar = new PreviewToolBar(this.getPreviewBody());
        }
        return this.previewBar;
    }

    public PreviewBody getPreviewBody() {
        if (this.previewUI == null) {
            this.previewUI = new PreviewBody(this);
        }
        return this.previewUI;
    }

    public KDStatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new KDStatusBar();
            this.statusBar.setCustomInsets(new Insets(0, 0, 0, 0));
            this.statusBar.setPreferredSize(new Dimension(100, 20));
            SimpleStatusBarPart sb = new SimpleStatusBarPart();
            sb.setBorder(null);
            this.statusBar.addPart(sb);
            this.statusBar.addRendererToPart((ISimpleStatusBarRenderer)new SimpleStatusBarRenderer(), (Object)"first", 0);
        }
        return this.statusBar;
    }

    public void firstShow() {
        this.previewUI.firstShow();
    }

    public void setToolbarConfigXmlUrl(String url) {
        this.previewUI.setToolbarConfigXmlUrl(url);
    }

    public void preview(Component parent, String title) {
        this.previewTitle = title;
        Window w = KDPrinterUtils.getWindowForComponent(parent);
        this.preview(w);
    }

    public void preview(Component parent) {
        this.preview(parent, null);
    }

    public void preview(Window parent) {
        if (this.windowType == 2) {
            this.previewInFrame(this.previewTitle);
        } else {
            this.previewInDialog(parent, this.previewTitle);
        }
    }

    public void previewInFrame(String title) {
        this.previewWindow = new PreviewWindow(this);
        this.previewWindow.showFrame(this, title);
    }

    public void previewInDialog(Component parent, String title, boolean modal) {
        this.previewWindow = new PreviewWindow(this);
        this.previewWindow.showDialog(this, parent, title, modal);
    }

    public void previewInDialog(Component parent, String title) {
        this.previewInDialog(parent, title, true);
    }

    public void dispose() {
        if (this.previewWindow != null) {
            this.previewWindow.dispose();
            this.previewWindow = null;
        }
        if (this.previewUI != null) {
            this.previewUI.clear();
        }
    }

    public boolean isPreviewing() {
        return this.previewWindow != null;
    }

    public Component getPreviewComponent() {
        return this.previewUI;
    }

    public ButtonItem getButtonItem(int category) {
        return this.getPreviewBar().getButtonItem(category);
    }

    public void update() {
        if (this.previewUI != null && this.isPreviewing()) {
            this.previewUI.updatePaper();
        }
    }

    public boolean isCloseWhenPrint() {
        return this.isCloseWhenPrint;
    }

    public void setCloseWhenPrint(boolean isClosewhenPrint) {
        this.isCloseWhenPrint = isClosewhenPrint;
    }

    public boolean isPrintDirect() {
        return this.isPrintDirect;
    }

    public void setPrintDirect(boolean isPrintDirect) {
        this.isPrintDirect = isPrintDirect;
    }

    public void setPageCount(int pageCount) {
        if (this.previewUI == null) {
            this.previewUI = new PreviewBody(this);
        }
        this.previewUI.setPageCount(pageCount);
    }

    public KDPrinter getPrinter() {
        return this.printer;
    }
}

